/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.wizards;

import com.quantum.Messages;
import com.quantum.model.JDBCDriver;
import com.quantum.wizards.PropertyChangeWizardPage;
import com.quantum.wizards.URLSetupControl;
import com.quantum.wizards.URLSetupControlFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

class BookmarkConnectionWizardPage
extends PropertyChangeWizardPage {
    private JDBCDriver driver;
    private String userid;
    private String password;
    private String connectionURL;
    private boolean prompt;
    private Label jdbcLabel;
    private Text jdbcUrl;
    private URLSetupControl urlSetupControl;
    private Composite container;
    private boolean requiresRebuild = false;
    private PropertyChangeListener listener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("connectionURL".equals(event.getPropertyName())) {
                BookmarkConnectionWizardPage.this.setConnectionURL((String)event.getNewValue());
                BookmarkConnectionWizardPage.this.updateButtonState();
            }
        }
    };

    public BookmarkConnectionWizardPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.getString(((Object)((Object)this)).getClass(), "title"));
        this.setDescription(Messages.getString(((Object)((Object)this)).getClass(), "description"));
    }

    public void createControl(Composite parent) {
        this.setPageComplete(false);
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText(Messages.getString(((Object)((Object)this)).getClass(), "userid"));
        Text username = new Text(container, 2052);
        GridData fullHorizontal = new GridData(768);
        username.setLayoutData((Object)fullHorizontal);
        username.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String userid = ((Text)event.getSource()).getText();
                BookmarkConnectionWizardPage.this.setUserid(userid);
                BookmarkConnectionWizardPage.this.updateButtonState();
            }
        });
        label = new Label(container, 0);
        label.setText(Messages.getString(((Object)((Object)this)).getClass(), "password"));
        final Text password = new Text(container, 2052);
        password.setEchoChar('*');
        fullHorizontal = new GridData(768);
        password.setLayoutData((Object)fullHorizontal);
        password.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String password = ((Text)event.getSource()).getText();
                BookmarkConnectionWizardPage.this.setPassword(password);
                BookmarkConnectionWizardPage.this.updateButtonState();
            }
        });
        Button prompt = new Button(container, 32);
        prompt.setText(Messages.getString(((Object)((Object)this)).getClass(), "prompt"));
        fullHorizontal = new GridData(768);
        fullHorizontal.horizontalSpan = 2;
        prompt.setLayoutData((Object)fullHorizontal);
        this.createStandardJDBCWidgets(container);
        prompt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button prompt = (Button)event.getSource();
                password.setEditable(!prompt.getSelection());
                BookmarkConnectionWizardPage.this.setPrompt(prompt.getSelection());
                BookmarkConnectionWizardPage.this.updateButtonState();
            }
        });
        this.container = container;
        this.setControl((Control)container);
    }

    public void setVisible(boolean visible) {
        if (visible && this.requiresRebuild) {
            this.rebuildJDBCControls(this.driver);
        }
        super.setVisible(visible);
    }

    private void createStandardJDBCWidgets(Composite container) {
        this.setConnectionURL("");
        this.jdbcLabel = new Label(container, 0);
        this.jdbcLabel.setText(Messages.getString(((Object)((Object)this)).getClass(), "url"));
        this.jdbcUrl = new Text(container, 2052);
        this.jdbcUrl.setLayoutData((Object)new GridData(768));
        this.jdbcUrl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                BookmarkConnectionWizardPage.this.setConnectionURL(((Text)event.getSource()).getText());
                BookmarkConnectionWizardPage.this.updateButtonState();
            }
        });
        this.updateButtonState();
    }

    public JDBCDriver getDriver() {
        return this.driver;
    }

    public void setDriver(JDBCDriver driver) {
        String oldDriverClassName = this.driver == null ? null : this.driver.getClassName();
        this.driver = driver;
        if (oldDriverClassName == null || !oldDriverClassName.equals(this.driver.getClassName())) {
            this.requiresRebuild = true;
        }
    }

    private void rebuildJDBCControls(JDBCDriver driver) {
        Point windowSize = this.getShell().getSize();
        Point oldSize = this.getShell().computeSize(-1, -1);
        if (URLSetupControlFactory.hasControl(driver)) {
            this.disposeOfCurrentJDBCControls();
            this.urlSetupControl = URLSetupControlFactory.create(driver, this.container);
            GridData data = new GridData(770);
            data.horizontalSpan = 2;
            this.urlSetupControl.setLayoutData(data);
            this.urlSetupControl.addPropertyChangeListener(this.listener);
            this.setConnectionURL(this.urlSetupControl.getConnectionURL());
            this.updateButtonState();
            this.resizeWindow(windowSize, oldSize);
            this.container.layout();
        } else if (this.jdbcLabel == null || this.jdbcUrl == null) {
            this.disposeOfCurrentJDBCControls();
            this.createStandardJDBCWidgets(this.container);
            this.resizeWindow(windowSize, oldSize);
            this.container.layout();
        }
        this.container.setVisible(true);
        this.container.redraw();
    }

    private void resizeWindow(Point windowSize, Point oldSize) {
        Point newSize = this.getShell().computeSize(-1, -1);
        if (newSize.y > windowSize.y) {
            this.getShell().setSize(new Point(windowSize.x, windowSize.y + (newSize.y - oldSize.y)));
        }
    }

    private void disposeOfCurrentJDBCControls() {
        if (this.jdbcUrl != null) {
            this.jdbcUrl.dispose();
            this.jdbcUrl = null;
        }
        if (this.jdbcLabel != null) {
            this.jdbcLabel.dispose();
            this.jdbcLabel = null;
        }
        if (this.urlSetupControl != null) {
            this.urlSetupControl.removePropertyChangeListener(this.listener);
            this.urlSetupControl.dispose();
            this.urlSetupControl = null;
        }
    }

    private void updateButtonState() {
        boolean complete = true;
        this.setPageComplete(complete &= this.connectionURL != null && this.connectionURL.trim().length() > 0);
    }

    public String getUserid() {
        return this.userid;
    }

    public void setUserid(String userid) {
        if (userid != null && !userid.equals(this.userid)) {
            String original = this.userid;
            this.userid = userid;
            this.firePropertyChange("userid", original, userid);
        }
    }

    public boolean isPrompt() {
        return this.prompt;
    }

    public void setPrompt(boolean prompt) {
        if (this.prompt != prompt) {
            boolean original = this.prompt;
            this.prompt = prompt;
            this.firePropertyChange("prompt", original, prompt);
        }
    }

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public void setConnectionURL(String connectionURL) {
        if (connectionURL != null && !connectionURL.equals(this.connectionURL)) {
            String original = this.connectionURL;
            this.connectionURL = connectionURL;
            this.firePropertyChange("connectionURL", original, connectionURL);
        }
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        if (password != null && !password.equals(this.password)) {
            String original = this.password;
            this.password = password;
            this.firePropertyChange("password", original, password);
        }
    }
}

