/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.view.widget;

import com.quantum.Messages;
import com.quantum.ui.dialog.ExceptionDisplayDialog;
import com.quantum.view.widget.ErrorMessageDisplayer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FileSelectionWidget
extends Composite {
    private Text fileName;
    private final ErrorMessageDisplayer displayer;
    private File file;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport((Object)this);
    private Button browseButton;

    public FileSelectionWidget(Composite parent, int style) {
        this(parent, style, null);
    }

    public FileSelectionWidget(Composite parent, int style, ErrorMessageDisplayer displayer) {
        super(parent, style);
        this.displayer = displayer;
        this.setLayout((Layout)new GridLayout(3, false));
        this.setLayoutData(new GridData(1808));
        Label label = new Label((Composite)this, 0);
        label.setText(Messages.getString(((Object)((Object)this)).getClass(), "fileName"));
        this.fileName = new Text((Composite)this, 2052);
        this.fileName.setLayoutData((Object)new GridData(768));
        this.browseButton = new Button((Composite)this, 8);
        this.browseButton.setText(Messages.getString(((Object)((Object)this)).getClass(), "browse"));
        this.browseButton.setLayoutData((Object)new GridData(256));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dialog = new FileDialog(FileSelectionWidget.this.getShell(), 8192);
                String filename = dialog.open();
                if (filename != null) {
                    FileSelectionWidget.this.fileName.setText(filename);
                    FileSelectionWidget.this.validate(filename);
                }
            }
        });
        this.fileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                FileSelectionWidget.this.validate(((Text)event.getSource()).getText());
            }
        });
    }

    private void validate(String fileName) {
        File file = new File(fileName);
        if (file.exists() && file.isFile()) {
            this.setErrorMessage(null);
            this.setFile(file);
        } else if (!file.exists() && !fileName.endsWith(File.separator)) {
            this.setErrorMessage(null);
            this.setFile(file);
        } else {
            this.setErrorMessage(Messages.getString(((Object)((Object)this)).getClass(), "invalidFileName"));
            this.setFile(null);
        }
    }

    private void setFile(File file) {
        File oldValue = this.file;
        this.file = file;
        this.propertyChangeSupport.firePropertyChange("file", oldValue, this.file);
    }

    private void setErrorMessage(String message) {
        if (this.displayer != null) {
            this.displayer.setErrorMessage(message);
        }
    }

    public File getFile() {
        return this.file;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.fileName.setEnabled(enabled);
        this.browseButton.setEnabled(enabled);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File createFile(InputStream initialContents) {
        try {
            if (this.file == null) return this.file;
            FileOutputStream output = new FileOutputStream(this.file);
            try {
                int c = initialContents.read();
                while (c >= 0) {
                    output.write(c);
                    c = initialContents.read();
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                output.close();
                throw throwable;
            }
            {
                Object var4_7 = null;
                output.close();
                return this.file;
            }
        }
        catch (IOException e) {
            ExceptionDisplayDialog.openError(this.getShell(), null, null, e);
        }
        return this.file;
    }
}

