/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.view.tableview;

import com.quantum.ImageStore;
import com.quantum.Messages;
import com.quantum.extensions.ExtensionAction;
import com.quantum.extensions.ProcessServiceMembers;
import com.quantum.model.Bookmark;
import com.quantum.sql.SQLResultSetResults;
import com.quantum.sql.TableRow;
import com.quantum.util.StringMatrix;
import com.quantum.util.versioning.VersioningHelper;
import com.quantum.view.tableview.ChangeEncodingAction;
import com.quantum.view.tableview.CloseAllResultSetsAction;
import com.quantum.view.tableview.CloseResultSetAction;
import com.quantum.view.tableview.CopyAction;
import com.quantum.view.tableview.FullModeAction;
import com.quantum.view.tableview.NextPageAction;
import com.quantum.view.tableview.PreviousPageAction;
import com.quantum.view.tableview.RefreshTableAction;
import com.quantum.view.tableview.ResultSetViewer;
import com.quantum.view.tableview.SelectAllAction;
import com.quantum.view.tableview.TableView;
import com.quantum.wizards.DeleteRowPage;
import com.quantum.wizards.InsertRowPage;
import com.quantum.wizards.SQLPage;
import com.quantum.wizards.SQLRowWizard;
import com.quantum.wizards.SortFilterPage;
import com.quantum.wizards.UpdateRowPage;
import com.quantum.wizards.ViewRowPage;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.SelectionListenerAction;

public class TableViewActionGroup
extends ActionGroup {
    private static final String OTHER_ENCODINGS_ACTION_CLASS_NAME = "com.quantum.view.tableview.OtherEncodingsAction";
    private final TableView tableView;
    private Action otherEncodingsAction;
    private SelectionListenerAction closeAction;
    private SelectionListenerAction closeAllAction;
    private SelectionListenerAction nextAction;
    private SelectionListenerAction previousAction;
    private SelectionListenerAction refreshAction;
    private SelectionListenerAction fullModeAction;
    private SelectionListenerAction defaultEncodingAction;
    private SelectionListenerAction utf8EncodingAction;
    private SelectionListenerAction utf16EncodingAction;
    private CopyAction copyAction;
    private SelectAllAction selectAllAction;
    private InsertAction insertRowAction;
    private DeleteAction deleteRowAction;
    private UpdateAction updateRowAction;
    private SortFilterAction sortFilterAction;
    private ViewAction viewAction;
    private Vector extensionActions = new Vector();
    static /* synthetic */ Class class$0;

    public TableViewActionGroup(TableView tableView) {
        this.tableView = tableView;
        this.closeAction = new CloseResultSetAction((IViewPart)this.tableView, this.tableView);
        this.closeAllAction = new CloseAllResultSetsAction((IViewPart)this.tableView, this.tableView);
        this.defaultEncodingAction = new ChangeEncodingAction((IViewPart)this.tableView, this.tableView, "", "default");
        this.utf8EncodingAction = new ChangeEncodingAction((IViewPart)this.tableView, this.tableView, "UTF-8", "utf8");
        this.utf16EncodingAction = new ChangeEncodingAction((IViewPart)this.tableView, this.tableView, "UTF-16", "utf16");
        if (VersioningHelper.getJDKVersion() >= 4) {
            this.createOtherEncodingsAction();
        }
        this.nextAction = new NextPageAction((IViewPart)this.tableView, this.tableView);
        this.previousAction = new PreviousPageAction((IViewPart)this.tableView, this.tableView);
        this.refreshAction = new RefreshTableAction((IViewPart)this.tableView, this.tableView);
        this.fullModeAction = new FullModeAction((IViewPart)this.tableView, this.tableView);
        this.copyAction = new CopyAction(this.tableView);
        this.selectAllAction = new SelectAllAction(this.tableView);
        this.insertRowAction = new InsertAction();
        this.deleteRowAction = new DeleteAction();
        this.updateRowAction = new UpdateAction();
        this.sortFilterAction = new SortFilterAction(this, this.tableView);
        this.viewAction = new ViewAction();
        try {
            ProcessServiceMembers.process((IViewPart)tableView, this.extensionActions);
        }
        catch (WorkbenchException e) {
            e.printStackTrace();
        }
    }

    private void createOtherEncodingsAction() {
        try {
            Class<?> action = Class.forName(OTHER_ENCODINGS_ACTION_CLASS_NAME);
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.quantum.view.tableview.TableView");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Constructor<?> constructor = action.getConstructor(classArray);
            this.otherEncodingsAction = (Action)constructor.newInstance(this.tableView);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoClassDefFoundError e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add((IAction)this.previousAction);
        toolBar.add((IAction)this.nextAction);
        toolBar.add((IAction)this.fullModeAction);
        toolBar.add((IAction)this.closeAction);
        toolBar.add((IAction)this.closeAllAction);
        toolBar.add((IAction)this.refreshAction);
        toolBar.add((IAction)this.sortFilterAction);
        actionBars.setGlobalActionHandler("copy", (IAction)this.copyAction);
        actionBars.setGlobalActionHandler("selectAll", (IAction)this.selectAllAction);
    }

    public void fillContextMenu(IMenuManager menuManager) {
        menuManager.add((IAction)this.defaultEncodingAction);
        menuManager.add((IAction)this.utf8EncodingAction);
        menuManager.add((IAction)this.utf16EncodingAction);
        if (this.otherEncodingsAction != null) {
            menuManager.add((IAction)this.otherEncodingsAction);
        }
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.copyAction);
        menuManager.add((IAction)this.selectAllAction);
        menuManager.add((IContributionItem)new Separator());
        this.getSelectedSQLResults();
        menuManager.add((IAction)this.insertRowAction);
        menuManager.add((IAction)this.updateRowAction);
        menuManager.add((IAction)this.deleteRowAction);
        menuManager.add((IAction)this.viewAction);
        menuManager.add((IContributionItem)new Separator());
        this.createExtensionMenu(menuManager);
        this.createMarkerForActionsProvidedByOtherPlugins(menuManager);
    }

    private SQLResultSetResults getSelectedSQLResults() {
        return this.tableView.getSelectedResultSet();
    }

    protected SQLResultSetResults.Row getSelectedRow() {
        IStructuredSelection selection = this.getTableRowSelection();
        return selection == null || selection.isEmpty() ? null : (SQLResultSetResults.Row)selection.getFirstElement();
    }

    private IStructuredSelection getTableRowSelection() {
        ResultSetViewer viewer = this.tableView.getSelectedResultSetViewer();
        IStructuredSelection selection = viewer == null ? null : (IStructuredSelection)viewer.getSelection();
        return selection;
    }

    private void createExtensionMenu(IMenuManager menuManager) {
        MenuManager subMenuExtension = new MenuManager("Extensions");
        int i = 0;
        while (i < this.extensionActions.size()) {
            ExtensionAction extensionAction = (ExtensionAction)((Object)this.extensionActions.get(i));
            extensionAction.addRowData(this.createTableRow());
            subMenuExtension.add((IAction)extensionAction);
            ++i;
        }
        if (this.extensionActions.size() > 0) {
            menuManager.add((IContributionItem)subMenuExtension);
        }
    }

    private TableRow createTableRow() {
        SQLResultSetResults results = this.tableView.getSelectedResultSet();
        IStructuredSelection selection = this.getTableRowSelection();
        if (results != null) {
            StringMatrix data = new StringMatrix();
            data.addMatrixHeader(results.getColumnNames());
            if (selection != null && !selection.isEmpty()) {
                int rowNumber = 0;
                Iterator i = selection.iterator();
                while (i.hasNext()) {
                    SQLResultSetResults.Row row = (SQLResultSetResults.Row)i.next();
                    int j = 1;
                    int length = results.getColumnCount();
                    while (j <= length) {
                        Object object = row.get(j);
                        data.addAt(results.getColumnName(j), object == null ? null : object.toString(), rowNumber);
                        ++j;
                    }
                    ++rowNumber;
                }
            } else {
                int i = 1;
                int length = results.getColumnCount();
                while (i <= length) {
                    data.addAt(results.getColumnName(i + 1), "", 0);
                    ++i;
                }
            }
            return new TableRow(results.getEntity(), (Bookmark)results.getConnectable(), results.getEntity() == null ? null : results.getEntity().getQualifiedName(), data);
        }
        return null;
    }

    private void createMarkerForActionsProvidedByOtherPlugins(IMenuManager menuManager) {
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IContributionItem)new Separator("additions-end"));
        menuManager.add((IContributionItem)new Separator());
    }

    abstract class SQLWizardAction
    extends SelectionListenerAction {
        protected SQLWizardAction(String text, ISelectionProvider selectionProvider) {
            super(text);
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            this.setEnabled(!selectionProvider.getSelection().isEmpty());
        }

        protected abstract SQLPage createSQLPage();

        protected abstract String getTitle();

        public void run() {
            SQLPage page = this.createSQLPage();
            SQLRowWizard wizard = new SQLRowWizard();
            wizard.init(this.getTitle(), page, TableViewActionGroup.this.getSelectedSQLResults(), TableViewActionGroup.this.getSelectedRow());
            WizardDialog dialog = new WizardDialog(TableViewActionGroup.this.tableView.getSite().getShell(), (IWizard)wizard);
            dialog.open();
        }

        protected boolean updateSelection(IStructuredSelection selection) {
            return selection != null && !selection.isEmpty();
        }
    }

    class SortFilterAction
    extends SQLWizardAction {
        final /* synthetic */ TableViewActionGroup this$0;
        static /* synthetic */ Class class$0;

        public SortFilterAction(TableViewActionGroup tableViewActionGroup, ISelectionProvider selectionProvider) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.quantum.view.tableview.TableViewActionGroup");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            super(Messages.getString(clazz, "filterSort"), selectionProvider);
            this.this$0 = tableViewActionGroup;
            this.setImageDescriptor(ImageStore.getImageDescriptor("filter"));
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("com.quantum.view.tableview.TableViewActionGroup");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.setToolTipText(Messages.getString(clazz2, "filterSort"));
            this.setEnabled(this.sortFilterApplies());
        }

        private boolean sortFilterApplies() {
            SQLResultSetResults results = this.this$0.getSelectedSQLResults();
            return results != null && !results.isMetaData() && results.getEntity() != null;
        }

        protected SQLPage createSQLPage() {
            return new SortFilterPage("page1");
        }

        protected String getTitle() {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.quantum.view.tableview.TableViewActionGroup");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return Messages.getString(clazz, "filterSort");
        }

        protected boolean updateSelection(IStructuredSelection selection) {
            return this.sortFilterApplies();
        }
    }

    class InsertAction
    extends Action {
        public InsertAction() {
            this.setText(Messages.getString("tableview.insert"));
        }

        public void run() {
            SQLResultSetResults resultSet = TableViewActionGroup.this.getSelectedSQLResults();
            if (resultSet == null || resultSet.isMetaData() || resultSet.getEntity() == null) {
                MessageDialog.openInformation((Shell)TableViewActionGroup.this.tableView.getSite().getShell(), (String)"Operation not allowed", (String)"You cannot insert rows in this recordset");
                return;
            }
            InsertRowPage page = new InsertRowPage("");
            SQLRowWizard wizard = new SQLRowWizard();
            wizard.init(Messages.getString("TableView.InsertRow"), page, TableViewActionGroup.this.getSelectedSQLResults(), null);
            WizardDialog dialog = new WizardDialog(TableViewActionGroup.this.tableView.getSite().getShell(), (IWizard)wizard);
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                TableViewActionGroup.this.refreshAction.run();
            }
        }
    }

    class DeleteAction
    extends Action {
        public DeleteAction() {
            this.setText(Messages.getString("tableview.delete"));
        }

        public void run() {
            SQLResultSetResults resultSet = TableViewActionGroup.this.getSelectedSQLResults();
            if (resultSet == null || resultSet.isMetaData() || resultSet.getEntity() == null) {
                MessageDialog.openInformation((Shell)TableViewActionGroup.this.tableView.getSite().getShell(), (String)"Operation not allowed", (String)"You cannot delete rows in this recordset");
                return;
            }
            DeleteRowPage page = new DeleteRowPage("");
            SQLRowWizard wizard = new SQLRowWizard();
            wizard.init(Messages.getString("TableView.DeleteRow"), page, TableViewActionGroup.this.getSelectedSQLResults(), TableViewActionGroup.this.getSelectedRow());
            WizardDialog dialog = new WizardDialog(TableViewActionGroup.this.tableView.getSite().getShell(), (IWizard)wizard);
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                TableViewActionGroup.this.refreshAction.run();
            }
        }
    }

    class UpdateAction
    extends Action {
        public UpdateAction() {
            this.setText(Messages.getString("tableview.update"));
        }

        public void run() {
            SQLResultSetResults resultSet = TableViewActionGroup.this.getSelectedSQLResults();
            if (resultSet == null || resultSet.isMetaData() || resultSet.getEntity() == null) {
                MessageDialog.openInformation((Shell)TableViewActionGroup.this.tableView.getSite().getShell(), (String)"Operation not allowed", (String)"You cannot update rows in this recordset");
                return;
            }
            UpdateRowPage page = new UpdateRowPage("");
            SQLRowWizard wizard = new SQLRowWizard();
            wizard.init(Messages.getString("TableView.UpdateRow"), page, TableViewActionGroup.this.getSelectedSQLResults(), TableViewActionGroup.this.getSelectedRow());
            WizardDialog dialog = new WizardDialog(TableViewActionGroup.this.tableView.getSite().getShell(), (IWizard)wizard);
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                TableViewActionGroup.this.refreshAction.run();
            }
        }
    }

    class ViewAction
    extends Action {
        public ViewAction() {
            this.setText(Messages.getString("tableview.view"));
        }

        public void run() {
            ViewRowPage page = new ViewRowPage("");
            SQLRowWizard wizard = new SQLRowWizard();
            wizard.init(Messages.getString("TableView.ViewRow"), page, TableViewActionGroup.this.getSelectedSQLResults(), TableViewActionGroup.this.getSelectedRow());
            WizardDialog dialog = new WizardDialog(TableViewActionGroup.this.tableView.getSite().getShell(), (IWizard)wizard);
            dialog.open();
        }
    }
}

