/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.view.tableview;

import com.quantum.ImageStore;
import com.quantum.Messages;
import com.quantum.sql.SQLResultSetResults;
import com.quantum.sql.Scrollable;
import com.quantum.view.tableview.TableView;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ResultSetViewer
implements PropertyChangeListener {
    private final SQLResultSetResults resultSet;
    private TableViewer tableViewer;
    private TabItem tabItem;
    private final TableView tableView;

    public ResultSetViewer(TableView tableView, SQLResultSetResults resultSet) {
        this.tableView = tableView;
        this.resultSet = resultSet;
        this.createControl();
        this.resultSet.addPropertyChangeListener(this);
    }

    public TabItem getTabItem() {
        return this.tabItem;
    }

    public Table getTable() {
        return this.tableViewer.getTable();
    }

    protected void createControl() {
        this.tabItem = new TabItem(this.tableView.tabs, 0);
        int index = this.tableView.tabs.getItems().length;
        Composite composite = new Composite((Composite)this.tableView.tabs, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        if (this.resultSet.getEntity() == null) {
            this.tabItem.setImage(ImageStore.getImage("script"));
            this.tabItem.setText(this.resultSet.getConnectable().getDisplayName());
            this.tabItem.setToolTipText(this.resultSet.getQuery());
        } else if (this.resultSet.isMetaData()) {
            this.tabItem.setImage(ImageStore.getImage("table_details"));
            this.tabItem.setText(String.valueOf(this.resultSet.getConnectable().getDisplayName()) + ":" + this.resultSet.getEntity().getQualifiedName());
            this.tabItem.setToolTipText(this.resultSet.getEntity().getQualifiedName());
        } else {
            this.tabItem.setImage(ImageStore.getImage("bigtable"));
            this.tabItem.setText(String.valueOf(this.resultSet.getConnectable().getDisplayName()) + ":" + this.resultSet.getEntity().getQualifiedName());
            this.tabItem.setToolTipText(this.resultSet.getEntity().getQualifiedName());
        }
        this.createTable(composite);
        this.tabItem.setControl((Control)composite);
        this.initializePopUpMenu();
        this.tableView.tabs.setSelection(index - 1);
    }

    private void createTable(Composite composite) {
        Table table = new Table(composite, 67586);
        table.setLayout((Layout)new GridLayout());
        table.setLayoutData((Object)new GridData(1808));
        this.addColumnsToTable(table);
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProviderImpl());
        this.tableViewer.setContentProvider((IContentProvider)new ContentProviderImpl());
        this.tableViewer.setInput((Object)this.resultSet);
        this.packColumns(table);
    }

    private void packColumns(Table table) {
        int i = 0;
        while (i < table.getColumnCount()) {
            table.getColumn(i).pack();
            ++i;
        }
    }

    private int addColumnsToTable(Table table) {
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        int columnCount = this.resultSet.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(this.resultSet.getColumnName(i + 1).toString());
            ++i;
        }
        return columnCount;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("rows".equals(event.getPropertyName())) {
            this.tableViewer.refresh();
        } else if ("columns".equals(event.getPropertyName())) {
            Table table = this.tableViewer.getTable();
            TableColumn[] columns = table.getColumns();
            int i = 0;
            int length = columns == null ? 0 : columns.length;
            while (i < length) {
                columns[i].dispose();
                ++i;
            }
            this.addColumnsToTable(table);
            this.tableViewer.setInput((Object)this.resultSet);
            this.packColumns(table);
            table.layout();
        }
        this.updateStatusLine();
    }

    public void dispose() {
        this.resultSet.removePropertyChangeListener(this);
        this.tabItem.dispose();
    }

    protected SQLResultSetResults getResultSet() {
        return this.resultSet;
    }

    private void initializePopUpMenu() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                ((ResultSetViewer)ResultSetViewer.this).tableView.actionGroup.fillContextMenu(menuManager);
            }
        });
        Menu contextMenu = manager.createContextMenu(this.tableViewer.getControl());
        this.tableViewer.getControl().setMenu(contextMenu);
        this.tableView.getSite().registerContextMenu(manager, (ISelectionProvider)this.tableView);
    }

    protected void updateStatusLine() {
        if (this == this.tableView.getSelectedResultSetViewer()) {
            IStatusLineManager statusLine = this.tableView.getViewSite().getActionBars().getStatusLineManager();
            if (this.resultSet != null && this.resultSet instanceof Scrollable) {
                Scrollable scrollable = (Scrollable)((Object)this.resultSet);
                int start = scrollable.getStart();
                int end = scrollable.getEnd();
                int last = scrollable.getLast();
                statusLine.setMessage(Messages.getString(this.getClass(), "position", new String[]{String.valueOf(start), String.valueOf(end), last < 0 ? Messages.getString(this.getClass(), "unknown") : String.valueOf(last)}));
            } else {
                statusLine.setMessage("");
            }
        }
    }

    protected ISelection getSelection() {
        return this.tableViewer.getSelection();
    }

    class LabelProviderImpl
    implements ITableLabelProvider {
        LabelProviderImpl() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Object value = null;
            if (element instanceof SQLResultSetResults.Row) {
                value = ((SQLResultSetResults.Row)element).get(columnIndex + 1);
            }
            return value == null ? "" : value.toString();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class ContentProviderImpl
    implements IStructuredContentProvider {
        ContentProviderImpl() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof SQLResultSetResults) {
                return ((SQLResultSetResults)inputElement).getRows();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

