/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.view.tableview;

import com.quantum.sql.SQLResultSetResults;
import com.quantum.ui.dialog.ConnectionUtil;
import com.quantum.ui.dialog.ExceptionDisplayDialog;
import com.quantum.ui.dialog.SQLExceptionDialog;
import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.SelectionListenerAction;

public abstract class ResultSetAction
extends SelectionListenerAction {
    private IViewPart view;
    private ConnectionUtil connectionUtil = new ConnectionUtil();
    private final ISelectionProvider selectionProvider;

    public ResultSetAction(IViewPart view, ISelectionProvider selectionProvider) {
        super("");
        this.selectionProvider = selectionProvider;
        this.view = view;
        this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void run() {
        try {
            IStructuredSelection selection = (IStructuredSelection)this.selectionProvider.getSelection();
            if (!selection.isEmpty()) {
                SQLResultSetResults results = (SQLResultSetResults)selection.getFirstElement();
                this.executeResultSetAction(results);
            }
        }
        catch (SQLException e) {
            SQLExceptionDialog.openException(this.getShell(), null, e);
        }
        catch (RuntimeException e) {
            ExceptionDisplayDialog.openError(this.getShell(), null, null, e);
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return selection != null && !selection.isEmpty();
    }

    protected abstract void executeResultSetAction(SQLResultSetResults var1) throws SQLException;

    protected Connection getConnection(SQLResultSetResults results) {
        return this.connectionUtil.connect(results.getConnectable(), this.getShell());
    }

    private Shell getShell() {
        return this.view.getSite().getShell();
    }
}

