/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.view.tableview;

import com.quantum.ImageStore;
import com.quantum.Messages;
import com.quantum.sql.SQLResultSetResults;
import com.quantum.sql.Scrollable;
import com.quantum.view.tableview.ResultSetAction;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewPart;

public class NextPageAction
extends ResultSetAction
implements PropertyChangeListener {
    private SQLResultSetResults resultSet;

    public NextPageAction(IViewPart view, ISelectionProvider selectionProvider) {
        super(view, selectionProvider);
        this.setText(Messages.getString(this.getClass(), "text"));
        this.setImageDescriptor(ImageStore.getImageDescriptor("next"));
        this.setToolTipText(Messages.getString(this.getClass(), "text"));
        this.setEnabled(this.hasNextPage((IStructuredSelection)selectionProvider.getSelection()));
    }

    protected void executeResultSetAction(SQLResultSetResults results) throws SQLException {
        if (results instanceof Scrollable) {
            ((Scrollable)((Object)results)).nextPage(this.getConnection(results));
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        this.setResultSet(this.getResultSet(selection));
        return this.hasNextPage(selection);
    }

    private void setResultSet(SQLResultSetResults results) {
        if (this.resultSet != null) {
            this.resultSet.removePropertyChangeListener(this);
        }
        this.resultSet = results;
        if (results != null) {
            this.resultSet.addPropertyChangeListener(this);
        }
    }

    private SQLResultSetResults getResultSet(IStructuredSelection selection) {
        return selection != null && !selection.isEmpty() && selection.getFirstElement() instanceof SQLResultSetResults ? (SQLResultSetResults)selection.getFirstElement() : null;
    }

    private boolean hasNextPage(IStructuredSelection selection) {
        return !selection.isEmpty() && selection.getFirstElement() instanceof Scrollable && ((Scrollable)selection.getFirstElement()).hasNextPage();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("rows".equals(event.getPropertyName())) {
            this.setEnabled(this.hasNextPage(this.getStructuredSelection()));
        }
    }
}

