/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.view.subset;

import com.quantum.ImageStore;
import com.quantum.Messages;
import com.quantum.QuantumPlugin;
import com.quantum.actions.CustomCopyAction;
import com.quantum.actions.DeleteColumnAction;
import com.quantum.actions.DeleteObjectAction;
import com.quantum.actions.DeleteSubsetAction;
import com.quantum.actions.NewSubsetAction;
import com.quantum.actions.ViewTableAction;
import com.quantum.view.bookmark.ColumnNode;
import com.quantum.view.bookmark.TreeNode;
import com.quantum.view.subset.ObjectNode;
import com.quantum.view.subset.SubsetContentProvider;
import com.quantum.view.subset.SubsetLabelProvider;
import com.quantum.view.subset.SubsetNode;
import com.quantum.view.subset.SubsetRoot;
import java.io.IOException;
import java.io.StringReader;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.part.ViewPart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SubsetView
extends ViewPart {
    private SubsetContentProvider provider = SubsetContentProvider.getInstance();
    private NewSubsetAction newSubsetAction;
    private DeleteSubsetAction deleteSubsetAction;
    private DeleteObjectAction deleteObjectAction;
    private DeleteColumnAction deleteColumnAction;
    private CustomCopyAction customCopyAction;
    private ViewTableAction viewTableAction;
    private static SubsetView instance = null;
    private TreeViewer treeViewer;
    private Label status;
    private Action pasteAction = new Action(){

        public void run() {
            Document doc;
            Object sel = SubsetView.this.getCurrent();
            if (sel == null) {
                return;
            }
            if (!(sel instanceof SubsetNode)) {
                return;
            }
            SubsetNode subset = (SubsetNode)sel;
            TextTransfer transfer = TextTransfer.getInstance();
            String xmlMetaData = (String)QuantumPlugin.getDefault().getSysClip().getContents((Transfer)transfer);
            StringReader text = new StringReader(xmlMetaData);
            InputSource source = new InputSource(text);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder parser = factory.newDocumentBuilder();
                doc = parser.parse(source);
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
                return;
            }
            catch (SAXException e) {
                e.printStackTrace();
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            Element root = doc.getDocumentElement();
            subset.importXML(root, false);
            SubsetView.this.treeViewer.refresh();
            SubsetView.this.provider.setHasChanged(true);
        }
    };

    public static synchronized SubsetView getInstance() {
        return instance;
    }

    public Object getCurrent() {
        if (this.treeViewer == null) {
            return null;
        }
        return ((StructuredSelection)this.treeViewer.getSelection()).getFirstElement();
    }

    public StructuredSelection getSelection() {
        if (this.treeViewer == null) {
            return null;
        }
        return (StructuredSelection)this.treeViewer.getSelection();
    }

    public SubsetNode getCurrentSubset() {
        TreeNode current = (TreeNode)this.getCurrent();
        return SubsetView.getRoot(current);
    }

    private static SubsetNode getRoot(TreeNode node) {
        while (!(node instanceof SubsetNode)) {
            node = node.getParent();
        }
        return (SubsetNode)node;
    }

    public void deleteCurrent() {
        this.provider.removeSubset(this.getCurrentSubset());
        this.treeViewer.refresh();
    }

    public void refreshSubsetData() {
    }

    public void expandCurrent(SubsetNode node) {
        this.treeViewer.setExpandedState((Object)node, true);
        this.treeViewer.refresh((Object)node, false);
    }

    public void refresh() {
        this.treeViewer.refresh();
    }

    public void disconnect() {
    }

    public void createPartControl(Composite parent) {
        instance = this;
        this.initActions();
        Composite main = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        main.setLayout((Layout)layout);
        this.treeViewer = new TreeViewer(main);
        this.treeViewer.setContentProvider((IContentProvider)this.provider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new SubsetLabelProvider());
        this.treeViewer.setInput((Object)SubsetRoot.ROOT);
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        Menu fTextContextMenu = manager.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(fTextContextMenu);
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object sel = SubsetView.this.getCurrent();
                if (sel instanceof ObjectNode) {
                    SubsetView.this.viewTableAction.run();
                }
            }
        });
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                Object sel = SubsetView.this.getCurrent();
                if (sel instanceof SubsetNode) {
                    mgr.add((IAction)SubsetView.this.deleteSubsetAction);
                    SubsetView.this.deleteSubsetAction.setText(Messages.getString("SubsetView.Delete"));
                    SubsetView.this.deleteSubsetAction.setImageDescriptor(ImageStore.getImageDescriptor("delete"));
                    mgr.add((IAction)SubsetView.this.pasteAction);
                    SubsetView.this.pasteAction.setText(Messages.getString("SubsetView.Paste"));
                    SubsetView.this.pasteAction.setImageDescriptor(ImageStore.getImageDescriptor("paste"));
                } else if (sel instanceof ObjectNode) {
                    mgr.add((IAction)SubsetView.this.deleteObjectAction);
                    SubsetView.this.deleteObjectAction.setText(Messages.getString("SubsetView.Delete"));
                    SubsetView.this.deleteObjectAction.setImageDescriptor(ImageStore.getImageDescriptor("delete"));
                    mgr.add((IAction)SubsetView.this.viewTableAction);
                    SubsetView.this.viewTableAction.setText(Messages.getString("bookmarkview.viewTable"));
                    SubsetView.this.viewTableAction.setImageDescriptor(ImageStore.getImageDescriptor("table"));
                    SubsetView.this.customCopyAction.selectionChanged((IStructuredSelection)SubsetView.this.treeViewer.getSelection());
                    mgr.add((IAction)SubsetView.this.customCopyAction);
                } else if (sel instanceof ColumnNode) {
                    mgr.add((IAction)SubsetView.this.deleteColumnAction);
                    SubsetView.this.deleteColumnAction.setText(Messages.getString("SubsetView.Delete"));
                    SubsetView.this.deleteColumnAction.setImageDescriptor(ImageStore.getImageDescriptor("delete"));
                    SubsetView.this.customCopyAction.selectionChanged((IStructuredSelection)SubsetView.this.treeViewer.getSelection());
                    mgr.add((IAction)SubsetView.this.customCopyAction);
                } else {
                    mgr.add((IAction)SubsetView.this.newSubsetAction);
                }
            }
        });
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.treeViewer.getControl().setLayoutData((Object)gridData);
        this.status = new Label(main, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.status.setLayoutData((Object)gridData);
        IActionBars bars = this.getViewSite().getActionBars();
        bars.setGlobalActionHandler("paste", (IAction)this.pasteAction);
        bars.setGlobalActionHandler("delete", (IAction)this.deleteSubsetAction);
        IToolBarManager toolBar = this.getViewSite().getActionBars().getToolBarManager();
        toolBar.add((IAction)this.newSubsetAction);
        this.status.setText(Messages.getString("bookmarkview.done"));
    }

    public void initActions() {
        this.newSubsetAction = new NewSubsetAction();
        this.newSubsetAction.setText("New Subset");
        this.newSubsetAction.setToolTipText(Messages.getString("SubsetView.CreatesANewEmptySubset"));
        this.newSubsetAction.setImageDescriptor(ImageStore.getImageDescriptor("subset"));
        this.newSubsetAction.init((IViewPart)this);
        this.deleteColumnAction = new DeleteColumnAction();
        this.deleteColumnAction.setText("Delete Column");
        this.deleteColumnAction.setToolTipText(Messages.getString("SubsetView.DeletesTheSelectedColumns"));
        this.deleteColumnAction.setImageDescriptor(ImageStore.getImageDescriptor("delete"));
        this.deleteColumnAction.init((IViewPart)this);
        this.deleteObjectAction = new DeleteObjectAction();
        this.deleteObjectAction.setText("Delete Object");
        this.deleteObjectAction.setToolTipText(Messages.getString("SubsetView.DeletesTheSelectedObject"));
        this.deleteObjectAction.setImageDescriptor(ImageStore.getImageDescriptor("delete"));
        this.deleteObjectAction.init((IViewPart)this);
        this.deleteSubsetAction = new DeleteSubsetAction();
        this.deleteSubsetAction.setText("Delete Subset");
        this.deleteSubsetAction.setToolTipText(Messages.getString("SubsetView.DeletesTheSelectedSubset"));
        this.deleteSubsetAction.setImageDescriptor(ImageStore.getImageDescriptor("delete"));
        this.deleteSubsetAction.init((IViewPart)this);
        this.customCopyAction = new CustomCopyAction(1);
        this.customCopyAction.setText(Messages.getString("bookmarkview.customCopyAction"));
        this.customCopyAction.setImageDescriptor(ImageStore.getImageDescriptor("copy"));
    }

    public void setFocus() {
    }

    public void addNewSubset(SubsetNode subset) {
        this.provider.addSubset(subset);
        this.treeViewer.refresh();
    }

    public void setStatus(String text) {
        this.status.setText(text);
    }

    public void dispose() {
        super.dispose();
    }

    public Vector getElements() {
        Vector<SubsetNode> result = new Vector<SubsetNode>();
        if (this.treeViewer == null) {
            return result;
        }
        SubsetContentProvider provider = (SubsetContentProvider)this.treeViewer.getContentProvider();
        Object[] objects = provider.getElements(SubsetRoot.ROOT);
        int i = 0;
        while (i < objects.length) {
            SubsetNode current = (SubsetNode)objects[i];
            result.add(current);
            ++i;
        }
        return result;
    }

    public void deleteColumn(ColumnNode column) {
        this.provider.deleteColumn(column);
        this.treeViewer.refresh();
    }

    public void deleteObject(ObjectNode object) {
        this.provider.deleteObject(object);
        this.treeViewer.refresh();
    }
}

