/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.view.bookmark;

import com.quantum.ImageStore;
import com.quantum.model.Bookmark;
import com.quantum.model.BookmarkHolder;
import com.quantum.util.connection.NotConnectedException;
import com.quantum.view.bookmark.LabelDecorationInstructions;
import java.beans.PropertyChangeEvent;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.graphics.Image;

public abstract class TreeNode
implements BookmarkHolder,
Comparable,
IAdaptable {
    private TreeNode parent = null;
    protected Vector children = new Vector();
    private boolean disposed = false;

    public TreeNode(TreeNode parent) {
        this.parent = parent;
    }

    public abstract Object[] getChildren() throws NotConnectedException, SQLException;

    public TreeNode getParent() {
        return this.parent;
    }

    public abstract boolean hasChildren();

    public abstract String getName();

    public Bookmark getBookmark() {
        return this.getParent() == null ? null : this.getParent().getBookmark();
    }

    public String getLabelName() {
        return this.getName();
    }

    public Image getImage() {
        return ImageStore.getImage(this.getImageName());
    }

    protected abstract String getImageName();

    public int compareTo(Object object) {
        TreeNode that = (TreeNode)object;
        return this.getLabelName().toLowerCase().compareTo(that.getLabelName().toLowerCase());
    }

    public String toString() {
        return this.getLabelName();
    }

    public String getLabelDecorations(LabelDecorationInstructions labelDecorationInstructions) {
        return null;
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.firePropertyChange(new PropertyChangeEvent(this, propertyName, oldValue, newValue));
    }

    protected void firePropertyChange(PropertyChangeEvent event) {
        TreeNode parent = this.getParent();
        if (parent != null && !this.disposed) {
            parent.firePropertyChange(event);
        }
    }

    protected void dispose() {
        this.disposed = true;
        this.removeAllChildren();
    }

    protected void removeAllChildren() {
        Iterator i = this.children.iterator();
        while (i.hasNext()) {
            TreeNode element = (TreeNode)i.next();
            element.dispose();
        }
    }

    protected boolean isInitialized() {
        return !this.children.isEmpty();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    protected abstract void initializeChildren() throws SQLException, NotConnectedException;

    public void reload() throws NotConnectedException, SQLException {
        if (this.isInitialized()) {
            this.initializeChildren();
            Iterator i = this.children.iterator();
            while (i.hasNext()) {
                ((TreeNode)i.next()).reload();
            }
        }
    }
}

