/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.view.bookmark;

import com.quantum.Messages;
import com.quantum.QuantumPlugin;
import com.quantum.extensions.ExtensionAction;
import com.quantum.extensions.ProcessServiceMembers;
import com.quantum.view.bookmark.BookmarkContentProvider;
import com.quantum.view.bookmark.BookmarkLabelProvider;
import com.quantum.view.bookmark.BookmarkListNode;
import com.quantum.view.bookmark.BookmarkNode;
import com.quantum.view.bookmark.BookmarkViewActionGroup;
import com.quantum.view.bookmark.ColumnNode;
import com.quantum.view.bookmark.EntityNode;
import com.quantum.view.bookmark.ProcedureNode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.part.ViewPart;

public class BookmarkView
extends ViewPart
implements PropertyChangeListener {
    private Vector extensionVector;
    private BookmarkViewActionGroup actionGroup;
    private TreeViewer treeViewer;
    private BookmarkLabelProvider labelProvider = new BookmarkLabelProvider();

    public static synchronized BookmarkView getInstance() {
        return (BookmarkView)QuantumPlugin.getDefault().getView("com.quantum.view.bookmarkview");
    }

    private Object getCurrent() {
        if (this.treeViewer == null) {
            return null;
        }
        return ((StructuredSelection)this.treeViewer.getSelection()).getFirstElement();
    }

    public StructuredSelection getSelection() {
        if (this.treeViewer == null) {
            return null;
        }
        return (StructuredSelection)this.treeViewer.getSelection();
    }

    public void refresh() {
        this.treeViewer.refresh();
    }

    public void createPartControl(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 770);
        this.treeViewer.setContentProvider((IContentProvider)new BookmarkContentProvider((IViewPart)this));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        BookmarkListNode input = BookmarkListNode.getInstance();
        this.treeViewer.setInput((Object)input);
        this.initActions();
        input.addPropertyChangeListener(this);
        this.initializePopUpMenu();
        this.fillActionBars();
        this.treeViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                ActionContext context = new ActionContext((ISelection)BookmarkView.this.getSelection());
                BookmarkView.this.actionGroup.setContext(context);
                IAction action = BookmarkView.this.actionGroup.getOpenAction();
                if (action != null) {
                    action.run();
                }
            }
        });
        DragSource ds = new DragSource((Control)this.treeViewer.getTree(), 17);
        ds.setTransfer(new Transfer[]{TextTransfer.getInstance(), TemplateTransfer.getInstance()});
        ds.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                event.doit = BookmarkView.this.treeViewer.getTree().getSelection()[0].getText().length() != 0;
            }

            public void dragSetData(DragSourceEvent event) {
                StructuredSelection ss;
                if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                    ss = (StructuredSelection)BookmarkView.this.treeViewer.getSelection();
                    if (ss.getFirstElement() instanceof EntityNode) {
                        event.data = " " + BookmarkView.this.treeViewer.getTree().getSelection()[0].getText() + " ";
                    } else if (ss.getFirstElement() instanceof ColumnNode) {
                        ColumnNode c = (ColumnNode)ss.getFirstElement();
                        event.data = " " + c.getName() + ", ";
                    } else if (ss.getFirstElement() instanceof ProcedureNode) {
                        ProcedureNode p = (ProcedureNode)ss.getFirstElement();
                        event.data = " " + p.getName() + " (";
                    }
                }
                if (TemplateTransfer.getInstance().isSupportedType(event.dataType)) {
                    ss = (StructuredSelection)BookmarkView.this.treeViewer.getSelection();
                    event.data = ss.getFirstElement();
                }
            }
        });
    }

    private void fillActionBars() {
        Action enableTableSizes = new Action(){

            public void run() {
                BookmarkView.this.labelProvider.getLabelDecorationInstructions().setSizeVisible(this.isChecked());
                BookmarkView.this.treeViewer.refresh();
            }
        };
        enableTableSizes.setText(Messages.getString("BookmarkView.ShowTableSizes"));
        enableTableSizes.setChecked(false);
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.getMenuManager().add((IAction)enableTableSizes);
        Action showDatabaseData = new Action(){

            public void run() {
                BookmarkView.this.labelProvider.getLabelDecorationInstructions().setDatabaseDataVisible(this.isChecked());
                BookmarkView.this.treeViewer.refresh();
            }
        };
        showDatabaseData.setText(Messages.getString("BookmarkView.ShowDatabaseData"));
        showDatabaseData.setChecked(false);
        actionBars.getMenuManager().add((IAction)showDatabaseData);
        this.actionGroup.fillActionBars(actionBars);
    }

    private void initializePopUpMenu() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                BookmarkView.this.fillContextMenu(mgr);
            }
        });
        Menu fTextContextMenu = manager.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(fTextContextMenu);
        this.getSite().registerContextMenu(manager, (ISelectionProvider)this.treeViewer);
    }

    public void initActions() {
        this.actionGroup = new BookmarkViewActionGroup((IViewPart)this, (ISelectionProvider)this.treeViewer);
        this.extensionVector = new Vector();
        try {
            ProcessServiceMembers.process((IViewPart)this, this.extensionVector);
        }
        catch (WorkbenchException e) {
            e.printStackTrace();
        }
    }

    public void dispose() {
        super.dispose();
        BookmarkListNode.getInstance().removePropertyChangeListener(this);
    }

    public Shell getShell() {
        return this.getSite().getShell();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("bookmarks".equals(event.getPropertyName())) {
            this.refresh();
        } else if ("name".equals(event.getPropertyName()) && event.getSource() instanceof BookmarkNode) {
            this.refresh();
        } else if ("connected".equals(event.getPropertyName())) {
            this.treeViewer.refresh(event.getSource());
            if (Boolean.TRUE.equals(event.getNewValue())) {
                this.treeViewer.setExpandedState(event.getSource(), true);
            }
        } else {
            this.treeViewer.refresh(event.getSource());
        }
    }

    private void fillContextMenu(IMenuManager mgr) {
        EntityNode entityNode;
        StructuredSelection selection = this.getSelection();
        ActionContext context = new ActionContext((ISelection)selection);
        this.actionGroup.setContext(context);
        this.actionGroup.fillContextMenu(mgr);
        Object sel = this.getCurrent();
        if (sel instanceof EntityNode && !(entityNode = (EntityNode)sel).isSequence()) {
            MenuManager subMenuExtension = new MenuManager("Extensions");
            int i = 0;
            while (i < this.extensionVector.size()) {
                ExtensionAction extensionAction = (ExtensionAction)((Object)this.extensionVector.get(i));
                subMenuExtension.add((IAction)extensionAction);
                ++i;
            }
            if (this.extensionVector.size() > 0) {
                mgr.add((IContributionItem)subMenuExtension);
            }
        }
    }

    public void setFocus() {
    }
}

