/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.view.bookmark;

import com.quantum.model.Bookmark;
import com.quantum.model.BookmarkCollection;
import com.quantum.view.bookmark.BookmarkNode;
import com.quantum.view.bookmark.TreeNode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;

public final class BookmarkListNode
extends TreeNode
implements PropertyChangeListener {
    static final BookmarkListNode instance = new BookmarkListNode();
    static final TreeNode[] EMPTY_ARRAY = new TreeNode[0];
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private boolean initialized = false;

    private BookmarkListNode() {
        super(null);
    }

    public static BookmarkListNode getInstance() {
        return instance;
    }

    public Object[] getChildren() {
        if (!this.initialized) {
            this.initializeChildren();
            BookmarkCollection.getInstance().addPropertyChangeListener(this);
        }
        Object[] nodes = this.children.toArray(new BookmarkNode[this.children.size()]);
        Arrays.sort(nodes);
        return nodes;
    }

    public boolean hasChildren() {
        return true;
    }

    public String getName() {
        return "ROOT";
    }

    protected String getImageName() {
        return null;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    protected void firePropertyChange(PropertyChangeEvent event) {
        this.propertyChangeSupport.firePropertyChange(event);
    }

    protected synchronized void initializeChildren() {
        boolean changed = false;
        Hashtable<String, BookmarkNode> temp = new Hashtable<String, BookmarkNode>();
        Iterator i = this.children.iterator();
        while (i.hasNext()) {
            BookmarkNode bookmark = (BookmarkNode)i.next();
            temp.put(bookmark.getName(), bookmark);
        }
        this.children.clear();
        Bookmark[] bookmarks = BookmarkCollection.getInstance().getBookmarks();
        int i2 = 0;
        int length = bookmarks == null ? 0 : bookmarks.length;
        while (i2 < length) {
            BookmarkNode node = (BookmarkNode)temp.remove(bookmarks[i2].getName());
            if (node == null) {
                this.children.add(new BookmarkNode(this, bookmarks[i2]));
                changed = true;
            } else {
                this.children.add(node);
            }
            ++i2;
        }
        Iterator i22 = temp.values().iterator();
        while (i22.hasNext()) {
            ((TreeNode)i22.next()).dispose();
            changed = true;
        }
        Collections.sort(this.children);
        this.initialized = true;
        if (temp.size() > 0 || changed) {
            this.firePropertyChange("bookmarks", null, null);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("bookmarks".equals(event.getPropertyName())) {
            this.initializeChildren();
        }
    }
}

