/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.view.beanshell;

import com.quantum.ImageStore;
import com.quantum.Messages;
import com.quantum.log.QuantumLog;
import com.quantum.util.StringUtil;
import com.quantum.view.ViewHelper;
import com.quantum.view.beanshell.BeanShellView;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class ExportOutputAction
extends Action
implements IViewActionDelegate {
    BeanShellView view;

    public ExportOutputAction() {
        this.setImageDescriptor(ImageStore.getImageDescriptor("export"));
        this.setText(Messages.getString("beanshellview.exportOutput"));
        this.setToolTipText(Messages.getString("beanshellview.exportOutput"));
    }

    public void init(IViewPart view) {
        this.view = (BeanShellView)view;
    }

    public void run(IAction action) {
        this.run();
    }

    public void run() {
        FileOutputStream out = ViewHelper.askSaveFile("exportoutput", this.view.getSite().getShell(), new String[]{"*.txt", "*.*"}, new String[]{Messages.getString("filedialog.textFiles"), Messages.getString("filedialog.allfiles")});
        if (out == null) {
            return;
        }
        try {
            FileWriter fileWriter = new FileWriter(out.getFD());
            PrintWriter writer = new PrintWriter(fileWriter);
            String output = this.view.getOutputText();
            output = StringUtil.substituteString(output, "\r", "");
            StringTokenizer tokenizer = new StringTokenizer(output, "\n", true);
            String prevToken = "";
            while (tokenizer.hasMoreElements()) {
                String token = (String)tokenizer.nextElement();
                if (token.equals("\n")) {
                    if (prevToken.equals("\n")) {
                        writer.println();
                    }
                } else {
                    writer.println(token);
                }
                prevToken = token;
            }
            writer.close();
        }
        catch (IOException e) {
            QuantumLog.getInstance().error("Problem exporting script.", e);
            e.printStackTrace();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

