/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.view.beanshell;

import bsh.EvalError;
import bsh.Interpreter;
import com.quantum.ImageStore;
import com.quantum.Messages;
import com.quantum.view.beanshell.BeanShellView;
import com.quantum.view.beanshell.ExportOutputAction;
import com.quantum.view.beanshell.ExportScriptAction;
import com.quantum.view.beanshell.ImportScriptAction;
import java.io.PrintStream;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionGroup;

public class BeanShellActionGroup
extends ActionGroup {
    private final BeanShellView view;
    private EvaluateAction evaluateAction;
    private ClearAction clearAction;
    private ClearAllButScriptAction clearAllButScriptAction;
    private ExportScriptAction exportScriptAction;
    private ImportScriptAction importScriptAction;
    private ExportOutputAction exportOutputAction;

    public BeanShellActionGroup(BeanShellView view) {
        this.view = view;
        this.evaluateAction = new EvaluateAction(view.getInterpreter());
        this.clearAllButScriptAction = new ClearAllButScriptAction();
        this.clearAction = new ClearAction();
        this.exportScriptAction = new ExportScriptAction();
        this.exportScriptAction.init((IViewPart)this.view);
        this.importScriptAction = new ImportScriptAction();
        this.importScriptAction.init((IViewPart)this.view);
        this.exportOutputAction = new ExportOutputAction();
        this.exportOutputAction.init((IViewPart)this.view);
    }

    public void fillActionBars(IActionBars actionBars) {
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add((IAction)this.evaluateAction);
        toolBar.add((IAction)this.clearAllButScriptAction);
        actionBars.getMenuManager().add((IAction)this.importScriptAction);
        actionBars.getMenuManager().add((IAction)this.exportScriptAction);
        actionBars.getMenuManager().add((IContributionItem)new Separator());
        actionBars.getMenuManager().add((IAction)this.exportOutputAction);
        actionBars.getMenuManager().add((IAction)this.clearAction);
    }

    private class EvaluateAction
    extends Action {
        private final Interpreter interpreter;

        public EvaluateAction(Interpreter interpreter) {
            this.interpreter = interpreter;
            this.setImageDescriptor(ImageStore.getImageDescriptor("play"));
            this.setToolTipText(Messages.getString("beanshellview.evaluate"));
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            PrintStream sOut = System.out;
            PrintStream sErr = System.err;
            try {
                try {
                    BeanShellActionGroup.this.view.getOutput().reset();
                    BeanShellActionGroup.this.view.getError().reset();
                    System.setOut(this.interpreter.getOut());
                    System.setErr(this.interpreter.getErr());
                    this.interpreter.eval(BeanShellActionGroup.this.view.getScriptText());
                }
                catch (EvalError e) {
                    e.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                System.setOut(sOut);
                System.setErr(sErr);
                throw throwable;
            }
            {
                Object var4_6 = null;
            }
            System.setOut(sOut);
            System.setErr(sErr);
            {
                BeanShellActionGroup.this.view.getOutput().flush();
                BeanShellActionGroup.this.view.getError().flush();
            }
            BeanShellActionGroup.this.view.updateText();
        }
    }

    private class ClearAction
    extends Action {
        public ClearAction() {
            this.setText(Messages.getString("sqlqueryview.clear"));
            this.setImageDescriptor(ImageStore.getImageDescriptor("clear"));
            this.setToolTipText(Messages.getString("sqlqueryview.clear"));
        }

        public void run() {
            BeanShellActionGroup.this.view.clear(1);
        }
    }

    private class ClearAllButScriptAction
    extends Action {
        public ClearAllButScriptAction() {
            this.setImageDescriptor(ImageStore.getImageDescriptor("clear"));
            this.setToolTipText(Messages.getString("sqlqueryview.clearAllButScript"));
        }

        public void run() {
            BeanShellActionGroup.this.view.clear(2);
        }
    }
}

