/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.view;

import com.quantum.QuantumPlugin;
import com.quantum.actions.BookmarkSelectionUtil;
import com.quantum.editors.ColorManager;
import com.quantum.model.Bookmark;
import com.quantum.sql.parser.SQLLexx;
import com.quantum.sql.parser.SQLProvider;
import com.quantum.sql.parser.Token;
import com.quantum.util.sql.SQLGrammar;
import com.quantum.util.versioning.VersioningHelper;
import com.quantum.view.SQLQueryActionGroup;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.ViewPart;

public class SQLQueryView
extends ViewPart
implements SQLProvider {
    private StyledText widget;
    private IPropertyChangeListener listener;
    private ColorManager colorManager = new ColorManager();
    private SQLQueryActionGroup actionGroup;
    private SyntaxHighlighter textUpdater = new SyntaxHighlighter(this.colorManager);
    ExtendedModifyListener modifyListener = new ExtendedModifyListener(){

        public void modifyText(ExtendedModifyEvent event) {
            SQLQueryView.this.textUpdater.updateText(SQLQueryView.this.getQuery(), event.start, event.length);
        }
    };

    public SQLQueryView() {
        this.listener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                SQLQueryView.this.setFont();
            }
        };
        QuantumPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.listener);
    }

    public void dispose() {
        QuantumPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.listener);
        this.colorManager.dispose();
        super.dispose();
    }

    public static SQLQueryView getInstance() {
        return (SQLQueryView)QuantumPlugin.getDefault().getView("com.quantum.view.sqlqueryview");
    }

    public void createPartControl(Composite parent) {
        this.widget = new StyledText(parent, 768);
        this.setFont();
        this.widget.setEditable(true);
        this.widget.addExtendedModifyListener(this.modifyListener);
        this.widget.setLayoutData((Object)new GridData(1808));
        this.initActions();
        this.initializeColours(parent);
        GridLayout layout = new GridLayout(1, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(1808));
        VersioningHelper.registerActionToKeyBindingService(this.getSite(), new String[]{"org.eclipse.ui.globalScope", "com.quantum.view.sql"}, (IAction)this.actionGroup.getExecuteAction());
        this.initializePopUpMenu();
        this.widget.setDoubleClickEnabled(false);
        this.widget.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                int caretOffset = SQLQueryView.this.widget.getCaretOffset();
                Vector tokens = SQLLexx.parse(SQLQueryView.this.getQuery());
                int offsetIni = 0;
                int offsetEnd = 0;
                Iterator iter = tokens.iterator();
                while (iter.hasNext()) {
                    Token token = (Token)iter.next();
                    if (token.getType() != 83) continue;
                    if (token.getEnd() >= caretOffset) {
                        offsetEnd = token.getEnd();
                        break;
                    }
                    offsetIni = token.getEnd();
                }
                if (offsetEnd == 0 && offsetIni > 0) {
                    offsetEnd = SQLQueryView.this.widget.getCharCount();
                }
                SQLQueryView.this.widget.setSelection(offsetIni, offsetEnd);
            }
        });
        DropTarget target = new DropTarget((Control)this.widget, 17);
        target.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        SQLDropTargetListener sqlDropTargetListener = new SQLDropTargetListener();
        target.addDropListener((DropTargetListener)sqlDropTargetListener);
    }

    private void setFont() {
        FontData font = PreferenceConverter.getFontData((IPreferenceStore)QuantumPlugin.getDefault().getPreferenceStore(), (String)"quantum.font");
        if (font != null && this.widget != null) {
            this.widget.setFont(new Font((Device)Display.getCurrent(), font));
        }
    }

    private void initializeColours(Composite parent) {
        IPreferenceStore store = QuantumPlugin.getDefault().getPreferenceStore();
        parent.setBackground(this.colorManager.getColor(PreferenceConverter.getColor((IPreferenceStore)store, (String)"quantum.background.color")));
        this.textUpdater.initializeColours();
    }

    private void initializePopUpMenu() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                SQLQueryView.this.actionGroup.fillContextMenu(menuManager);
            }
        });
        Menu contextMenu = manager.createContextMenu((Control)this.widget);
        this.widget.setMenu(contextMenu);
    }

    private void initActions() {
        this.actionGroup = new SQLQueryActionGroup(this);
        this.actionGroup.fillActionBars(this.getViewSite().getActionBars());
    }

    public String getQuery() {
        String query = this.widget.getSelectionText().length() > 0 ? this.widget.getSelectionText() : this.widget.getText();
        return query;
    }

    public void setQuery(String text) {
        this.widget.setText(text);
    }

    public void setStyles(final StyleRange[] styles, int start, int length) {
        this.getViewSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    int i = 0;
                    while (i < styles.length) {
                        SQLQueryView.this.widget.setStyleRange(styles[i]);
                        ++i;
                    }
                }
                catch (Throwable t) {
                    System.out.println("Error with styles: " + t.getClass().toString());
                }
            }
        });
    }

    protected void updateStatusLine(String text) {
        IStatusLineManager statusLine = this.getViewSite().getActionBars().getStatusLineManager();
        statusLine.setMessage(text);
    }

    StyledText getControl() {
        return this.widget;
    }

    public void setFocus() {
    }

    private Bookmark getLastUsedBookmark() {
        return BookmarkSelectionUtil.getInstance().getLastUsedBookmark();
    }

    public void clear() {
        this.setQuery("");
    }

    public boolean isAutoCommit() {
        return this.actionGroup.isAutoCommitPreference();
    }

    public boolean isPinTab() {
        return this.actionGroup.isPinTabPreference();
    }

    private class UpdateRequest {
        public String text;
        public int start;
        public int length;

        public UpdateRequest(String text, int start, int length) {
            this.text = text;
            this.start = start;
            this.length = length;
        }
    }

    private class SyntaxHighlighter
    extends Thread {
        private Color STRING_LITERAL;
        private Color KEYWORD;
        private Color COMMENT;
        private Color NUMERIC;
        private Color COLUMN;
        private Color TABLE;
        private Color VIEW;
        private Color PROCEDURE;
        private Color DEFAULT;
        private Color VARIABLE;
        private boolean boldText = false;
        private boolean boldKeyword = false;
        private boolean boldString = false;
        private boolean boldComment = false;
        private boolean boldNumeric = false;
        private boolean boldTable = false;
        private boolean boldView = false;
        private boolean boldColumn = false;
        private boolean boldProcedure = false;
        private boolean boldVariable = false;
        private boolean running = true;
        private LinkedList requests = new LinkedList();
        private final ColorManager colorManager;

        public SyntaxHighlighter(ColorManager colorManager) {
            this.colorManager = colorManager;
            this.setPriority(5);
            this.start();
        }

        public void initializeColours() {
            IPreferenceStore store = QuantumPlugin.getDefault().getPreferenceStore();
            this.DEFAULT = this.colorManager.getColor(PreferenceConverter.getColor((IPreferenceStore)store, (String)"quantum.text.color"));
            this.KEYWORD = this.colorManager.getColor(PreferenceConverter.getColor((IPreferenceStore)store, (String)"quantum.keyword.color"));
            this.STRING_LITERAL = this.colorManager.getColor(PreferenceConverter.getColor((IPreferenceStore)store, (String)"quantum.string.color"));
            this.COMMENT = this.colorManager.getColor(PreferenceConverter.getColor((IPreferenceStore)store, (String)"quantum.comment.color"));
            this.NUMERIC = this.colorManager.getColor(PreferenceConverter.getColor((IPreferenceStore)store, (String)"quantum.numeric.color"));
            this.TABLE = this.colorManager.getColor(PreferenceConverter.getColor((IPreferenceStore)store, (String)"quantum.table.color"));
            this.COLUMN = this.colorManager.getColor(PreferenceConverter.getColor((IPreferenceStore)store, (String)"quantum.column.color"));
            this.VIEW = this.colorManager.getColor(PreferenceConverter.getColor((IPreferenceStore)store, (String)"quantum.view.color"));
            this.PROCEDURE = this.colorManager.getColor(PreferenceConverter.getColor((IPreferenceStore)store, (String)"quantum.procedure.color"));
            this.VARIABLE = this.colorManager.getColor(PreferenceConverter.getColor((IPreferenceStore)store, (String)"quantum.variable.color"));
            this.boldKeyword = store.getBoolean("quantum.keyword.bold");
            this.boldColumn = store.getBoolean("quantum.column.bold");
            this.boldComment = store.getBoolean("quantum.comment.bold");
            this.boldNumeric = store.getBoolean("quantum.numeric.bold");
            this.boldProcedure = store.getBoolean("quantum.procedure.bold");
            this.boldString = store.getBoolean("quantum.string.bold");
            this.boldTable = store.getBoolean("quantum.table.bold");
            this.boldText = store.getBoolean("quantum.text.bold");
            this.boldVariable = store.getBoolean("quantum.variable.bold");
        }

        public synchronized void updateText(String text, int start, int length) {
            this.requests.add(new UpdateRequest(text, start, length));
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.running) {
                try {
                    SyntaxHighlighter syntaxHighlighter = this;
                    synchronized (syntaxHighlighter) {
                        if (this.requests.size() <= 0) {
                            this.wait();
                        } else {
                            Thread.sleep(10L);
                        }
                    }
                    UpdateRequest request = (UpdateRequest)this.requests.removeFirst();
                    String text = request.text.toUpperCase();
                    Vector tokens = SQLLexx.parse(text);
                    ArrayList<StyleRange> styles = new ArrayList<StyleRange>();
                    int min = Integer.MAX_VALUE;
                    int max = 0;
                    int i = 0;
                    while (i < tokens.size()) {
                        Token t = (Token)tokens.get(i);
                        String value = t.getValue();
                        int start = t.getStart();
                        int length = t.getEnd() - t.getStart();
                        StyleRange styleRange = new StyleRange();
                        styleRange.start = start;
                        styleRange.length = value.length();
                        styleRange.fontStyle = 0;
                        styleRange.foreground = this.DEFAULT;
                        min = Math.min(start, min);
                        max = Math.max(max, start + length);
                        if (t.getType() == 73) {
                            Bookmark bookmark = SQLQueryView.this.getLastUsedBookmark();
                            boolean keyword = false;
                            keyword = bookmark != null && bookmark.isConnected() ? bookmark.isKeyword(value) : SQLGrammar.getInstance().isKeyword(value);
                            if (keyword) {
                                styleRange.fontStyle = 1;
                                styleRange.foreground = this.KEYWORD;
                            } else {
                                styleRange.foreground = this.DEFAULT;
                            }
                            styles.add(styleRange);
                        } else if (t.getType() == 67) {
                            styleRange.foreground = this.COMMENT;
                            styles.add(styleRange);
                        } else if (t.getType() == 76) {
                            styleRange.foreground = this.STRING_LITERAL;
                            styles.add(styleRange);
                        } else if (t.getType() == 78) {
                            styleRange.foreground = this.NUMERIC;
                            styles.add(styleRange);
                        } else {
                            styles.add(styleRange);
                        }
                        ++i;
                    }
                    StyleRange[] ranges = styles.toArray(new StyleRange[styles.size()]);
                    if (max < 0 || ranges.length <= 0) continue;
                    SQLQueryView.this.setStyles(ranges, min, max - min);
                }
                catch (NoSuchElementException noSuchElementException) {
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    class SQLDropTargetListener
    extends DropTargetAdapter {
        SQLDropTargetListener() {
        }

        public void dragEnter(DropTargetEvent event) {
            if (event.detail == 16) {
                event.detail = 1;
            }
        }

        public void dragOperationChanged(DropTargetEvent event) {
            if (event.detail == 16) {
                event.detail = 1;
            }
        }

        public void drop(DropTargetEvent event) {
            if (TextTransfer.getInstance().isSupportedType(event.currentDataType)) {
                SQLQueryView.this.widget.insert((String)event.data);
            }
        }
    }
}

