/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.view;

import com.quantum.ImageStore;
import com.quantum.Messages;
import com.quantum.log.LogEntry;
import com.quantum.log.QuantumLog;
import com.quantum.log.Severity;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class SQLLogView
extends ViewPart
implements PropertyChangeListener {
    private Color debugColor;
    private Color warningColor;
    private Color defaultColor;
    private Color errorColor;
    private Color infoColor;
    private StyledText widget;
    private static final String newLine = "\n";
    private int numberSinceLastPurge = 0;
    private Action copyAction = new Action(){

        public void run() {
            SQLLogView.this.widget.copy();
        }
    };
    private Action selectAllAction = new Action(){

        public void run() {
            SQLLogView.this.widget.selectAll();
        }
    };
    private Action clearAction = new Action(){

        public void run() {
            QuantumLog.getInstance().clear();
        }
    };

    public void createPartControl(Composite parent) {
        this.initializeColors();
        this.widget = new StyledText(parent, 768);
        IActionBars bars = this.getViewSite().getActionBars();
        bars.setGlobalActionHandler("copy", (IAction)this.copyAction);
        bars.setGlobalActionHandler("selectAll", (IAction)this.selectAllAction);
        IToolBarManager toolBar = this.getViewSite().getActionBars().getToolBarManager();
        this.clearAction.setImageDescriptor(ImageStore.getImageDescriptor("clear"));
        this.clearAction.setToolTipText(Messages.getString("SQLLogView.ClearLog"));
        toolBar.add((IAction)this.clearAction);
        this.widget.setEditable(false);
        this.setText(QuantumLog.getInstance().getEntries());
        QuantumLog.getInstance().addPropertyChangeListener(this);
    }

    private void initializeColors() {
        this.debugColor = this.infoColor = Display.getCurrent().getSystemColor(9);
        this.defaultColor = this.infoColor;
        this.errorColor = Display.getCurrent().getSystemColor(4);
        this.warningColor = Display.getCurrent().getSystemColor(8);
    }

    private void addEntry(LogEntry entry) {
        String text = String.valueOf(entry.toString()) + newLine;
        int start = this.widget.getText().length();
        StyleRange styleRange = new StyleRange();
        styleRange.start = start;
        styleRange.length = text.length();
        styleRange.foreground = this.getColor(entry);
        this.widget.append(text);
        this.widget.setStyleRange(styleRange);
        this.scrollToBottom();
    }

    private Color getColor(LogEntry entry) {
        if (entry.getSeverity() == Severity.DEBUG) {
            return this.debugColor;
        }
        if (entry.getSeverity() == Severity.INFO) {
            return this.infoColor;
        }
        if (entry.getSeverity() == Severity.WARN) {
            return this.warningColor;
        }
        if (entry.getSeverity() == Severity.ERROR) {
            return this.errorColor;
        }
        return this.defaultColor;
    }

    public void dispose() {
        QuantumLog.getInstance().removePropertyChangeListener(this);
        super.dispose();
    }

    protected void scrollToBottom() {
        StyledTextContent document = this.widget.getContent();
        int length = document.getCharCount();
        if (length > 0) {
            this.widget.setCaretOffset(length);
            this.widget.showSelection();
        }
    }

    public void setFocus() {
        this.widget.setFocus();
    }

    public void propertyChange(final PropertyChangeEvent event) {
        if ("entries".equals(event.getPropertyName())) {
            this.getViewSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (event.getNewValue() == null) {
                        SQLLogView.this.setText(QuantumLog.getInstance().getEntries());
                    } else if (SQLLogView.this.shouldRefresh()) {
                        SQLLogView.this.setText(QuantumLog.getInstance().getEntries());
                    } else {
                        SQLLogView.this.addEntry((LogEntry)event.getNewValue());
                    }
                }
            });
        }
    }

    private boolean shouldRefresh() {
        this.numberSinceLastPurge = (this.numberSinceLastPurge + 1) % (QuantumLog.getInstance().getNumberOfEntries() / 2);
        return this.numberSinceLastPurge == 0;
    }

    private void setText(LogEntry[] entries) {
        this.widget.setText("");
        int i = 0;
        int length = entries == null ? 0 : entries.length;
        while (i < length) {
            this.addEntry(entries[i]);
            ++i;
        }
    }
}

