/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.util.xml;

import com.quantum.util.StringMatrix;
import java.util.Vector;
import org.apache.xpath.NodeSet;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLUtil {
    public static void stringMatrixToXML(StringMatrix matrix, Document doc, Element root, String sub) {
        int i = 0;
        while (i < matrix.size()) {
            Element localRoot = (Element)root.appendChild(doc.createElement(sub));
            int j = 0;
            while (j < matrix.getNumColumns()) {
                String key = matrix.getHeaderColumn(j);
                Element tableName = (Element)localRoot.appendChild(doc.createElement(key));
                String value = matrix.get(key, i);
                if (value != null) {
                    tableName.appendChild(doc.createTextNode(value));
                }
                ++j;
            }
            ++i;
        }
    }

    public static void xmlToStringMatrix(StringMatrix matrix, Element root, String sub) {
        NodeList columns = root.getElementsByTagName(sub);
        int i = 0;
        while (i < columns.getLength()) {
            Node column = columns.item(i);
            NodeList columnList = column.getChildNodes();
            int j = 0;
            while (j < columnList.getLength()) {
                Node node = columnList.item(j);
                String header = node.getNodeName();
                if (!header.equals("#text")) {
                    Node valueNode;
                    String value = null;
                    if (node != null && node.hasChildNodes() && (valueNode = node.getFirstChild()) instanceof Text) {
                        value = valueNode.getNodeValue();
                    }
                    if (!matrix.contains(header)) {
                        matrix.addHeader(header);
                    }
                    matrix.addAt(header, value, i);
                }
                ++j;
            }
            ++i;
        }
    }

    public static Element createElementText(Element root, String key, String value) {
        Document doc = root.getOwnerDocument();
        Element newElement = doc.createElement(key);
        root.appendChild(newElement);
        if (value != null && value.length() > 0) {
            Text valueText = doc.createTextNode(value);
            newElement.appendChild(valueText);
        }
        return newElement;
    }

    public static Element createCDATA(Element root, String key, String value) {
        Document doc = root.getOwnerDocument();
        Element newElement = doc.createElement(key);
        root.appendChild(newElement);
        if (value != null && value.length() > 0) {
            CDATASection valueText = doc.createCDATASection(value);
            newElement.appendChild(valueText);
        }
        return newElement;
    }

    public static String getElementText(Element root, String key) {
        return XMLUtil.getElementText(root, key, "");
    }

    public static String getElementText(Element root, String key, String defValue) {
        String value = defValue;
        if (root.getNodeName().equals(key)) {
            value = XMLUtil.extractText(root, defValue);
        } else {
            NodeList children = root.getElementsByTagName(key);
            if (children.getLength() > 0) {
                Element column = (Element)children.item(0);
                value = XMLUtil.extractText(column, defValue);
            }
        }
        return value;
    }

    public static String getElementAtribute(Element root, String key, String attribute) {
        String value = "";
        if (root.getNodeName().equals(key)) {
            value = root.getAttribute(attribute);
        } else {
            NodeList children = root.getElementsByTagName(key);
            if (children.getLength() > 0) {
                Element column = (Element)children.item(0);
                value = column.getAttribute(attribute);
            }
        }
        return value;
    }

    public static String extractText(Element node, String defValue) {
        Node valueNode;
        String value = defValue;
        if (node != null && node.hasChildNodes() && (valueNode = node.getFirstChild()) instanceof Text) {
            value = valueNode.getNodeValue();
        }
        return value;
    }

    public static Vector getVectorText(Element root, String key) {
        Vector<String> result = new Vector<String>();
        NodeList children = root.getElementsByTagName(key);
        int i = 0;
        while (i < children.getLength()) {
            Element column = (Element)children.item(i);
            result.add(XMLUtil.extractText(column, ""));
            ++i;
        }
        return result;
    }

    public static NodeList selectNodesOnAttributeValue(NodeList nodes, String attribute, String value) {
        NodeSet set = new NodeSet();
        set.setShouldCacheNodes(true);
        int i = 0;
        while (i < nodes.getLength()) {
            Element element;
            Node node = nodes.item(i);
            if (node.getNodeType() == 1 && (element = (Element)node).getAttribute(attribute).equals(value)) {
                set.addElement((Node)element);
            }
            ++i;
        }
        return set;
    }
}

