/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.util.sql;

import com.quantum.adapters.DatabaseAdapter;
import com.quantum.model.Bookmark;
import com.quantum.model.Column;
import com.quantum.model.Entity;
import com.quantum.model.Schema;
import com.quantum.model.TableMetadata;
import com.quantum.util.QuantumUtil;
import com.quantum.util.StringMatrix;
import com.quantum.util.connection.NotConnectedException;
import java.sql.SQLException;

public class SQLInstructionBuilder {
    public static String buildInsert(Entity entity, StringMatrix columns) {
        return SQLInstructionBuilder.buildGenericInsert(entity, columns, false);
    }

    public static String buildPreparedInsert(Entity entity, StringMatrix columns) {
        return SQLInstructionBuilder.buildGenericInsert(entity, columns, true);
    }

    public static String buildGenericInsert(Entity entity, StringMatrix columns, boolean prepared) {
        if (entity == null || columns == null) {
            return "";
        }
        Bookmark bookmark = entity.getBookmark();
        StringBuffer valuesClause = new StringBuffer();
        StringBuffer namesClause = new StringBuffer();
        String insertSentences = "";
        int iRow = 0;
        while (iRow < columns.size()) {
            int iCol = 0;
            while (iCol < columns.getNumColumns()) {
                if (iCol > 0) {
                    namesClause.append(", ");
                    valuesClause.append(", ");
                }
                String column = columns.getHeaderColumn(iCol);
                namesClause.append(bookmark != null ? bookmark.filterQuoteName(column) : column);
                if (!prepared) {
                    valuesClause.append(SQLInstructionBuilder.quoteValue(entity, columns.getHeaderColumn(iCol), columns.get(iCol, iRow)));
                } else {
                    valuesClause.append("?");
                }
                ++iCol;
            }
            if (iRow > 0) {
                insertSentences = String.valueOf(insertSentences) + ";\n";
            }
            insertSentences = String.valueOf(insertSentences) + "INSERT INTO " + entity.getQuotedTableName();
            insertSentences = String.valueOf(insertSentences) + " (" + namesClause + " )";
            insertSentences = String.valueOf(insertSentences) + " VALUES  ( " + valuesClause + " )";
            if (prepared) break;
            ++iRow;
        }
        return insertSentences;
    }

    public static String buildUpdate(Entity entity, StringMatrix columns, StringMatrix key) {
        if (entity == null || columns == null) {
            return "";
        }
        Bookmark bookmark = entity.getBookmark();
        StringBuffer setClause = new StringBuffer();
        String whereClause = "";
        String updateSentences = "";
        int iRow = 0;
        while (iRow < columns.size()) {
            int iCol = 0;
            while (iCol < columns.getNumColumns()) {
                if (iCol > 0) {
                    setClause.append(", ");
                }
                String column = columns.getHeaderColumn(iCol);
                setClause.append(bookmark != null ? bookmark.filterQuoteName(column) : column);
                setClause.append(" = ");
                setClause.append(SQLInstructionBuilder.quoteValue(entity, columns.getHeaderColumn(iCol), columns.get(iCol, iRow)));
                ++iCol;
            }
            if (key != null && iRow < key.size()) {
                whereClause = SQLInstructionBuilder.getWhereClause(entity, key, iRow);
            }
            if (iRow > 0) {
                updateSentences = String.valueOf(updateSentences) + ";\n";
            }
            updateSentences = String.valueOf(updateSentences) + "UPDATE " + entity.getQuotedTableName();
            updateSentences = String.valueOf(updateSentences) + " SET " + setClause.toString();
            if (whereClause.length() > 0) {
                updateSentences = String.valueOf(updateSentences) + " WHERE " + whereClause;
            }
            ++iRow;
        }
        return updateSentences;
    }

    public static String buildDelete(Entity entity, StringMatrix key) {
        if (entity == null) {
            return "";
        }
        String deleteSentences = "";
        String whereClause = "";
        if (key == null) {
            return "DELETE FROM " + entity.getQuotedTableName();
        }
        int iRow = 0;
        while (iRow < key.size()) {
            if (key != null && iRow < key.size()) {
                whereClause = SQLInstructionBuilder.getWhereClause(entity, key, iRow);
            }
            if (iRow > 0) {
                deleteSentences = String.valueOf(deleteSentences) + ";\n";
            }
            deleteSentences = String.valueOf(deleteSentences) + "DELETE FROM " + entity.getQuotedTableName();
            if (whereClause.length() > 0) {
                deleteSentences = String.valueOf(deleteSentences) + " WHERE " + whereClause;
            }
            ++iRow;
        }
        return deleteSentences;
    }

    public static String buildSelectAllColumnsNoRows(Entity entity) {
        return "SELECT * FROM " + entity.getQuotedTableName() + " WHERE (1 = 0)";
    }

    public static String buildSelectAllColumnsNoRows(Bookmark bookmark, String schemaName, String tableName) {
        return "SELECT * FROM " + bookmark.filterQuoteName(QuantumUtil.getQualifiedName(schemaName, tableName)) + " WHERE (1 = 0)";
    }

    public static String buildSelectAllColumnsAllRows(Entity entity) {
        return "SELECT * FROM " + entity.getQuotedTableName();
    }

    public static String buildSelect(Entity entity, Column[] columns, StringMatrix key) {
        if (entity == null || columns == null) {
            return "";
        }
        StringBuffer columnsList = new StringBuffer();
        String whereClause = "";
        String selectQuery = "";
        int iCol = 0;
        while (iCol < columns.length) {
            if (iCol > 0) {
                columnsList.append(", ");
            }
            columnsList.append(columns[iCol].getName());
            ++iCol;
        }
        if (key != null) {
            whereClause = SQLInstructionBuilder.getWhereClause(entity, key, 0);
        }
        selectQuery = String.valueOf(selectQuery) + "SELECT " + columnsList;
        selectQuery = String.valueOf(selectQuery) + " FROM " + entity.getQuotedTableName();
        if (whereClause.length() > 0) {
            selectQuery = String.valueOf(selectQuery) + " WHERE " + whereClause;
        }
        return selectQuery;
    }

    public static String getWhereClause(Entity entity, StringMatrix key, int iRow) {
        StringBuffer whereClause = new StringBuffer();
        Bookmark bookmark = entity.getBookmark();
        int iKey = 0;
        while (iKey < key.getNumColumns()) {
            if (iKey > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append("(");
            String column = key.getHeaderColumn(iKey);
            whereClause.append(bookmark != null ? bookmark.filterQuoteName(column) : column);
            whereClause.append(" = ");
            whereClause.append(SQLInstructionBuilder.quoteValue(entity, key.getHeaderColumn(iKey), key.get(iKey, iRow)));
            whereClause.append(")");
            ++iKey;
        }
        return whereClause.toString();
    }

    public static String getWhereClause(Entity entity, StringMatrix key) {
        return SQLInstructionBuilder.getWhereClause(entity, key, 0);
    }

    public static String quoteValue(Entity entity, String columnName, String value) {
        Bookmark bookmark = entity.getBookmark();
        DatabaseAdapter adapter = bookmark.getAdapter();
        if (adapter != null && entity != null && SQLInstructionBuilder.getColumn(entity, columnName) != null) {
            Column column = SQLInstructionBuilder.getColumn(entity, columnName);
            return adapter.quote(value, column.getType(), column.getTypeName());
        }
        return value;
    }

    public static Column getColumn(Entity entity, String columnName) {
        try {
            return entity == null ? null : entity.getColumn(columnName);
        }
        catch (NotConnectedException notConnectedException) {
            return null;
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public static String buildCreateTable(Bookmark bookmark, TableMetadata metadata, Schema schema, boolean useJavaTypes) throws NotConnectedException, SQLException {
        String eol = System.getProperty("line.separator");
        String createTable = "CREATE TABLE " + bookmark.filterQuoteName(metadata.getQualifiedName()) + " (" + eol;
        Column[] columns = metadata.getColumns();
        int i = 0;
        while (i < columns.length) {
            Column column = columns[i];
            if (i > 0) {
                createTable = String.valueOf(createTable) + "," + eol;
            }
            createTable = String.valueOf(createTable) + "        " + column.getName();
            createTable = String.valueOf(createTable) + " " + column.getTypeName();
            if (column.getSize() > 0L && !column.getTypeName().endsWith(")")) {
                createTable = String.valueOf(createTable) + "(" + String.valueOf(column.getSize());
                if (column.getNumberOfFractionalDigits() > 0) {
                    createTable = String.valueOf(createTable) + "," + String.valueOf(column.getNumberOfFractionalDigits());
                }
                createTable = String.valueOf(createTable) + ")";
            }
            if (column.getDefaultValue() != null) {
                createTable = String.valueOf(createTable) + " DEFAULT " + column.getDefaultValue();
            }
            ++i;
        }
        createTable = String.valueOf(createTable) + eol + ")";
        return createTable;
    }
}

