/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.util;

import com.quantum.util.StringUtil;
import java.util.StringTokenizer;

public class QuantumUtil {
    public static String getSchemaName(String qualifiedName) {
        StringTokenizer st = new StringTokenizer(qualifiedName, ".");
        if (st.countTokens() > 1) {
            return st.nextToken();
        }
        return "";
    }

    public static String getTableName(String qualifiedName) {
        StringTokenizer st = new StringTokenizer(qualifiedName, ".");
        if (st.countTokens() > 1) {
            st.nextToken();
            return st.nextToken();
        }
        return qualifiedName;
    }

    public static String getQualifiedName(String schemaName, String tableName) {
        if (schemaName == null || schemaName.equals("")) {
            return tableName;
        }
        return String.valueOf(schemaName) + "." + tableName;
    }

    public static String trasposeEscape(String untrans) {
        String trasposed = StringUtil.substituteString(untrans, "\\n", "\n");
        trasposed = StringUtil.substituteString(trasposed, "\\t", "\t");
        trasposed = StringUtil.substituteString(trasposed, "\\r", "\r");
        return trasposed;
    }

    public static String unTrasposeEscape(String trans) {
        String unTrasposed = StringUtil.substituteString(trans, "\n", "\\n");
        unTrasposed = StringUtil.substituteString(unTrasposed, "\t", "\\t");
        unTrasposed = StringUtil.substituteString(unTrasposed, "\r", "\\r");
        return unTrasposed;
    }

    public static String quote(String tableName, String quote) {
        if (QuantumUtil.getSchemaName(tableName).equals("")) {
            return String.valueOf(quote) + tableName + quote;
        }
        return String.valueOf(quote) + QuantumUtil.getSchemaName(tableName) + quote + "." + quote + QuantumUtil.getTableName(tableName) + quote;
    }

    public static String convertSqlToJava(String text) {
        if (text.length() == 0) {
            return "";
        }
        String javaString = text.replaceAll("\"", "\\\\\"");
        javaString = javaString.replaceAll("(?m)^(.*)$", "\\\"$1 \\\" \\+");
        javaString = javaString.replaceAll("\\+$", ";");
        return javaString;
    }
}

