/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.ui.dialog;

import com.quantum.util.Displayable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SimpleSelectionDialog
extends Dialog {
    private final String title;
    private TableViewer viewer;
    private final Image image;
    private final Object[] objects;
    private List selection = Collections.synchronizedList(new ArrayList());
    private final boolean multipleSelection;

    public SimpleSelectionDialog(Shell parentShell, String title, Object[] objects, Image image) {
        this(parentShell, title, objects, image, false);
    }

    public SimpleSelectionDialog(Shell parentShell, String title, Object[] objects, Image image, boolean multipleSelection) {
        super(parentShell);
        this.title = title;
        this.objects = objects;
        this.image = image;
        this.multipleSelection = multipleSelection;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
        GridLayout layout = new GridLayout();
        shell.setLayout((Layout)layout);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        layout.numColumns = 1;
        layout.verticalSpacing = 1;
        int style = 2816;
        if (this.multipleSelection) {
            style |= 2;
        }
        this.viewer = new TableViewer(composite, style);
        GridData full = new GridData(1808);
        full.widthHint = 300;
        full.heightHint = 100;
        this.viewer.getControl().setLayoutData((Object)full);
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.viewer.setContentProvider((IContentProvider)new ContentProvider());
        this.viewer.setInput((Object)this);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Button okButton = SimpleSelectionDialog.this.getButton(0);
                okButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Button okButton = this.getButton(0);
        okButton.setEnabled(false);
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        this.selection.clear();
        Iterator i = selection.iterator();
        while (i.hasNext()) {
            this.selection.add(i.next());
        }
        super.okPressed();
    }

    public IStructuredSelection getSelection() {
        return new StructuredSelection(this.selection);
    }

    class LabelProvider
    implements ITableLabelProvider {
        LabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return SimpleSelectionDialog.this.image;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Displayable) {
                return ((Displayable)element).getDisplayName();
            }
            return element.toString();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class ContentProvider
    implements IStructuredContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return SimpleSelectionDialog.this.objects;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

