/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.ui.dialog;

import com.quantum.Messages;
import com.quantum.ui.dialog.ExceptionDisplayDialog;
import com.quantum.ui.dialog.PasswordDialog;
import com.quantum.ui.dialog.SQLExceptionDialog;
import com.quantum.util.connection.Connectable;
import com.quantum.util.connection.ConnectionException;
import com.quantum.util.connection.NotConnectedException;
import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.swt.widgets.Shell;

public class ConnectionUtil {
    public Connection getConnection(Connectable connectable, Shell shell) {
        Connection connection = null;
        try {
            connection = connectable.getConnection();
        }
        catch (NotConnectedException notConnectedException) {
            connection = this.connect(connectable, shell);
        }
        return connection;
    }

    public Connection connect(Connectable connectable, Shell shell) {
        Connection connection = null;
        try {
            connection = connectable.connect(PasswordDialog.createPasswordFinder(shell));
        }
        catch (ConnectionException e) {
            if (e.getCause() != null && e.getCause() instanceof SQLException) {
                SQLExceptionDialog.openException(shell, connectable, (SQLException)e.getCause());
            } else {
                ExceptionDisplayDialog.openError(shell, Messages.getString(String.valueOf(this.getClass().getName()) + ".title"), String.valueOf(Messages.getString(String.valueOf(this.getClass().getName()) + ".message")) + " (Bookmark:" + connectable.getDisplayName() + ")", e);
            }
        }
        catch (SQLException e) {
            SQLExceptionDialog.openException(shell, connectable, e);
        }
        return connection;
    }
}

