/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.sql.parser;

import com.quantum.sql.parser.StringPointer;
import com.quantum.sql.parser.Token;
import java.util.Vector;

public class SQLLexx {
    private static final char CHAR_EOL = '\n';
    private static final char CHAR_DASH = '-';
    private static final char CHAR_ESCAPE = '\\';
    private static final char CHAR_SEPARATOR = ';';
    private static final int CONDITION_WHITESPACE = 1;
    private static final int CONDITION_IDENTIFIER = 2;
    private static final int CONDITION_IDENTIFIER_INITIAL = 3;
    private static final int CONDITION_LITERAL_SIMPLE_QUOTE = 4;
    private static final int CONDITION_LITERAL_DOUBLE_QUOTE = 5;
    private static final int CONDITION_NUMERIC = 6;
    private static final int CONDITION_EOL = 7;

    public static Vector parse(String text) {
        Vector<Token> tokens = new Vector<Token>();
        StringPointer p = new StringPointer(text);
        try {
            while (!p.isDone()) {
                int offset = p.getOffset();
                char c = p.getNext();
                if (c == '\n') {
                    tokens.addElement(new Token('E', '\n', offset));
                    continue;
                }
                if (SQLLexx.CheckCondition(c, 1)) {
                    StringBuffer value = SQLLexx.AddTokenWhile(p, c, 1);
                    tokens.addElement(new Token('W', value.toString(), offset, offset + value.length()));
                    continue;
                }
                if (SQLLexx.CheckCondition(c, 3)) {
                    StringBuffer value = SQLLexx.AddTokenWhile(p, c, 2);
                    tokens.addElement(new Token('I', value.toString(), offset, offset + value.length()));
                    continue;
                }
                if (SQLLexx.CheckCondition(c, 4)) {
                    StringBuffer value = SQLLexx.AddTokenUntil(p, c, 4);
                    tokens.addElement(new Token('L', value.toString(), offset, offset + value.length()));
                    continue;
                }
                if (SQLLexx.CheckCondition(c, 5)) {
                    StringBuffer value = SQLLexx.AddTokenUntil(p, c, 5);
                    tokens.addElement(new Token('L', value.toString(), offset, offset + value.length()));
                    continue;
                }
                if (Character.isDigit(c)) {
                    StringBuffer value = SQLLexx.AddTokenWhile(p, c, 6);
                    tokens.addElement(new Token('N', value.toString(), offset, offset + value.length()));
                    continue;
                }
                if (c == '-') {
                    if (p.isDone()) {
                        tokens.addElement(new Token('Y', new Character('-').toString(), offset, offset + 1));
                        continue;
                    }
                    char next = p.peek();
                    if (next == '-') {
                        StringBuffer value = SQLLexx.AddTokenUntil(p, '-', 7);
                        tokens.addElement(new Token('C', value.toString(), offset, offset + value.length()));
                        continue;
                    }
                    tokens.addElement(new Token('Y', new Character('-').toString(), offset, offset + 1));
                    continue;
                }
                if (c == '\\') {
                    if (p.peek() == ';') {
                        p.getNext();
                        tokens.addElement(new Token('Y', new Character(';').toString(), offset, offset + 2));
                        continue;
                    }
                    tokens.addElement(new Token('Y', new Character('\\').toString(), offset, offset + 1));
                    continue;
                }
                if (c == ';') {
                    tokens.addElement(new Token('S', new Character(';').toString(), offset, offset + 1));
                    if (p.isDone()) continue;
                    StringBuffer value = SQLLexx.AddTokenUntil(p, "", 7);
                    ++offset;
                    if (value.toString().trim().length() == 0) {
                        tokens.addElement(new Token('W', value.toString(), offset, offset + value.length()));
                        continue;
                    }
                    tokens.addElement(new Token('C', value.toString(), offset, offset + value.length()));
                    continue;
                }
                if (c == '/') {
                    if (p.peek() == '*') {
                        tokens.addElement(SQLLexx.tokenizeComment(p, offset));
                        continue;
                    }
                    tokens.addElement(new Token('Y', new String(new char[]{c}), offset, offset + 1));
                    continue;
                }
                tokens.addElement(new Token('Y', new String(new char[]{c}), offset, offset + 1));
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        return tokens;
    }

    private static StringBuffer AddTokenUntil(StringPointer p, String s, int condition) {
        char c;
        StringBuffer value = new StringBuffer(s);
        if (p.isDone()) {
            return value;
        }
        do {
            if ((c = p.getNext()) == '\n') continue;
            value.append(c);
        } while (!SQLLexx.CheckCondition(c, condition) && c != '\n' && !p.isDone());
        return value;
    }

    private static StringBuffer AddTokenUntil(StringPointer p, char c, int condition) {
        return SQLLexx.AddTokenUntil(p, new Character(c).toString(), condition);
    }

    private static StringBuffer AddTokenWhile(StringPointer p, String s, int condition) {
        StringBuffer value;
        block2: {
            char c;
            value = new StringBuffer(s);
            if (p.isDone()) {
                return value;
            }
            while (SQLLexx.CheckCondition(c = p.getNext(), condition)) {
                value.append(c);
                if (!p.isDone()) continue;
                break block2;
            }
            p.back();
        }
        return value;
    }

    private static StringBuffer AddTokenWhile(StringPointer p, char c, int condition) {
        return SQLLexx.AddTokenWhile(p, new Character(c).toString(), condition);
    }

    private static boolean CheckCondition(char c, int condition) {
        switch (condition) {
            case 1: {
                return Character.isWhitespace(c);
            }
            case 3: {
                return Character.isLetter(c) || c == '$' || c == '#';
            }
            case 2: {
                return Character.isLetter(c) || Character.isDigit(c) || c == '_' || c == '$' || c == '#';
            }
            case 4: {
                return c == '\'';
            }
            case 5: {
                return c == '\"';
            }
            case 6: {
                return Character.isDigit(c) || c == '.';
            }
            case 7: {
                return c == '\n';
            }
        }
        return false;
    }

    private static Token tokenizeComment(StringPointer p, int offset) {
        StringBuffer value = new StringBuffer();
        char c = p.getNext();
        value.append('/');
        while (!(c == '*' && p.peek() == '/' || p.isDone())) {
            value.append(c);
            c = p.getNext();
        }
        if (!p.isDone()) {
            value.append(c);
            c = p.getNext();
            value.append(c);
        }
        return new Token('C', value.toString(), offset, offset + value.length());
    }
}

