/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.sql;

import com.quantum.QuantumPlugin;
import com.quantum.log.QuantumLog;
import com.quantum.model.Entity;
import com.quantum.sql.SQLMetaDataResults;
import com.quantum.sql.SQLResultSetResults;
import com.quantum.sql.SQLResults;
import com.quantum.sql.SQLStandardResultSetResults;
import com.quantum.sql.SQLUpdateResults;
import com.quantum.util.QuantumUtil;
import com.quantum.util.connection.Connectable;
import com.quantum.util.sql.SQLInstructionBuilder;
import com.quantum.view.tableview.TableView;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class MultiSQLServer {
    private IPropertyChangeListener listener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (TableView.NUMBER_OF_ROWS_PREFERENCE_NAME.equals(event.getProperty())) {
                MultiSQLServer.this.setNumberOfRowsFromPreferences();
            }
        }
    };
    private static MultiSQLServer instance = null;
    private int numberOfRows = 200;

    private MultiSQLServer() {
        this.setNumberOfRowsFromPreferences();
        QuantumPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.listener);
    }

    public static synchronized MultiSQLServer getInstance() {
        if (instance == null) {
            instance = new MultiSQLServer();
        }
        return instance;
    }

    public void commit(Connection con) throws SQLException {
        try {
            con.commit();
        }
        catch (SQLException e) {
            QuantumLog.getInstance().error("Error commiting.", e);
            throw e;
        }
    }

    public void rollback(Connection con) throws SQLException {
        try {
            con.rollback();
        }
        catch (SQLException e) {
            QuantumLog.getInstance().error("Error rolling back.", e);
            throw e;
        }
    }

    public void setAutoCommit(Connection con, boolean enabled) {
        QuantumLog log = QuantumLog.getInstance();
        try {
            if (con != null) {
                con.setAutoCommit(enabled);
            } else {
                log.warn("Please connect before setting autocommit");
            }
        }
        catch (SQLException e) {
            log.error("Error setting autocommit", e);
        }
    }

    public SQLResults execute(Connectable connectable, Connection con, Entity entity, String s) throws SQLException {
        return this.execute(connectable, con, entity, s, this.numberOfRows);
    }

    public SQLResults execute(Connectable connectable, Connection con, String s) throws SQLException {
        return this.execute(connectable, con, null, s, this.numberOfRows);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SQLResultSetResults getMetaData(Entity entity, Connection connection) throws SQLException {
        String query = SQLInstructionBuilder.buildSelectAllColumnsNoRows(entity);
        SQLResultSetResults results = null;
        if (connection == null) return results;
        Statement statement = connection.createStatement();
        try {
            ResultSet set = statement.executeQuery(query);
            try {
                results = SQLMetaDataResults.create(entity.getBookmark(), set, query, entity);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                set.close();
                throw throwable;
            }
            {
                Object var7_9 = null;
                set.close();
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            statement.close();
            throw throwable;
        }
        {
            Object var9_12 = null;
        }
        statement.close();
        return results;
    }

    public SQLResults execute(Connectable connectable, Connection con, String sql, int numberOfRowsPerPage) throws SQLException {
        return this.execute(connectable, con, null, sql, numberOfRowsPerPage);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SQLResults execute(Connectable connectable, Connection con, Entity entity, String sql, int numberOfRowsPerPage) throws SQLException {
        SQLResults sQLResults;
        long startTime = System.currentTimeMillis();
        QuantumLog log = QuantumLog.getInstance();
        log.info("SQL (" + connectable.getDisplayName() + ") [" + sql + "]");
        Statement statement = con.createStatement();
        try {
            SQLResults results;
            block7: {
                if (statement.execute(sql)) {
                    ResultSet set = statement.getResultSet();
                    try {
                        results = SQLStandardResultSetResults.create(set, connectable, sql, entity, numberOfRowsPerPage);
                    }
                    catch (Throwable throwable) {
                        Object var12_13 = null;
                        set.close();
                        throw throwable;
                    }
                    {
                        Object var12_14 = null;
                        set.close();
                        break block7;
                    }
                }
                int updates = statement.getUpdateCount();
                results = new SQLUpdateResults(updates);
            }
            log.info("Success: result set displayed");
            if (results != null) {
                results.setTime(System.currentTimeMillis() - startTime);
            }
            results.setQuery(sql);
            sQLResults = results;
            Object var14_16 = null;
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            statement.close();
            throw throwable;
        }
        statement.close();
        return sQLResults;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getMatchingColumnNames(Connection connection, String schemaName, String tableName, String columnPrefix, boolean qualified) throws SQLException {
        Vector<String> temp = new Vector<String>();
        DatabaseMetaData metaData = connection.getMetaData();
        if (!metaData.supportsSchemasInTableDefinitions()) {
            schemaName = null;
        }
        ResultSet resultSet = metaData.getColumns(null, schemaName, tableName, columnPrefix == null ? null : String.valueOf(columnPrefix) + "%");
        String columnName = "";
        try {
            while (resultSet.next()) {
                if (qualified && !(columnName = resultSet.getString(3).trim()).equals("")) {
                    columnName = String.valueOf(columnName) + ".";
                }
                columnName = String.valueOf(columnName) + resultSet.getString(4).trim();
                temp.add(columnName);
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            resultSet.close();
            throw throwable;
        }
        {
            Object var10_12 = null;
        }
        resultSet.close();
        return temp.toArray(new String[temp.size()]);
    }

    public String[] getMatchingTableNames(Connection connection, String schemaName, String namePrefix, String[] types, boolean qualified) throws SQLException {
        String regexp;
        Vector<String> tables = new Vector<String>();
        DatabaseMetaData metaData = connection.getMetaData();
        ResultSet set = null;
        if (types == null) {
            types = new String[]{"TABLE", "VIEW"};
        }
        String string = regexp = namePrefix != null ? String.valueOf(namePrefix) + "%" : "%";
        if (!metaData.supportsSchemasInTableDefinitions()) {
            schemaName = null;
        }
        set = metaData.getTables(null, schemaName, regexp, types);
        while (set.next()) {
            String tempSchema = set.getString(2);
            tempSchema = tempSchema == null ? "" : tempSchema.trim();
            String tableName = set.getString(3);
            tableName = tableName == null ? "" : tableName.trim();
            tables.add(QuantumUtil.getQualifiedName(tempSchema, tableName));
        }
        set.close();
        return tables.toArray(new String[tables.size()]);
    }

    private void setNumberOfRowsFromPreferences() {
        IPreferenceStore store = QuantumPlugin.getDefault().getPreferenceStore();
        this.numberOfRows = store.getInt(TableView.NUMBER_OF_ROWS_PREFERENCE_NAME);
    }
}

