/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.properties;

import com.quantum.Messages;
import com.quantum.model.DataType;
import com.quantum.properties.TabularMetaDataPropertyPage;
import com.quantum.util.connection.NotConnectedException;
import java.sql.SQLException;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class DataTypesPropertyPage
extends TabularMetaDataPropertyPage {
    protected int getNumberOfColumns() {
        return 6;
    }

    protected ITableLabelProvider getLabelProvider() {
        return new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                String result = null;
                if (element != null && element instanceof DataType) {
                    DataType dataType = (DataType)element;
                    switch (columnIndex) {
                        case 0: {
                            result = dataType.getDatabaseTypeName();
                            break;
                        }
                        case 1: {
                            result = dataType.getJavaNameType();
                            break;
                        }
                        case 2: {
                            result = String.valueOf(dataType.getPrecision());
                            break;
                        }
                        case 3: {
                            result = dataType.getLiteralPrefix();
                            break;
                        }
                        case 4: {
                            result = dataType.getLiteralSuffix();
                            break;
                        }
                        case 5: {
                            result = dataType.getCreateParameters();
                            break;
                        }
                        default: {
                            result = null;
                        }
                    }
                }
                return result == null ? "" : result;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        };
    }

    protected IStructuredContentProvider getContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof DataType[]) {
                    return (DataType[])inputElement;
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    protected Object getInput() throws NotConnectedException, SQLException {
        return this.getBookmark().getDataTypes();
    }

    protected void createHeader(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(Messages.getString(((Object)((Object)this)).getClass(), "dataTypes"));
        GridData data = new GridData(34);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
    }
}

