/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.properties;

import com.quantum.adapters.AdapterFactory;
import com.quantum.model.Bookmark;
import com.quantum.model.BookmarkHolder;
import com.quantum.model.JDBCDriver;
import com.quantum.wizards.JDBCDriverSelectionWizardPage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class BookmarkPropertyPage
extends PropertyPage {
    private Text password;
    private Text userid;
    private Button prompt;
    private Text jdbcURL;
    private Text driverName;
    private Text driverPath;
    private Text driverClassName;
    private Text driverVersion;
    private Text type;
    private Combo autoCommit;
    private Button quoteAll;
    private Button ignoreQueryViewSetting;
    private JDBCDriver driver;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText("Name:");
        Label name = new Label(composite, 0);
        Bookmark bookmark = this.getBookmark();
        String description = bookmark.getName();
        name.setText(description);
        name.setLayoutData((Object)new GridData(34));
        TabFolder tabFolder = new TabFolder(composite, 0);
        layout = new GridLayout();
        tabFolder.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        tabFolder.setLayoutData((Object)data);
        this.createConnectionTab(tabFolder);
        this.createDriverTab(tabFolder);
        this.createOptionsTab(tabFolder);
        this.performDefaults();
        return composite;
    }

    private Bookmark getBookmark() {
        Bookmark bookmark = ((BookmarkHolder)this.getElement()).getBookmark();
        return bookmark;
    }

    private void createDriverTab(TabFolder tabFolder) {
        TabItem driverTab = new TabItem(tabFolder, 0);
        driverTab.setText("JDBC Driver");
        Composite composite = new Composite((Composite)tabFolder, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite, 0);
        label.setText("Driver Name:");
        this.driverName = new Text(composite, 2048);
        this.driverName.setLayoutData((Object)this.createFillHorizontalGridData());
        this.driverName.setEditable(false);
        label = new Label(composite, 0);
        label.setText("Driver Class Name:");
        this.driverClassName = new Text(composite, 2048);
        this.driverClassName.setLayoutData((Object)this.createFillHorizontalGridData());
        this.driverClassName.setEditable(false);
        label = new Label(composite, 0);
        label.setText("Driver Version:");
        this.driverVersion = new Text(composite, 2048);
        this.driverVersion.setLayoutData((Object)this.createFillHorizontalGridData());
        this.driverVersion.setEditable(false);
        label = new Label(composite, 0);
        label.setText("Driver Path:");
        this.driverPath = new Text(composite, 2048);
        this.driverPath.setLayoutData((Object)this.createFillHorizontalGridData());
        this.driverPath.setEditable(false);
        label = new Label(composite, 0);
        label.setText("Type:");
        this.type = new Text(composite, 2048);
        this.type.setLayoutData((Object)this.createFillHorizontalGridData());
        this.type.setEditable(false);
        driverTab.setControl((Control)composite);
        Button button = new Button(composite, 8);
        button.setText("Change");
        GridData data = new GridData(128);
        data.horizontalSpan = 2;
        button.setLayoutData((Object)data);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                WizardDialog dialog = new WizardDialog(BookmarkPropertyPage.this.getShell(), (IWizard)new ChooseDriverWizard());
                dialog.open();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
    }

    private GridData createFillHorizontalGridData() {
        GridData data = new GridData(768);
        data.widthHint = 200;
        return data;
    }

    private void createConnectionTab(TabFolder tabFolder) {
        TabItem userTab = new TabItem(tabFolder, 0);
        userTab.setText("Connection");
        Composite composite = new Composite((Composite)tabFolder, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.verticalAlignment = 2;
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        Label useridLabel = new Label(composite, 0);
        useridLabel.setText("Userid:");
        this.userid = new Text(composite, 2048);
        data = new GridData(4);
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessHorizontalSpace = true;
        this.userid.setLayoutData((Object)data);
        Label passworLabel = new Label(composite, 0);
        passworLabel.setText("Password:");
        this.password = new Text(composite, 2048);
        this.password.setEchoChar('*');
        data = new GridData(4);
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.password.setLayoutData((Object)data);
        this.prompt = new Button(composite, 32);
        this.prompt.setText("Prompt for password");
        data = new GridData(4);
        data.horizontalSpan = 2;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.prompt.setLayoutData((Object)data);
        this.prompt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BookmarkPropertyPage.this.password.setEditable(!((Button)event.getSource()).getSelection());
            }
        });
        Label label = new Label(composite, 0);
        label.setText("Connection URL:");
        this.jdbcURL = new Text(composite, 2048);
        data = new GridData(4);
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessHorizontalSpace = true;
        this.jdbcURL.setLayoutData((Object)data);
        userTab.setControl((Control)composite);
    }

    private void createOptionsTab(TabFolder tabFolder) {
        TabItem optionsTab = new TabItem(tabFolder, 0);
        optionsTab.setText("Options");
        Composite composite = new Composite((Composite)tabFolder, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.verticalAlignment = 2;
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        Label autocommitLabel = new Label(composite, 0);
        autocommitLabel.setText("On connection, Auto-Commit should be:");
        this.autoCommit = new Combo(composite, 76);
        String[] autoCommitTypes = new String[]{"Always True", "Always False", "Last Saved"};
        this.autoCommit.setItems(autoCommitTypes);
        Label ignoreQueryViewSettingLabel = new Label(composite, 0);
        ignoreQueryViewSettingLabel.setText("Ignore the Autocommit setting of the Query View:");
        this.ignoreQueryViewSetting = new Button(composite, 32);
        this.ignoreQueryViewSetting.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BookmarkPropertyPage.this.getBookmark().setIgnoreQueryViewSetting(((Button)event.getSource()).getSelection());
            }
        });
        Label quoteAllLabel = new Label(composite, 0);
        quoteAllLabel.setText("Quote all schemas, tables and columns:");
        this.quoteAll = new Button(composite, 32);
        this.quoteAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BookmarkPropertyPage.this.getBookmark().setQuoteAll(((Button)event.getSource()).getSelection());
            }
        });
        data = new GridData();
        data.horizontalAlignment = 4;
        this.autoCommit.setLayoutData((Object)data);
        optionsTab.setControl((Control)composite);
    }

    public boolean performOk() {
        Bookmark bookmark = this.getBookmark();
        bookmark.setUsername(this.userid.getText());
        bookmark.setPromptForPassword(this.prompt.getSelection());
        if (this.prompt.getSelection()) {
            bookmark.setPassword("");
        } else {
            bookmark.setPassword(this.password.getText());
        }
        bookmark.setConnect(this.jdbcURL.getText());
        bookmark.setJDBCDriver(this.driver);
        if (this.autoCommit.getSelectionIndex() >= 0) {
            bookmark.setAutoCommitPreference(this.autoCommit.getItem(this.autoCommit.getSelectionIndex()));
        }
        return super.performOk();
    }

    protected void performDefaults() {
        super.performDefaults();
        Bookmark bookmark = this.getBookmark();
        this.prompt.setSelection(bookmark.getPromptForPassword());
        this.password.setEditable(!bookmark.getPromptForPassword());
        String password = bookmark.getPassword();
        this.password.setText(password == null ? "" : password);
        this.userid.setText(bookmark.getUsername());
        this.jdbcURL.setText(bookmark.getConnect());
        this.driver = bookmark.getJDBCDriver();
        this.setDriverDetails();
        if (bookmark.getAutoCommitPreference().equals("Always True")) {
            this.autoCommit.select(0);
        } else if (bookmark.getAutoCommitPreference().equals("Always False")) {
            this.autoCommit.select(1);
        } else if (bookmark.getAutoCommitPreference().equals("Last Saved")) {
            this.autoCommit.select(2);
        }
        this.quoteAll.setSelection(bookmark.isQuoteAll());
        this.ignoreQueryViewSetting.setSelection(bookmark.isIgnoreQueryViewSetting());
    }

    private void setDriverDetails() {
        this.driverName.setText(this.driver.getName());
        this.driverClassName.setText(this.driver.getClassName());
        String path = this.driver.getJarFilePath();
        this.driverPath.setText(path == null ? "" : path);
        String version = this.driver.getVersion();
        this.driverVersion.setText(version == null ? "" : version);
        this.type.setText(AdapterFactory.getInstance().getAdapter(this.driver.getType()).getDisplayName());
    }

    class ChooseDriverWizard
    extends Wizard {
        private JDBCDriver selection;
        private JDBCDriverSelectionWizardPage page;
        private PropertyChangeListener listener = new PropertyChangeListener(this){
            final /* synthetic */ ChooseDriverWizard this$1;
            {
                this.this$1 = chooseDriverWizard;
            }

            public void propertyChange(PropertyChangeEvent event) {
                if ("driver".equals(event.getPropertyName())) {
                    ChooseDriverWizard.access$0(this.this$1, (JDBCDriver)event.getNewValue());
                }
            }
        };

        ChooseDriverWizard() {
        }

        public void addPages() {
            this.page = new JDBCDriverSelectionWizardPage("page1");
            this.page.addPropertyChangeListener(this.listener);
            this.addPage((IWizardPage)this.page);
        }

        public void dispose() {
            this.page.removePropertyChangeListener(this.listener);
            super.dispose();
        }

        public boolean performFinish() {
            BookmarkPropertyPage.this.driver = this.selection;
            BookmarkPropertyPage.this.setDriverDetails();
            return true;
        }

        static /* synthetic */ void access$0(ChooseDriverWizard chooseDriverWizard, JDBCDriver jDBCDriver) {
            chooseDriverWizard.selection = jDBCDriver;
        }
    }
}

