/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.preferences;

import com.quantum.Messages;
import com.quantum.PluginPreferences;
import com.quantum.QuantumPlugin;
import com.quantum.util.versioning.VersioningHelper;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SQLEditorPreferences
extends PreferencePage
implements IWorkbenchPreferencePage {
    private FontDialog fontDialog;
    private ColorFieldEditor backgroundColorEditor;
    private ColorFieldEditor textColorEditor;
    private ColorFieldEditor keywordColorEditor;
    private ColorFieldEditor stringColorEditor;
    private ColorFieldEditor numericColorEditor;
    private ColorFieldEditor commentColorEditor;
    private ColorFieldEditor tableColorEditor;
    private ColorFieldEditor viewColorEditor;
    private ColorFieldEditor procedureColorEditor;
    private ColorFieldEditor columnColorEditor;
    private ColorFieldEditor variableColorEditor;
    private boolean textFlag;
    private boolean keywordFlag;
    private boolean stringFlag;
    private boolean numericFlag;
    private boolean commentFlag;
    private boolean tableFlag;
    private boolean viewFlag;
    private boolean procedureFlag;
    private boolean columnFlag;
    private boolean variableFlag;
    private Button boldText;
    private Button boldKeyword;
    private Button boldString;
    private Button boldNumeric;
    private Button boldComment;
    private Button boldTable;
    private Button boldView;
    private Button boldProcedure;
    private Button boldColumn;
    private Button boldVariable;
    private FontData fontData;
    private Label fontDisplay;

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(QuantumPlugin.getDefault().getPreferenceStore());
    }

    protected void performDefaults() {
        this.fontData = PluginPreferences.getDefaultFont();
        this.updateFontDisplay();
        this.textFlag = false;
        this.keywordFlag = true;
        this.stringFlag = false;
        this.numericFlag = false;
        this.commentFlag = false;
        this.tableFlag = false;
        this.viewFlag = false;
        this.procedureFlag = false;
        this.columnFlag = false;
        this.variableFlag = false;
        this.updateFlags();
        this.backgroundColorEditor.loadDefault();
        this.textColorEditor.loadDefault();
        this.keywordColorEditor.loadDefault();
        this.stringColorEditor.loadDefault();
        this.commentColorEditor.loadDefault();
        this.numericColorEditor.loadDefault();
        this.tableColorEditor.loadDefault();
        this.viewColorEditor.loadDefault();
        this.procedureColorEditor.loadDefault();
        this.columnColorEditor.loadDefault();
        this.variableColorEditor.loadDefault();
    }

    public boolean performOk() {
        PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)"quantum.font", (FontData)this.fontData);
        this.getPreferenceStore().setValue("quantum.text.bold", this.textFlag);
        this.getPreferenceStore().setValue("quantum.keyword.bold", this.keywordFlag);
        this.getPreferenceStore().setValue("quantum.string.bold", this.stringFlag);
        this.getPreferenceStore().setValue("quantum.comment.bold", this.commentFlag);
        this.getPreferenceStore().setValue("quantum.numeric.bold", this.numericFlag);
        this.getPreferenceStore().setValue("quantum.table.bold", this.tableFlag);
        this.getPreferenceStore().setValue("quantum.view.bold", this.viewFlag);
        this.getPreferenceStore().setValue("quantum.procedure.bold", this.procedureFlag);
        this.getPreferenceStore().setValue("quantum.column.bold", this.columnFlag);
        this.getPreferenceStore().setValue("quantum.variable.bold", this.variableFlag);
        this.backgroundColorEditor.store();
        this.textColorEditor.store();
        this.keywordColorEditor.store();
        this.stringColorEditor.store();
        this.commentColorEditor.store();
        this.numericColorEditor.store();
        this.tableColorEditor.store();
        this.viewColorEditor.store();
        this.procedureColorEditor.store();
        this.columnColorEditor.store();
        this.variableColorEditor.store();
        return super.performOk();
    }

    protected Control createContents(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout());
        this.createFontSelectionArea(main);
        Label label = new Label(main, 0);
        label.setText("");
        this.createColorSelectionArea(main);
        return main;
    }

    private void createColorSelectionArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        this.textFlag = this.getPreferenceStore().getBoolean("quantum.text.bold");
        this.keywordFlag = this.getPreferenceStore().getBoolean("quantum.keyword.bold");
        this.stringFlag = this.getPreferenceStore().getBoolean("quantum.string.bold");
        this.commentFlag = this.getPreferenceStore().getBoolean("quantum.comment.bold");
        this.numericFlag = this.getPreferenceStore().getBoolean("quantum.numeric.bold");
        this.tableFlag = this.getPreferenceStore().getBoolean("quantum.table.bold");
        this.procedureFlag = this.getPreferenceStore().getBoolean("quantum.procedure.bold");
        this.columnFlag = this.getPreferenceStore().getBoolean("quantum.column.bold");
        this.viewFlag = this.getPreferenceStore().getBoolean("quantum.view.bold");
        this.variableFlag = this.getPreferenceStore().getBoolean("quantum.variable.bold");
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        main.setLayout((Layout)layout);
        this.backgroundColorEditor = new ColorFieldEditor("quantum.background.color", Messages.getString(((Object)((Object)this)).getClass(), "backgroundColor"), main);
        Label emptyLabel = new Label(main, 0);
        emptyLabel.setText("");
        this.createEmptyRow(main);
        this.textColorEditor = new ColorFieldEditor("quantum.text.color", Messages.getString(((Object)((Object)this)).getClass(), "defaultTextColor"), main);
        this.boldText = new Button(main, 32);
        this.boldText.setSelection(this.textFlag);
        this.boldText.setText(Messages.getString(((Object)((Object)this)).getClass(), "bold"));
        this.boldText.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SQLEditorPreferences.this.textFlag = SQLEditorPreferences.this.boldText.getSelection();
            }
        });
        this.keywordColorEditor = new ColorFieldEditor("quantum.keyword.color", Messages.getString(((Object)((Object)this)).getClass(), "keywordTextColor"), main);
        this.boldKeyword = new Button(main, 32);
        this.boldKeyword.setSelection(this.keywordFlag);
        this.boldKeyword.setText(Messages.getString(((Object)((Object)this)).getClass(), "bold"));
        this.boldKeyword.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SQLEditorPreferences.this.keywordFlag = SQLEditorPreferences.this.boldKeyword.getSelection();
            }
        });
        this.commentColorEditor = new ColorFieldEditor("quantum.comment.color", Messages.getString(((Object)((Object)this)).getClass(), "commentTextColor"), main);
        this.boldComment = new Button(main, 32);
        this.boldComment.setSelection(this.commentFlag);
        this.boldComment.setText(Messages.getString(((Object)((Object)this)).getClass(), "bold"));
        this.boldComment.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SQLEditorPreferences.this.commentFlag = SQLEditorPreferences.this.boldComment.getSelection();
            }
        });
        this.stringColorEditor = new ColorFieldEditor("quantum.string.color", Messages.getString(((Object)((Object)this)).getClass(), "stringTextColor"), main);
        this.boldString = new Button(main, 32);
        this.boldString.setSelection(this.stringFlag);
        this.boldString.setText(Messages.getString(((Object)((Object)this)).getClass(), "bold"));
        this.boldString.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SQLEditorPreferences.this.stringFlag = SQLEditorPreferences.this.boldString.getSelection();
            }
        });
        this.numericColorEditor = new ColorFieldEditor("quantum.numeric.color", Messages.getString(((Object)((Object)this)).getClass(), "numericTextColor"), main);
        this.boldNumeric = new Button(main, 32);
        this.boldNumeric.setSelection(this.numericFlag);
        this.boldNumeric.setText(Messages.getString(((Object)((Object)this)).getClass(), "bold"));
        this.boldNumeric.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SQLEditorPreferences.this.numericFlag = SQLEditorPreferences.this.boldNumeric.getSelection();
            }
        });
        this.tableColorEditor = new ColorFieldEditor("quantum.table.color", Messages.getString(((Object)((Object)this)).getClass(), "tableTextColor"), main);
        this.boldTable = new Button(main, 32);
        this.boldTable.setSelection(this.tableFlag);
        this.boldTable.setText(Messages.getString(((Object)((Object)this)).getClass(), "bold"));
        this.boldTable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SQLEditorPreferences.this.tableFlag = SQLEditorPreferences.this.boldTable.getSelection();
            }
        });
        this.viewColorEditor = new ColorFieldEditor("quantum.view.color", Messages.getString(((Object)((Object)this)).getClass(), "viewTextColor"), main);
        this.boldView = new Button(main, 32);
        this.boldView.setSelection(this.viewFlag);
        this.boldView.setText(Messages.getString(((Object)((Object)this)).getClass(), "bold"));
        this.boldView.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SQLEditorPreferences.this.viewFlag = SQLEditorPreferences.this.boldView.getSelection();
            }
        });
        this.procedureColorEditor = new ColorFieldEditor("quantum.procedure.color", Messages.getString(((Object)((Object)this)).getClass(), "procedureTextColor"), main);
        this.boldProcedure = new Button(main, 32);
        this.boldProcedure.setSelection(this.procedureFlag);
        this.boldProcedure.setText(Messages.getString(((Object)((Object)this)).getClass(), "bold"));
        this.boldProcedure.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SQLEditorPreferences.this.procedureFlag = SQLEditorPreferences.this.boldProcedure.getSelection();
            }
        });
        this.columnColorEditor = new ColorFieldEditor("quantum.column.color", Messages.getString(((Object)((Object)this)).getClass(), "columnTextColor"), main);
        this.boldColumn = new Button(main, 32);
        this.boldColumn.setSelection(this.columnFlag);
        this.boldColumn.setText(Messages.getString(((Object)((Object)this)).getClass(), "bold"));
        this.boldColumn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SQLEditorPreferences.this.columnFlag = SQLEditorPreferences.this.boldColumn.getSelection();
            }
        });
        this.variableColorEditor = new ColorFieldEditor("quantum.variable.color", Messages.getString(((Object)((Object)this)).getClass(), "variableTextColor"), main);
        this.boldVariable = new Button(main, 32);
        this.boldVariable.setSelection(this.columnFlag);
        this.boldVariable.setText(Messages.getString(((Object)((Object)this)).getClass(), "bold"));
        this.boldVariable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SQLEditorPreferences.this.variableFlag = SQLEditorPreferences.this.boldVariable.getSelection();
            }
        });
        this.backgroundColorEditor.setPreferenceStore(this.getPreferenceStore());
        this.backgroundColorEditor.load();
        this.textColorEditor.setPreferenceStore(this.getPreferenceStore());
        this.textColorEditor.load();
        this.keywordColorEditor.setPreferenceStore(this.getPreferenceStore());
        this.keywordColorEditor.load();
        this.commentColorEditor.setPreferenceStore(this.getPreferenceStore());
        this.commentColorEditor.load();
        this.stringColorEditor.setPreferenceStore(this.getPreferenceStore());
        this.stringColorEditor.load();
        this.numericColorEditor.setPreferenceStore(this.getPreferenceStore());
        this.numericColorEditor.load();
        this.tableColorEditor.setPreferenceStore(this.getPreferenceStore());
        this.tableColorEditor.load();
        this.viewColorEditor.setPreferenceStore(this.getPreferenceStore());
        this.viewColorEditor.load();
        this.procedureColorEditor.setPreferenceStore(this.getPreferenceStore());
        this.procedureColorEditor.load();
        this.columnColorEditor.setPreferenceStore(this.getPreferenceStore());
        this.columnColorEditor.load();
        this.variableColorEditor.setPreferenceStore(this.getPreferenceStore());
        this.variableColorEditor.load();
        GridLayout innerLayout = new GridLayout();
        innerLayout.numColumns = 3;
        main.setLayout((Layout)innerLayout);
    }

    private void createFontSelectionArea(Composite main) {
        Group group = new Group(main, 0);
        group.setText(Messages.getString(((Object)((Object)this)).getClass(), "font"));
        GridLayout innerLayout = new GridLayout();
        innerLayout.numColumns = 2;
        group.setLayout((Layout)innerLayout);
        group.setLayoutData((Object)new GridData(768));
        this.fontDisplay = new Label((Composite)group, 0);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        this.fontDisplay.setLayoutData((Object)data);
        this.fontData = PreferenceConverter.getFontData((IPreferenceStore)this.getPreferenceStore(), (String)"quantum.font");
        this.fontDialog = new FontDialog(this.getShell());
        Button fontButton = new Button((Composite)group, 8);
        fontButton.setText(Messages.getString(((Object)((Object)this)).getClass(), "pickFont"));
        fontButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FontData data;
                if (SQLEditorPreferences.this.fontData != null) {
                    VersioningHelper.setFont(SQLEditorPreferences.this.fontDialog, new FontData[]{SQLEditorPreferences.this.fontData});
                }
                if ((data = SQLEditorPreferences.this.fontDialog.open()) != null) {
                    SQLEditorPreferences.this.fontData = data;
                    SQLEditorPreferences.this.updateFontDisplay();
                }
            }
        });
        Button defaultButton = new Button((Composite)group, 8);
        defaultButton.setText(Messages.getString(((Object)((Object)this)).getClass(), "defaultFont"));
        defaultButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SQLEditorPreferences.this.fontData = PluginPreferences.getDefaultFont();
                SQLEditorPreferences.this.updateFontDisplay();
            }
        });
        this.updateFontDisplay();
    }

    private void createEmptyRow(Composite main) {
        Label emptyLabel = new Label(main, 0);
        emptyLabel.setText("");
        GridData gridData = new GridData();
        gridData.horizontalSpan = 4;
        emptyLabel.setLayoutData((Object)gridData);
    }

    protected void updateFontDisplay() {
        if (this.fontData == null) {
            this.fontDisplay.setText(Messages.getString(((Object)((Object)this)).getClass(), "default"));
        } else {
            Object[] parameters = new Object[]{this.fontData.getName(), new Integer(this.fontData.getHeight())};
            String style = Messages.getString(((Object)((Object)this)).getClass(), "regularFont", parameters);
            if (this.fontData.getStyle() == 1) {
                style = Messages.getString(((Object)((Object)this)).getClass(), "boldFont", parameters);
            } else if (this.fontData.getStyle() == 2) {
                style = Messages.getString(((Object)((Object)this)).getClass(), "italicFont", parameters);
            } else if (this.fontData.getStyle() == 3) {
                style = Messages.getString(((Object)((Object)this)).getClass(), "boldItalicFont", parameters);
            }
            this.fontDisplay.setText(style);
        }
    }

    protected void updateFlags() {
        this.boldText.setSelection(this.textFlag);
        this.boldKeyword.setSelection(this.keywordFlag);
        this.boldString.setSelection(this.stringFlag);
        this.boldNumeric.setSelection(this.numericFlag);
        this.boldComment.setSelection(this.commentFlag);
        this.boldColumn.setSelection(this.columnFlag);
        this.boldProcedure.setSelection(this.procedureFlag);
        this.boldTable.setSelection(this.tableFlag);
        this.boldView.setSelection(this.viewFlag);
    }
}

