/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.model;

import com.quantum.adapters.DatabaseAdapter;
import com.quantum.model.Bookmark;
import com.quantum.model.EntityImpl;
import com.quantum.model.Sequence;
import com.quantum.util.connection.NotConnectedException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

class SequenceImpl
extends EntityImpl
implements Sequence {
    private boolean metadataLoaded = false;
    private String minValue;
    private String maxValue;
    private String initialValue;
    private String incrementBy;
    private boolean cicled;
    private boolean ordered;

    public SequenceImpl(Bookmark bookmark, String schema, String name, boolean isSynonym) {
        super(bookmark, schema, name, "SEQUENCE", isSynonym);
    }

    public String getMinValue() throws NotConnectedException, SQLException {
        if (!this.metadataLoaded) {
            this.loadMetadata();
        }
        return this.minValue;
    }

    public String getMaxValue() throws NotConnectedException, SQLException {
        if (!this.metadataLoaded) {
            this.loadMetadata();
        }
        return this.maxValue;
    }

    public String getInitialValue() throws NotConnectedException, SQLException {
        if (!this.metadataLoaded) {
            this.loadMetadata();
        }
        return this.initialValue;
    }

    public String getIncrementBy() throws NotConnectedException, SQLException {
        if (!this.metadataLoaded) {
            this.loadMetadata();
        }
        return this.incrementBy;
    }

    public boolean isCycled() throws NotConnectedException, SQLException {
        if (!this.metadataLoaded) {
            this.loadMetadata();
        }
        return this.cicled;
    }

    public boolean isOrdered() throws NotConnectedException, SQLException {
        if (!this.metadataLoaded) {
            this.loadMetadata();
        }
        return this.ordered;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadMetadata() throws NotConnectedException, SQLException {
        Connection connection = this.getBookmark().getConnection();
        DatabaseAdapter adapter = this.getBookmark().getAdapter();
        Statement stmt = connection.createStatement();
        try {
            if (adapter != null && stmt != null && adapter.getSequenceMetadataQuery(this.getSchema(), this.getName()) != null) {
                stmt.execute(adapter.getSequenceMetadataQuery(this.getSchema(), this.getName()));
                ResultSet set = stmt.getResultSet();
                try {
                    if (set.next()) {
                        this.minValue = set.getString(1);
                        this.maxValue = set.getString(2);
                        this.initialValue = set.getString(3);
                        this.incrementBy = set.getString(4);
                        String temp = set.getString(5);
                        this.cicled = temp != null ? temp.toUpperCase().equals("TRUE") : false;
                        temp = set.getString(6);
                        this.ordered = temp != null ? temp.toUpperCase().equals("TRUE") : false;
                    }
                    Object var6_8 = null;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    set.close();
                    throw throwable;
                }
                set.close();
            }
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            stmt.close();
            throw throwable;
        }
        stmt.close();
        this.metadataLoaded = true;
    }
}

