/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.model;

import com.quantum.adapters.DatabaseAdapter;
import com.quantum.model.Bookmark;
import com.quantum.model.Check;
import com.quantum.model.CheckImpl;
import com.quantum.model.Column;
import com.quantum.model.ColumnImpl;
import com.quantum.model.DatabaseObjectImpl;
import com.quantum.model.Entity;
import com.quantum.model.ForeignKey;
import com.quantum.model.Index;
import com.quantum.model.IndexImpl;
import com.quantum.model.Privilege;
import com.quantum.model.PrivilegeImpl;
import com.quantum.model.Trigger;
import com.quantum.model.TriggerImpl;
import com.quantum.sql.MultiSQLServer;
import com.quantum.sql.SQLMetaDataResults;
import com.quantum.sql.SQLResultSetResults;
import com.quantum.util.ModelUtil;
import com.quantum.util.connection.NotConnectedException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

abstract class EntityImpl
extends DatabaseObjectImpl
implements Entity {
    private Boolean exists = Boolean.TRUE;
    private boolean isSynonym = false;
    private Column[] columns = null;

    public EntityImpl(Bookmark bookmark, String schema, String name, String type, boolean isSynonym) {
        super(bookmark, schema, name, type);
        this.isSynonym = isSynonym;
    }

    public Column getColumn(String columnName) throws NotConnectedException, SQLException {
        Column column = null;
        if (this.columns == null) {
            this.columns = this.getColumns();
        }
        int i = 0;
        int length = this.columns == null ? 0 : this.columns.length;
        while (column == null && i < length) {
            if (columnName != null && columnName.equals(this.columns[i].getName())) {
                column = this.columns[i];
            }
            ++i;
        }
        return column;
    }

    public Column[] getColumns() throws NotConnectedException, SQLException {
        if (this.columns != null) {
            return this.columns;
        }
        Connection connection = this.getBookmark().getConnection();
        try {
            this.columns = this.getColumnsFromMetaData(connection);
            if (this.columns.length == 0) {
                this.columns = this.getColumnsFromQuery(connection);
            }
            return this.columns;
        }
        catch (SQLException e) {
            if ("S1C00".equals(e.getSQLState()) && "JDBC_ODBC_BRIDGE".equals(this.getBookmark().getJDBCDriver().getType())) {
                this.columns = this.getColumnsFromQuery(connection);
                return this.columns;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Column[] getColumnsFromMetaData(Connection connection) throws SQLException {
        Column[] columnArray;
        HashMap<String, ColumnImpl> temp = new HashMap<String, ColumnImpl>();
        DatabaseMetaData metaData = connection.getMetaData();
        ResultSet resultSet = metaData.getColumns(null, this.getSchema(), this.getName(), null);
        try {
            while (resultSet.next()) {
                String defaultValue = resultSet.getString(13);
                ColumnImpl column = new ColumnImpl(this, resultSet.getString(4), resultSet.getString(6), resultSet.getInt(5), resultSet.getInt(7), resultSet.getInt(9), "YES".equalsIgnoreCase(resultSet.getString(18)), resultSet.getInt(17), defaultValue, resultSet.getString(12));
                temp.put(column.getName(), column);
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            resultSet.close();
            throw throwable;
        }
        {
            Object var7_12 = null;
        }
        resultSet.close();
        resultSet = metaData.getPrimaryKeys(null, this.getSchema(), this.getName());
        try {
            while (true) {
                if (!resultSet.next()) {
                    List columnList = Collections.synchronizedList(new ArrayList(temp.values()));
                    Collections.sort(columnList);
                    columnArray = columnList.toArray(new Column[columnList.size()]);
                    Object var8_9 = null;
                    break;
                }
                String name = resultSet.getString(4);
                short keySequence = resultSet.getShort(5);
                ColumnImpl column = (ColumnImpl)temp.get(name);
                if (column == null) continue;
                column.setPrimaryKeyOrder(keySequence);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            resultSet.close();
            throw throwable;
        }
        resultSet.close();
        return columnArray;
    }

    private Column[] getColumnsFromQuery(Connection connection) throws SQLException {
        ArrayList<ColumnImpl> temp = new ArrayList<ColumnImpl>();
        SQLMetaDataResults results = (SQLMetaDataResults)MultiSQLServer.getInstance().getMetaData(this, connection);
        SQLResultSetResults.Row[] rows = results.getRows();
        int i = 0;
        int length = results.getRowCount();
        while (i < length) {
            ColumnImpl column = new ColumnImpl(this, (String)rows[i].get(1), (String)rows[i].get(2), (Integer)rows[i].get(7), (Long)rows[i].get(3), (Integer)rows[i].get(4), "Nullable".equalsIgnoreCase((String)rows[i].get(5)), i + 1, null, "");
            temp.add(column);
            ++i;
        }
        return temp.toArray(new Column[temp.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getRemarks(String iniComment, String tableName, String columnName) {
        if (iniComment != null && iniComment.length() > 0) {
            return iniComment;
        }
        String comment = "";
        try {
            Connection con = this.getBookmark().getConnection();
            DatabaseAdapter adapter = this.getBookmark().getAdapter();
            Statement stmt = con.createStatement();
            try {
                if (adapter != null && stmt != null && adapter.getRemarksQuery(tableName, columnName) != null) {
                    stmt.execute(adapter.getRemarksQuery(tableName, columnName));
                    ResultSet set = stmt.getResultSet();
                    try {
                        if (set.next()) {
                            comment = set.getString(1);
                        }
                        Object var9_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_10 = null;
                        set.close();
                        throw throwable;
                    }
                    set.close();
                }
                Object var11_14 = null;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                stmt.close();
                throw throwable;
            }
            stmt.close();
            return comment;
        }
        catch (NotConnectedException notConnectedException) {
            return comment;
        }
        catch (SQLException sQLException) {}
        return comment;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Index[] getIndexes() {
        ArrayList indexList = new ArrayList();
        HashMap<String, IndexImpl> temp = new HashMap<String, IndexImpl>();
        try {
            Connection connection = this.getBookmark().getConnection();
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet resultSet = metaData.getIndexInfo(null, this.getSchema(), this.getName(), false, false);
            try {
                while (resultSet.next()) {
                    short type = resultSet.getShort(7);
                    if (type == 0) continue;
                    String indexName = resultSet.getString(6);
                    boolean notUnique = resultSet.getBoolean(4);
                    IndexImpl index = (IndexImpl)temp.get(indexName);
                    if (index == null) {
                        index = new IndexImpl(this, indexName, !notUnique);
                        temp.put(indexName, index);
                    }
                    String columnName = resultSet.getString(9);
                    String ascending = resultSet.getString(10);
                    index.addColumn(columnName, ascending == null ? null : (ascending.toUpperCase().startsWith("A") ? Boolean.TRUE : Boolean.FALSE));
                }
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                resultSet.close();
                throw throwable;
            }
            {
                Object var12_14 = null;
            }
            resultSet.close();
            indexList.addAll(temp.values());
            return indexList.toArray(new Index[indexList.size()]);
        }
        catch (NotConnectedException notConnectedException) {
            return indexList.toArray(new Index[indexList.size()]);
        }
        catch (SQLException sQLException) {}
        return indexList.toArray(new Index[indexList.size()]);
    }

    public Boolean exists() {
        return this.exists;
    }

    public String getQuotedTableName() {
        return this.getBookmark().filterQuoteName(this.getQualifiedName());
    }

    public Column[] getPrimaryKeyColumns() throws NotConnectedException, SQLException {
        if (this.columns == null) {
            this.columns = this.getColumns();
        }
        return ModelUtil.extractPrimaryKeyColumns(this.columns);
    }

    public ForeignKey[] getExportedKeys() throws SQLException, NotConnectedException {
        return this.getBookmark().getDatabase().getExportedKeys(this.getSchema(), this.getName());
    }

    public ForeignKey[] getImportedKeys() throws SQLException, NotConnectedException {
        return this.getBookmark().getDatabase().getImportedKeys(this.getSchema(), this.getName());
    }

    public ForeignKey[] getReferences() throws SQLException, NotConnectedException {
        ForeignKey[] importedKeys = this.getImportedKeys();
        ForeignKey[] exportedKeys = this.getExportedKeys();
        ArrayList<ForeignKey> list = new ArrayList<ForeignKey>();
        int i = 0;
        int length = importedKeys == null ? 0 : importedKeys.length;
        while (i < length) {
            list.add(importedKeys[i]);
            ++i;
        }
        i = 0;
        length = exportedKeys == null ? 0 : exportedKeys.length;
        while (i < length) {
            if (!list.contains(exportedKeys[i])) {
                list.add(exportedKeys[i]);
            }
            ++i;
        }
        return list.toArray(new ForeignKey[list.size()]);
    }

    public boolean isSynonym() {
        return this.isSynonym;
    }

    /*
     * Exception decompiling
     */
    public String getCreateStatement() throws NotConnectedException, SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [1 : 154->160)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Trigger[] getTriggers() throws NotConnectedException, SQLException {
        ArrayList<TriggerImpl> list = new ArrayList<TriggerImpl>();
        DatabaseAdapter adapter = this.getBookmark().getAdapter();
        if (adapter == null) {
            return null;
        }
        String query = adapter.getTriggersStatement(this.getSchema(), this.getName());
        Connection con = this.getBookmark().getConnection();
        Statement stmt = con.createStatement();
        if (adapter == null) return list.toArray(new Trigger[list.size()]);
        if (stmt == null) return list.toArray(new Trigger[list.size()]);
        if (query == null) return list.toArray(new Trigger[list.size()]);
        try {
            stmt.execute(query);
            ResultSet set = stmt.getResultSet();
            try {
                if (set.next()) {
                    TriggerImpl newTrigger;
                    String name = set.getString(1);
                    String moment = set.getString(2);
                    String forEach = set.getString(3);
                    String event = set.getString(4);
                    String actionType = set.getString(5);
                    String columnName = set.getString(6);
                    String language = set.getString(7);
                    String referencing = set.getString(8);
                    String whenClause = set.getString(9);
                    String status = set.getString(10);
                    String body = set.getString(11);
                    while (set.next()) {
                        if (name.equals(set.getString(1)) && moment.equals(set.getString(2)) && forEach.equals(set.getString(3)) && event.equals(set.getString(4)) && actionType.equals(set.getString(5)) && columnName.equals(set.getString(6)) && language.equals(set.getString(7)) && referencing.equals(set.getString(8)) && whenClause.equals(set.getString(9)) && status.equals(set.getString(10))) {
                            body = String.valueOf(body) + set.getString(11);
                            continue;
                        }
                        newTrigger = new TriggerImpl(name, moment, forEach, event, actionType, columnName, language, referencing, whenClause, status, body);
                        list.add(newTrigger);
                        name = set.getString(1);
                        moment = set.getString(2);
                        forEach = set.getString(3);
                        event = set.getString(4);
                        actionType = set.getString(5);
                        columnName = set.getString(6);
                        language = set.getString(7);
                        referencing = set.getString(8);
                        whenClause = set.getString(9);
                        status = set.getString(10);
                        body = set.getString(11);
                    }
                    newTrigger = new TriggerImpl(name, moment, forEach, event, actionType, columnName, language, referencing, whenClause, status, body);
                    list.add(newTrigger);
                }
                Object var19_21 = null;
            }
            catch (Throwable throwable) {
                Object var19_20 = null;
                set.close();
                throw throwable;
            }
            set.close();
            Object var21_24 = null;
        }
        catch (Throwable throwable) {
            Object var21_23 = null;
            stmt.close();
            throw throwable;
        }
        stmt.close();
        return list.toArray(new Trigger[list.size()]);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Check[] getChecks() throws NotConnectedException, SQLException {
        ArrayList<CheckImpl> list = new ArrayList<CheckImpl>();
        DatabaseAdapter adapter = this.getBookmark().getAdapter();
        if (adapter == null) {
            return null;
        }
        String query = adapter.getChecksStatement(this.getSchema(), this.getName());
        Connection con = this.getBookmark().getConnection();
        Statement stmt = con.createStatement();
        if (adapter == null) return list.toArray(new Check[list.size()]);
        if (stmt == null) return list.toArray(new Check[list.size()]);
        if (query == null) return list.toArray(new Check[list.size()]);
        try {
            stmt.execute(query);
            ResultSet set = stmt.getResultSet();
            try {
                while (set.next()) {
                    CheckImpl newCheck = new CheckImpl(set.getString(1), set.getString(2));
                    list.add(newCheck);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                set.close();
                throw throwable;
            }
            {
                Object var8_10 = null;
                set.close();
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            stmt.close();
            throw throwable;
        }
        {
            Object var10_13 = null;
        }
        stmt.close();
        return list.toArray(new Check[list.size()]);
    }

    public Privilege[] getPrivileges() throws NotConnectedException, SQLException {
        ArrayList<PrivilegeImpl> privilegeList = new ArrayList<PrivilegeImpl>();
        try {
            Connection connection = this.getBookmark().getConnection();
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet set = metaData.getTablePrivileges(null, this.getSchema(), this.getName());
            while (set.next()) {
                String isGrantable = set.getString(8);
                PrivilegeImpl privilege = new PrivilegeImpl(set.getString(5), set.getString(6), set.getString(7), isGrantable.toUpperCase().equals("YES"));
                privilegeList.add(privilege);
            }
            set.close();
        }
        catch (NotConnectedException notConnectedException) {
        }
        catch (SQLException sQLException) {}
        return privilegeList.toArray(new Privilege[privilegeList.size()]);
    }
}

