/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.model;

import com.quantum.Messages;
import com.quantum.log.QuantumLog;
import com.quantum.model.Bookmark;
import com.quantum.model.ConnectionEstablisher;
import com.quantum.model.JDBCDriver;
import com.quantum.util.connection.ConnectionException;
import com.quantum.util.connection.PasswordFinder;
import com.quantum.util.proxy.ProxyFactory;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;

class ConnectionEstablisherImpl
implements ConnectionEstablisher {
    public static final String USERNAME = "user";
    public static final String PASSWORD = "password";
    private static final ConnectionEstablisher instance = new ConnectionEstablisherImpl();
    static /* synthetic */ Class class$0;

    private ConnectionEstablisherImpl() {
    }

    public static ConnectionEstablisher getInstance() {
        return instance;
    }

    public Connection connect(Bookmark bookmark, PasswordFinder passwordFinder) throws ConnectionException, SQLException {
        String password = bookmark.getPassword();
        if (bookmark.getPromptForPassword()) {
            password = passwordFinder.getPassword();
            if (passwordFinder.isPasswordMeantToBeSaved()) {
                bookmark.setPassword(password);
            }
        }
        if (password != null) {
            Connection connection = this.connect(bookmark, password);
            if (connection != null) {
                bookmark.setAutoCommit(bookmark.getDefaultAutoCommit());
                connection.setAutoCommit(bookmark.isAutoCommit());
            }
            return connection;
        }
        return null;
    }

    private Connection connect(Bookmark bookmark, String password) throws ConnectionException, SQLException {
        JDBCDriver jdbcDriver = bookmark.getJDBCDriver();
        QuantumLog.getInstance().info("Instantiating driver \"" + jdbcDriver.getName() + "\"");
        Driver driver = ProxyFactory.createDriverProxy(bookmark, jdbcDriver.getDriver());
        if (driver != null) {
            Properties properties = this.getConnectionProperties(bookmark, password);
            QuantumLog.getInstance().info("Connecting to: " + bookmark.getName());
            Connection connection = driver.connect(bookmark.getConnect(), properties);
            if (connection == null) {
                throw new ConnectionException("Error: Driver returned a null connection: " + bookmark.toString());
            }
            this.updateJDBCDriverDetails(jdbcDriver, connection);
            QuantumLog.getInstance().info("Sucessfully connected to: " + bookmark.getName());
            return connection;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.quantum.util.connection.ConnectionException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        throw new ConnectionException(Messages.getString(clazz, "couldNotInstantiateDriver", new Object[]{jdbcDriver.getClassName(), bookmark.getName()}));
    }

    private Properties getConnectionProperties(Bookmark bookmark, String password) {
        Properties connectionProperties = new Properties();
        connectionProperties.put(USERNAME, bookmark.getUsername());
        connectionProperties.put(PASSWORD, password);
        Properties adapterSpecificProperties = bookmark.getAdapter().getConnectionProperties();
        if (adapterSpecificProperties != null && !adapterSpecificProperties.isEmpty()) {
            connectionProperties.putAll((Map<?, ?>)adapterSpecificProperties);
        }
        return connectionProperties;
    }

    private void updateJDBCDriverDetails(JDBCDriver jdbcDriver, Connection connection) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        jdbcDriver.setName(metaData.getDriverName());
        jdbcDriver.setVersion(metaData.getDriverVersion());
    }
}

