/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.model;

import com.quantum.QuantumPlugin;
import com.quantum.adapters.AdapterFactory;
import com.quantum.adapters.DatabaseAdapter;
import com.quantum.log.QuantumLog;
import com.quantum.model.BookmarkCollection;
import com.quantum.model.ConnectionEstablisher;
import com.quantum.model.ConnectionEstablisherImpl;
import com.quantum.model.DataType;
import com.quantum.model.Database;
import com.quantum.model.DatabaseObject;
import com.quantum.model.DatabaseObjectFactory;
import com.quantum.model.Entity;
import com.quantum.model.JDBCDriver;
import com.quantum.model.Schema;
import com.quantum.util.QuantumUtil;
import com.quantum.util.connection.Connectable;
import com.quantum.util.connection.ConnectionException;
import com.quantum.util.connection.NotConnectedException;
import com.quantum.util.connection.PasswordFinder;
import com.quantum.util.sql.SQLGrammar;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;

public class Bookmark
implements Connectable {
    public static final int SCHEMA_RULE_USE_ALL = 1;
    public static final int SCHEMA_RULE_USE_DEFAULT = 2;
    public static final int SCHEMA_RULE_USE_SELECTED = 3;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private String name = "";
    private String username = "";
    private String password = "";
    private String connectionUrl = "";
    private JDBCDriver driver;
    private boolean quoteAll;
    private boolean ignoreQueryViewSetting;
    private Set dbKeywords = null;
    private String extraNameChars = "";
    private DataType[] dataTypes = null;
    private String identifierQuoteString = "\"";
    private int schemaRule = 1;
    private Map quickList = new Hashtable();
    private Set schemas = new HashSet();
    private Connection connection = null;
    private ConnectionEstablisher connectionEstablisher;
    private boolean changed = true;
    private List queries = Collections.synchronizedList(new ArrayList());
    private boolean promptForPassword = false;
    private boolean autoCommit = true;
    private String autoCommitPreference = "Always True";
    private Database database;
    private Schema defaultSchema;

    public Bookmark() {
        this(ConnectionEstablisherImpl.getInstance());
    }

    public Bookmark(ConnectionEstablisher connectionEstablisher) {
        this.connectionEstablisher = connectionEstablisher;
    }

    public Bookmark(Bookmark data) {
        this();
        this.setName(data.getName());
        this.setUsername(data.getUsername());
        this.setPassword(data.getPassword());
        this.setConnect(data.getConnect());
        this.setJDBCDriver(data.getJDBCDriver());
        this.setPromptForPassword(data.getPromptForPassword());
        this.setAutoCommit(data.isAutoCommit());
        this.setAutoCommitPreference(data.getAutoCommitPreference());
        this.setQuoteAll(data.isQuoteAll());
        this.setIgnoreQueryViewSetting(data.isIgnoreQueryViewSetting());
        this.setSchemaRule(data.getSchemaRule());
        this.schemas.addAll(data.schemas);
        this.quickList = new Hashtable(data.quickList);
    }

    public String getConnect() {
        return this.connectionUrl;
    }

    public String getPassword() {
        if (this.promptForPassword) {
            return null;
        }
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setConnect(String connectionUrl) {
        if (connectionUrl == null) {
            connectionUrl = "";
        }
        this.connectionUrl = connectionUrl;
    }

    public void setPassword(String password) {
        if (password == null) {
            password = "";
        }
        this.password = password;
    }

    public void setUsername(String username) {
        if (username == null) {
            username = "";
        }
        this.username = username;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            name = "";
        }
        if (!name.equals(this.name)) {
            String oldName = this.name;
            this.name = name;
            this.propertyChangeSupport.firePropertyChange("name", oldName, this.name);
            this.changed = true;
        }
    }

    public boolean isEmpty() {
        return this.name.equals("") && this.username.equals("") && this.password.equals("") && this.connectionUrl.equals("") && this.driver.equals("") && this.driver == null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        buffer.append("name=");
        buffer.append(this.name);
        buffer.append(", ");
        buffer.append("username=");
        buffer.append(this.username);
        buffer.append(", ");
        buffer.append("password=****");
        buffer.append(", ");
        buffer.append("connect=");
        buffer.append(this.connectionUrl);
        buffer.append(", ");
        buffer.append("driver=");
        buffer.append(this.driver);
        buffer.append("]");
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection connect(PasswordFinder passwordFinder) throws ConnectionException, SQLException {
        boolean isConnected = this.isConnected();
        if (this.connection == null) {
            this.connection = this.connectionEstablisher.connect(this, passwordFinder);
            if (this.connection != null) {
                try {
                    DatabaseMetaData metadata = this.connection.getMetaData();
                    String keywords = metadata.getSQLKeywords();
                    this.extraNameChars = metadata.getExtraNameCharacters();
                    String[] keywordArray = keywords.split(",");
                    this.dbKeywords = Collections.synchronizedSet(new HashSet());
                    Set set = this.dbKeywords;
                    synchronized (set) {
                        int i = 0;
                        while (i < keywordArray.length) {
                            this.dbKeywords.add(keywordArray[i].trim().toUpperCase());
                            ++i;
                        }
                    }
                    this.dataTypes = this.getDatabase().getTypes();
                    this.identifierQuoteString = metadata.getIdentifierQuoteString();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.isConnected() != isConnected) {
            this.propertyChangeSupport.firePropertyChange("connected", isConnected, this.isConnected());
        }
        return this.connection;
    }

    public Connection getConnection() throws NotConnectedException {
        if (this.connection == null) {
            throw new NotConnectedException();
        }
        return this.connection;
    }

    public boolean isConnected() {
        return this.connection != null;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void disconnect() throws SQLException {
        boolean isConnected = this.isConnected();
        try {
            if (this.connection != null) {
                this.connection.close();
            }
            QuantumLog.getInstance().info("Disconnecting from bookmark " + this.name);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.connection = null;
            this.database = null;
            this.dbKeywords = null;
            this.dataTypes = null;
            this.defaultSchema = null;
            if (this.isConnected() == isConnected) throw throwable;
            this.propertyChangeSupport.firePropertyChange("connected", isConnected, this.isConnected());
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.connection = null;
            this.database = null;
            this.dbKeywords = null;
            this.dataTypes = null;
            this.defaultSchema = null;
            if (this.isConnected() == isConnected) return;
            this.propertyChangeSupport.firePropertyChange("connected", isConnected, this.isConnected());
            return;
        }
    }

    public void addSchema(String schema) {
        if (schema != null && schema.trim().length() > 0) {
            this.addSchema(new Schema(schema));
        }
    }

    public void addSchema(Schema qualifier) {
        if (qualifier != null) {
            this.schemas.add(qualifier);
            this.changed = true;
            this.propertyChangeSupport.firePropertyChange("schemas", null, null);
        }
    }

    public void setSchemaSelections(Schema[] schemas) {
        this.schemas.clear();
        int i = 0;
        int length = schemas == null ? 0 : schemas.length;
        while (i < length) {
            this.schemas.add(schemas[i]);
            ++i;
        }
        this.changed = true;
        this.propertyChangeSupport.firePropertyChange("schemas", null, null);
    }

    public Schema[] getSchemaSelections() {
        ArrayList list = new ArrayList(this.schemas);
        Collections.sort(list);
        return list.toArray(new Schema[list.size()]);
    }

    public Schema[] getSchemas() throws NotConnectedException, SQLException {
        Schema[] schemaArray;
        Schema[] schemas = null;
        if (!this.useUsernameAsSchema()) {
            schemas = this.useAllSchemas() ? this.getDatabase().getSchemas() : this.verifySchemas(this.getSchemaSelections());
        }
        if (schemas == null || schemas.length == 0) {
            Schema[] schemaArray2 = new Schema[1];
            schemaArray = schemaArray2;
            schemaArray2[0] = this.getDefaultSchema();
        } else {
            schemaArray = schemas;
        }
        return schemaArray;
    }

    public Schema getSchema(String name) throws NotConnectedException, SQLException {
        Schema result = null;
        if (name != null) {
            Schema[] schemas = this.getSchemas();
            int i = 0;
            int length = schemas == null ? 0 : schemas.length;
            while (i < length) {
                if (name.equals(schemas[i].getName())) {
                    result = schemas[i];
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    private Schema[] verifySchemas(Schema[] schemaSelections) throws NotConnectedException, SQLException {
        Schema[] schemasFromDatabase = this.getDatabase().getSchemas();
        List<Schema> list = Arrays.asList(schemasFromDatabase);
        int i = 0;
        int length = schemaSelections == null ? 0 : schemaSelections.length;
        while (i < length) {
            schemaSelections[i].setExists(list.contains(schemaSelections[i]));
            ++i;
        }
        return schemaSelections;
    }

    public Schema getDefaultSchema() throws NotConnectedException, SQLException {
        if (this.defaultSchema == null) {
            String username = this.getDatabase().getUsername();
            String actual = this.getAdapter().getDefaultSchema(username);
            this.defaultSchema = new Schema(actual, username, true);
        }
        return this.defaultSchema;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Bookmark)) {
            return false;
        }
        String name = ((Bookmark)obj).getName();
        return name.equals(this.getName());
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void addQuickListEntry(String type, String schemaName, String name, boolean isSynonym) {
        DatabaseObject object = DatabaseObjectFactory.getInstance().create(this, schemaName, name, type, isSynonym);
        this.quickList.put(object.getQualifiedName(), object);
        this.propertyChangeSupport.firePropertyChange("quickList", null, null);
        this.changed = true;
    }

    public void addQuickListEntry(DatabaseObject entity) {
        this.addQuickListEntry(entity.getType(), entity.getSchema(), entity.getName(), entity.isSynonym());
    }

    public void removeQuickListEntry(DatabaseObject entity) {
        if (entity != null && this.quickList.containsKey(entity.getQualifiedName())) {
            this.quickList.remove(entity.getQualifiedName());
            this.propertyChangeSupport.firePropertyChange("quickList", null, null);
            this.changed = true;
        }
    }

    public DatabaseObject[] getQuickListEntries() {
        return this.quickList.values().toArray(new Entity[this.quickList.size()]);
    }

    public boolean hasQuickList() {
        return !this.quickList.isEmpty();
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean b) {
        this.changed = b;
    }

    public Database getDatabase() throws NotConnectedException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        if (this.database == null) {
            this.database = new Database(this);
        }
        return this.database;
    }

    public DatabaseAdapter getAdapter() {
        return this.driver == null ? null : AdapterFactory.getInstance().getAdapter(this.driver.getType());
    }

    public DatabaseObject[] getObjectsForSchema(Schema schema, String type) throws SQLException {
        try {
            DatabaseObject[] objects = this.getDatabase().getObjects(this, schema, type);
            return objects;
        }
        catch (NotConnectedException notConnectedException) {
            return new DatabaseObject[0];
        }
    }

    public DatabaseObject getObject(Schema schema, String name) throws SQLException {
        DatabaseObject result = null;
        if (schema != null && name != null) {
            DatabaseObject[] objects = this.getObjectsForSchema(schema, null);
            int i = 0;
            int length = objects == null ? 0 : objects.length;
            while (result == null && i < length) {
                if (schema.getName().equals(objects[i].getSchema()) && name.equalsIgnoreCase(objects[i].getName())) {
                    result = objects[i];
                }
                ++i;
            }
        }
        return result;
    }

    public boolean isInQuickList(Entity entity) {
        return this.quickList.containsKey(entity.getQualifiedName());
    }

    public void addQuery(String queryString) {
        if (this.queries.contains(queryString)) {
            this.queries.remove(queryString);
        }
        this.queries.add(queryString);
        int size = this.getQueryHistorySize();
        while (this.queries.size() > size) {
            this.queries.remove(0);
        }
        this.propertyChangeSupport.firePropertyChange("queries", null, null);
        this.changed = true;
    }

    public String[] getQueries() {
        return this.queries.toArray(new String[this.queries.size()]);
    }

    private int getQueryHistorySize() {
        IPreferenceStore store = QuantumPlugin.getDefault().getPreferenceStore();
        return store.getInt(String.valueOf(this.getClass().getName()) + ".queryHistorySize");
    }

    public boolean getPromptForPassword() {
        return this.promptForPassword;
    }

    public void setPromptForPassword(boolean b) {
        this.promptForPassword = b;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public String getAutoCommitPreference() {
        return this.autoCommitPreference;
    }

    public void setAutoCommit(boolean b) {
        this.autoCommit = b;
    }

    public void setAutoCommitPreference(String string) {
        this.autoCommitPreference = string;
    }

    public boolean getDefaultAutoCommit() {
        if (this.autoCommitPreference.equals("Always True")) {
            return true;
        }
        if (this.autoCommitPreference.equals("Always False")) {
            return false;
        }
        if (this.autoCommitPreference.equals("Last Saved")) {
            return this.autoCommit;
        }
        return true;
    }

    public void setJDBCDriver(JDBCDriver jdbcDriver) {
        this.driver = BookmarkCollection.getInstance().findDriver(jdbcDriver);
        this.changed = true;
    }

    public JDBCDriver getJDBCDriver() {
        return this.driver;
    }

    public boolean useAllSchemas() {
        return this.schemaRule == 1;
    }

    public boolean useUsernameAsSchema() {
        return this.schemaRule == 2;
    }

    public boolean useSelectedSchemas() {
        return this.schemaRule == 3;
    }

    public int getSchemaRule() {
        return this.schemaRule;
    }

    public void setSchemaRule(int schemaRule) {
        if (this.schemaRule != schemaRule) {
            this.schemaRule = schemaRule;
            this.propertyChangeSupport.firePropertyChange("schemas", null, null);
        }
    }

    public String getDisplayName() {
        return this.name;
    }

    public void removeQuery(String query) {
        if (this.queries.remove(query)) {
            this.propertyChangeSupport.firePropertyChange("queries", null, null);
            this.changed = true;
        }
    }

    public boolean isQuoteAll() {
        return this.quoteAll;
    }

    public void setQuoteAll(boolean quoteAll) {
        this.quoteAll = quoteAll;
    }

    public boolean isIgnoreQueryViewSetting() {
        return this.ignoreQueryViewSetting;
    }

    public void setIgnoreQueryViewSetting(boolean selection) {
        this.ignoreQueryViewSetting = selection;
    }

    public String filterQuoteName(String tableName) {
        String justTableName = QuantumUtil.getTableName(tableName);
        if (this.quoteAll || !tableName.equals(tableName.toUpperCase())) {
            return QuantumUtil.quote(tableName, this.identifierQuoteString);
        }
        int i = 0;
        while (i < justTableName.length()) {
            char c = justTableName.charAt(i);
            if (!Character.isLetterOrDigit(c) && c != '_' && this.extraNameChars.indexOf(c) < 0) {
                return QuantumUtil.quote(tableName, this.identifierQuoteString);
            }
            ++i;
        }
        if (this.isKeyword(justTableName)) {
            return QuantumUtil.quote(tableName, this.identifierQuoteString);
        }
        return tableName;
    }

    public boolean isKeyword(String word) {
        return this.dbKeywords.contains(word.toUpperCase()) || SQLGrammar.getInstance().isKeyword(word);
    }

    public String getObjectType(String word) {
        return this.getAdapter().getObjectType(this, word);
    }

    public DataType[] getDataTypes() throws NotConnectedException, SQLException {
        if (this.connection == null) {
            throw new NotConnectedException();
        }
        if (this.dataTypes == null) {
            throw new SQLException();
        }
        return this.dataTypes;
    }
}

