/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.log;

public class Severity {
    public static final Severity DEBUG = new Severity("debug", 0);
    public static final Severity INFO = new Severity("info", 1);
    public static final Severity WARN = new Severity("warn", 2);
    public static final Severity ERROR = new Severity("error", 3);
    private static final Severity[] SEVERITIES = new Severity[]{DEBUG, INFO, WARN, ERROR};
    private final String name;
    private final int rank;

    private Severity(String name, int rank) {
        this.name = name;
        this.rank = rank;
    }

    public String getName() {
        return this.name;
    }

    public int getRank() {
        return this.rank;
    }

    public static Severity[] getSeverities() {
        return SEVERITIES;
    }

    public static Severity getSeverity(String level) {
        if (DEBUG.getName().equals(level)) {
            return DEBUG;
        }
        if (INFO.getName().equals(level)) {
            return INFO;
        }
        if (WARN.getName().equals(level)) {
            return WARN;
        }
        if (ERROR.getName().equals(level)) {
            return ERROR;
        }
        return INFO;
    }
}

