/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.extensions;

import com.quantum.extensions.ExtensionAction;
import com.quantum.extensions.IDataExtension;
import com.quantum.extensions.IMetadataExtension;
import com.quantum.extensions.IQuantumExtension;
import com.quantum.view.bookmark.BookmarkView;
import com.quantum.view.tableview.TableView;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.WorkbenchException;
import org.w3c.dom.Document;

public class ProcessServiceMembers {
    private static final String EXTENSION_POINT_METADATA = "com.quantum.Quantum.metadata";
    private static final String EXTENSION_POINT_DATA = "com.quantum.Quantum.data";
    private static final String FUNCTION_NAME_ATTRIBUTE = "label";
    private static final String CLASS_ATTRIBUTE = "class";

    public static void process(IViewPart view, Vector extensionActions) throws WorkbenchException {
        String extPointId;
        extensionActions.clear();
        IPluginRegistry registry = Platform.getPluginRegistry();
        if (view instanceof BookmarkView) {
            extPointId = EXTENSION_POINT_METADATA;
        } else if (view instanceof TableView) {
            extPointId = EXTENSION_POINT_DATA;
        } else {
            return;
        }
        IExtensionPoint extensionPoint = registry.getExtensionPoint(extPointId);
        if (extensionPoint == null) {
            throw new WorkbenchException("unable to resolve extension-point: " + extPointId);
        }
        IConfigurationElement[] members = extensionPoint.getConfigurationElements();
        int m = 0;
        while (m < members.length) {
            String functionName;
            IConfigurationElement member = members[m];
            IExtension extension = member.getDeclaringExtension();
            String pluginLabel = extension.getDeclaringPluginDescriptor().getLabel();
            if (pluginLabel == null) {
                pluginLabel = "[unnamed plugin]";
            }
            if ((functionName = member.getAttribute(FUNCTION_NAME_ATTRIBUTE)) == null) {
                functionName = "[unnamed function]";
            }
            String label = String.valueOf(pluginLabel) + "/" + functionName;
            IQuantumExtension proxy = null;
            if (view instanceof BookmarkView) {
                proxy = new MetadataFunctionProxy(member);
            } else if (view instanceof TableView) {
                proxy = new DataFunctionProxy(member);
            }
            extensionActions.add(new ExtensionAction(view, label, label, proxy));
            ++m;
        }
    }

    private static class MetadataFunctionProxy
    implements IMetadataExtension {
        private IMetadataExtension delegate = null;
        private IConfigurationElement element;
        private boolean invoked = false;

        public MetadataFunctionProxy(IConfigurationElement element) {
            this.element = element;
        }

        public final void run(Document doc) {
            try {
                this.getDelegate().run(doc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private final IMetadataExtension getDelegate() throws Exception {
            if (this.invoked) {
                return this.delegate;
            }
            this.invoked = true;
            try {
                Object callback = this.element.createExecutableExtension(ProcessServiceMembers.CLASS_ATTRIBUTE);
                if (!(callback instanceof IMetadataExtension)) {
                    String message = "callback class '" + callback.getClass().getName() + "' is not an IFunction";
                    System.err.println(message);
                    throw new ClassCastException(message);
                }
                this.delegate = (IMetadataExtension)callback;
            }
            catch (CoreException ex) {
                System.err.println(ex.getMessage());
                ex.printStackTrace();
                throw ex;
            }
            catch (Error err) {
                System.err.println(err.getMessage());
                err.printStackTrace();
                throw err;
            }
            return this.delegate;
        }
    }

    private static class DataFunctionProxy
    implements IDataExtension {
        private IDataExtension delegate = null;
        private IConfigurationElement element;
        private boolean invoked = false;

        public DataFunctionProxy(IConfigurationElement element) {
            this.element = element;
        }

        public final void run(Document doc) {
            try {
                this.getDelegate().run(doc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private final IDataExtension getDelegate() throws Exception {
            if (this.invoked) {
                return this.delegate;
            }
            this.invoked = true;
            try {
                Object callback = this.element.createExecutableExtension(ProcessServiceMembers.CLASS_ATTRIBUTE);
                if (!(callback instanceof IDataExtension)) {
                    String message = "callback class '" + callback.getClass().getName() + "' is not an IFunction";
                    System.err.println(message);
                    throw new ClassCastException(message);
                }
                this.delegate = (IDataExtension)callback;
            }
            catch (CoreException ex) {
                System.err.println(ex.getMessage());
                ex.printStackTrace();
                throw ex;
            }
            catch (Error err) {
                System.err.println(err.getMessage());
                err.printStackTrace();
                throw err;
            }
            return this.delegate;
        }
    }
}

