/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.editors;

import com.quantum.QuantumPlugin;
import com.quantum.editors.ColorManager;
import com.quantum.editors.NonRuleBasedDamagerRepairer;
import com.quantum.editors.SQLColorConstants;
import com.quantum.editors.SQLContentAssistProcessor;
import java.util.HashMap;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class SQLSourceViewerConfiguration
extends SourceViewerConfiguration {
    private PresentationReconciler reconciler = new PresentationReconciler();
    private ColorManager colorManager;
    private HashMap cache = new HashMap();
    private boolean textBold = false;
    private boolean keywordBold = true;
    private boolean stringBold = false;
    private boolean commentBold = false;
    private boolean numericBold = false;

    public SQLSourceViewerConfiguration(ColorManager colorManager) {
        this.colorManager = colorManager;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__sql_comment", "__sql_keyword", "__sql_word"};
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        this.initializeColors();
        return this.reconciler;
    }

    public void loadPrefs() {
        IPreferenceStore store = QuantumPlugin.getDefault().getPreferenceStore();
        this.textBold = store.getBoolean("quantum.text.bold");
        this.keywordBold = store.getBoolean("quantum.keyword.bold");
        this.stringBold = store.getBoolean("quantum.string.bold");
        this.commentBold = store.getBoolean("quantum.comment.bold");
        this.numericBold = store.getBoolean("quantum.numeric.bold");
        SQLColorConstants.BACKGROUND = PreferenceConverter.getColor((IPreferenceStore)store, (String)"quantum.background.color");
        SQLColorConstants.DEFAULT = PreferenceConverter.getColor((IPreferenceStore)store, (String)"quantum.text.color");
        SQLColorConstants.IDENTIFIER = PreferenceConverter.getColor((IPreferenceStore)store, (String)"quantum.text.color");
        SQLColorConstants.KEYWORD = PreferenceConverter.getColor((IPreferenceStore)store, (String)"quantum.keyword.color");
        SQLColorConstants.STRING = PreferenceConverter.getColor((IPreferenceStore)store, (String)"quantum.string.color");
        SQLColorConstants.COMMENT = PreferenceConverter.getColor((IPreferenceStore)store, (String)"quantum.comment.color");
        SQLColorConstants.NUMERIC = PreferenceConverter.getColor((IPreferenceStore)store, (String)"quantum.numeric.color");
    }

    public void initializeColors() {
        this.setDamageRepairer(this.getAttr(SQLColorConstants.KEYWORD, this.keywordBold), "__sql_keyword");
        this.setDamageRepairer(this.getAttr(SQLColorConstants.COMMENT, this.commentBold), "__sql_comment");
        this.setDamageRepairer(this.getAttr(SQLColorConstants.STRING, this.stringBold), "__sql_string");
        this.setDamageRepairer(this.getAttr(SQLColorConstants.DEFAULT, this.textBold), "__dftl_partition_content_type");
        this.setDamageRepairer(this.getAttr(SQLColorConstants.DEFAULT, this.textBold), "__sql_symbol");
        this.setDamageRepairer(this.getAttr(SQLColorConstants.DEFAULT, this.textBold), "__sql_word");
        this.setDamageRepairer(this.getAttr(SQLColorConstants.DEFAULT, this.textBold), "__sql_separator");
        this.setDamageRepairer(this.getAttr(SQLColorConstants.NUMERIC, this.numericBold), "__sql_numeric");
    }

    public TextAttribute getAttr(RGB color, boolean bold) {
        this.colorManager.getColor(SQLColorConstants.BACKGROUND);
        Color foreground = this.colorManager.getColor(color);
        TextAttribute attr = new TextAttribute(foreground);
        if (bold) {
            return new TextAttribute(foreground, attr.getBackground(), 1);
        }
        return attr;
    }

    public void setDamageRepairer(TextAttribute attr, String token) {
        NonRuleBasedDamagerRepairer ndr = (NonRuleBasedDamagerRepairer)this.cache.get(token);
        if (ndr == null) {
            ndr = new NonRuleBasedDamagerRepairer(attr);
            this.reconciler.setDamager((IPresentationDamager)ndr, token);
            this.reconciler.setRepairer((IPresentationRepairer)ndr, token);
            this.cache.put(token, ndr);
        } else {
            ndr.setTextAttribute(attr);
        }
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.setContentAssistProcessor((IContentAssistProcessor)new SQLContentAssistProcessor("default"), "__dftl_partition_content_type");
        assistant.enableAutoActivation(true);
        assistant.setAutoActivationDelay(500);
        assistant.setProposalPopupOrientation(21);
        assistant.setContextInformationPopupOrientation(21);
        return assistant;
    }
}

