/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.editors;

import com.quantum.QuantumPlugin;
import com.quantum.actions.ExecuteAction;
import com.quantum.actions.ExplainAction;
import com.quantum.editors.ColorManager;
import com.quantum.editors.SQLColorConstants;
import com.quantum.editors.SQLContentOutlinePage;
import com.quantum.editors.SQLDocumentProvider;
import com.quantum.editors.SQLSourceViewerConfiguration;
import com.quantum.sql.parser.SQLProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class SQLEditor
extends TextEditor
implements SQLProvider {
    private SQLSourceViewerConfiguration config;
    private ColorManager colorManager;
    private SQLContentOutlinePage outlinePage;
    private ExecuteAction executeAction;
    private ExplainAction explainAction;
    private IPropertyChangeListener preferenceListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            SQLEditor.this.config.loadPrefs();
            SQLEditor.this.config.initializeColors();
            SQLEditor.this.getSourceViewer().invalidateTextPresentation();
            StyledText widget = SQLEditor.this.getSourceViewer().getTextWidget();
            FontData font = PreferenceConverter.getFontData((IPreferenceStore)SQLEditor.this.getPreferenceStore(), (String)"quantum.font");
            widget.setFont(new Font((Device)Display.getCurrent(), font));
            Color background = SQLEditor.this.colorManager.getColor(SQLColorConstants.BACKGROUND);
            widget.setBackground(background);
        }
    };
    static /* synthetic */ Class class$0;

    public SQLEditor() {
        this.colorManager = new ColorManager();
        this.config = new SQLSourceViewerConfiguration(this.colorManager);
        this.config.loadPrefs();
        this.setPreferenceStore(QuantumPlugin.getDefault().getPreferenceStore());
        this.getPreferenceStore().addPropertyChangeListener(this.preferenceListener);
        this.setSourceViewerConfiguration(this.config);
        this.setDocumentProvider((IDocumentProvider)new SQLDocumentProvider());
    }

    public void dispose() {
        this.colorManager.dispose();
        this.executeAction.dispose();
        this.getPreferenceStore().removePropertyChangeListener(this.preferenceListener);
        super.dispose();
    }

    public void createPartControl(Composite arg0) {
        super.createPartControl(arg0);
        StyledText widget = this.getSourceViewer().getTextWidget();
        FontData font = PreferenceConverter.getFontData((IPreferenceStore)this.getPreferenceStore(), (String)"quantum.font");
        widget.setFont(new Font((Device)Display.getCurrent(), font));
        Color background = this.colorManager.getColor(SQLColorConstants.BACKGROUND);
        widget.setBackground(background);
    }

    public Object getAdapter(Class required) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(required)) {
            if (this.outlinePage == null) {
                this.outlinePage = new SQLContentOutlinePage((SQLDocumentProvider)this.getDocumentProvider(), this);
                if (this.getEditorInput() != null) {
                    this.outlinePage.setInput(this.getEditorInput());
                }
            }
            return this.outlinePage;
        }
        return super.getAdapter(required);
    }

    protected void createActions() {
        this.executeAction = new ExecuteAction((SQLProvider)this, (IEditorPart)this);
        this.explainAction = new ExplainAction(this, (IWorkbenchPart)this);
        super.createActions();
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        menu.add((IAction)this.executeAction);
        menu.add((IAction)this.explainAction);
        menu.add((IContributionItem)new Separator());
        super.editorContextMenuAboutToShow(menu);
    }

    public String getQuery() {
        return this.getSourceViewer().getTextWidget().getText();
    }

    public void clear() {
        this.getSourceViewer().getTextWidget().setText("");
    }
}

