/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.adapters;

import com.quantum.Messages;
import com.quantum.adapters.StatementExplainer;
import com.quantum.model.Bookmark;
import com.quantum.model.Column;
import com.quantum.model.DataType;
import com.quantum.model.Entity;
import com.quantum.model.Schema;
import com.quantum.model.SequenceMetadata;
import com.quantum.model.TableMetadata;
import com.quantum.util.QuantumUtil;
import com.quantum.util.StringMatrix;
import com.quantum.util.StringUtil;
import com.quantum.util.connection.NotConnectedException;
import com.quantum.util.sql.TypesHelper;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public abstract class DatabaseAdapter {
    private final String type;
    static /* synthetic */ Class class$0;

    protected DatabaseAdapter(String type) {
        this.type = type;
    }

    public String getDisplayName() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.quantum.adapters.DatabaseAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return Messages.getString(clazz, this.getType());
    }

    public String getShowTableQuery(String schema) {
        return null;
    }

    public String getShowViewQuery(String schema) {
        return null;
    }

    public String getShowSequenceQuery(String schema) {
        return null;
    }

    public String getTableQuery(String table) {
        return "SELECT * FROM " + table;
    }

    public String getNextValue(String sequence, String owner) {
        return null;
    }

    public String getPrevValue(String sequence, String owner) {
        return null;
    }

    public String getRemarksQuery(String tableName, String columnName) {
        return null;
    }

    public String getShowAliasQuery(String name) {
        return null;
    }

    public String quote(String string, int type, String typeString) {
        if (TypesHelper.isText(type)) {
            return "'" + StringUtil.substituteString(string, "'", "''") + "'";
        }
        if (type == 91 || type == 93) {
            if ((string = string.trim()).length() > 2) {
                String sub = string.substring(string.length() - 2, string.length() - 1);
                if (string.length() > 1 && sub.equals(".")) {
                    string = string.substring(0, string.length() - 2);
                }
            }
            return "'" + string + "'";
        }
        return string;
    }

    public String getCountQuery(String tableName) {
        return "SELECT COUNT(*) FROM " + tableName;
    }

    public String getDefaultSchema(String userid) {
        return userid;
    }

    public String getType() {
        return this.type;
    }

    protected String getQualifiedName(String schema, String name) {
        return schema != null && schema.length() > 0 ? String.valueOf(schema) + "." + name : name;
    }

    public Map getDefaultConnectionParameters() {
        return new HashMap();
    }

    public String getShowSynonymsQuery(String schema, String type) {
        return null;
    }

    public String getShowPackagesQuery(String userid) {
        return null;
    }

    public String getProceduresQuery(String schema, String pack) {
        return null;
    }

    public String getProcedureArgumentsQuery(String schema, String pack, String proc, int overload) {
        return null;
    }

    public String getCreateStatement(String schema, String viewName) {
        return null;
    }

    public boolean isExplainSupported() {
        return this.getStatementExplainer() != null;
    }

    public Properties getConnectionProperties() {
        return null;
    }

    public StatementExplainer getStatementExplainer() {
        return null;
    }

    public String getSequenceMetadataQuery(String schema, String sequenceName) {
        return null;
    }

    public String getTriggersStatement(String schema, String objectName) {
        return null;
    }

    public String getChecksStatement(String schema, String objectName) {
        return null;
    }

    public String buildInsert(Entity entity, StringMatrix columns, List noQuote) {
        return this.buildGenericInsert(entity, columns, false, noQuote);
    }

    public String buildPreparedInsert(Entity entity, StringMatrix columns) {
        return this.buildGenericInsert(entity, columns, true, null);
    }

    public String buildGenericInsert(Entity entity, StringMatrix columns, boolean prepared, List noQuote) {
        if (entity == null || columns == null) {
            return "";
        }
        Bookmark bookmark = entity.getBookmark();
        StringBuffer valuesClause = new StringBuffer();
        StringBuffer namesClause = new StringBuffer();
        String insertSentences = "";
        int iRow = 0;
        while (iRow < columns.size()) {
            int iCol = 0;
            while (iCol < columns.getNumColumns()) {
                if (iCol > 0) {
                    namesClause.append(", ");
                    valuesClause.append(", ");
                }
                String column = columns.getHeaderColumn(iCol);
                namesClause.append(bookmark != null ? bookmark.filterQuoteName(column) : column);
                if (!prepared) {
                    if (noQuote != null && iCol < noQuote.size() && ((Boolean)noQuote.get(iCol)).booleanValue()) {
                        valuesClause.append(columns.get(iCol, iRow));
                    } else {
                        valuesClause.append(this.quoteValue(entity, columns.getHeaderColumn(iCol), columns.get(iCol, iRow)));
                    }
                } else {
                    valuesClause.append("?");
                }
                ++iCol;
            }
            if (iRow > 0) {
                insertSentences = String.valueOf(insertSentences) + ";\n";
            }
            insertSentences = String.valueOf(insertSentences) + "INSERT INTO " + entity.getQuotedTableName();
            insertSentences = String.valueOf(insertSentences) + " (" + namesClause + " )";
            insertSentences = String.valueOf(insertSentences) + " VALUES  ( " + valuesClause + " )";
            if (prepared) break;
            ++iRow;
        }
        return insertSentences;
    }

    public String buildUpdate(Entity entity, StringMatrix columns, StringMatrix key, List noQuote, List noQuoteKeys) {
        if (entity == null || columns == null) {
            return "";
        }
        Bookmark bookmark = entity.getBookmark();
        StringBuffer setClause = new StringBuffer();
        String whereClause = "";
        String updateSentences = "";
        int iRow = 0;
        while (iRow < columns.size()) {
            int iCol = 0;
            while (iCol < columns.getNumColumns()) {
                if (iCol > 0) {
                    setClause.append(", ");
                }
                String column = columns.getHeaderColumn(iCol);
                setClause.append(bookmark != null ? bookmark.filterQuoteName(column) : column);
                setClause.append(" = ");
                if (noQuote != null && iCol < noQuote.size() && ((Boolean)noQuote.get(iCol)).booleanValue()) {
                    setClause.append(columns.get(iCol, iRow));
                } else {
                    setClause.append(this.quoteValue(entity, columns.getHeaderColumn(iCol), columns.get(iCol, iRow)));
                }
                ++iCol;
            }
            if (key != null && iRow < key.size()) {
                whereClause = this.getWhereClause(entity, key, iRow, noQuoteKeys);
            }
            if (iRow > 0) {
                updateSentences = String.valueOf(updateSentences) + ";\n";
            }
            updateSentences = String.valueOf(updateSentences) + "UPDATE " + entity.getQuotedTableName();
            updateSentences = String.valueOf(updateSentences) + " SET " + setClause.toString();
            if (whereClause.length() > 0) {
                updateSentences = String.valueOf(updateSentences) + " WHERE " + whereClause;
            }
            ++iRow;
        }
        return updateSentences;
    }

    public String buildDelete(Entity entity, StringMatrix key, List noQuoteKey) {
        if (entity == null) {
            return "";
        }
        String deleteSentences = "";
        String whereClause = "";
        if (key == null) {
            return "DELETE FROM " + entity.getQuotedTableName();
        }
        int iRow = 0;
        while (iRow < key.size()) {
            if (key != null && iRow < key.size()) {
                whereClause = this.getWhereClause(entity, key, iRow, noQuoteKey);
            }
            if (iRow > 0) {
                deleteSentences = String.valueOf(deleteSentences) + ";\n";
            }
            deleteSentences = String.valueOf(deleteSentences) + "DELETE FROM " + entity.getQuotedTableName();
            if (whereClause.length() > 0) {
                deleteSentences = String.valueOf(deleteSentences) + " WHERE " + whereClause;
            }
            ++iRow;
        }
        return deleteSentences;
    }

    public String buildSelectAllColumnsNoRows(Entity entity) {
        return "SELECT * FROM " + entity.getQuotedTableName() + " WHERE (1 = 0)";
    }

    public String buildSelectAllColumnsAllRows(Entity entity) {
        return "SELECT * FROM " + entity.getQuotedTableName();
    }

    public String buildSelect(Entity entity, Column[] columns, StringMatrix key) {
        if (entity == null || columns == null) {
            return "";
        }
        StringBuffer columnsList = new StringBuffer();
        String whereClause = "";
        String selectQuery = "";
        int iCol = 0;
        while (iCol < columns.length) {
            if (iCol > 0) {
                columnsList.append(", ");
            }
            columnsList.append(columns[iCol].getName());
            ++iCol;
        }
        if (key != null) {
            whereClause = this.getWhereClause(entity, key, 0, null);
        }
        selectQuery = String.valueOf(selectQuery) + "SELECT " + columnsList;
        selectQuery = String.valueOf(selectQuery) + " FROM " + entity.getQuotedTableName();
        if (whereClause.length() > 0) {
            selectQuery = String.valueOf(selectQuery) + " WHERE " + whereClause;
        }
        return selectQuery;
    }

    public String buildCreateTable(Bookmark bookmark, TableMetadata metadata, Schema schema, boolean useJavaTypes) throws NotConnectedException, SQLException {
        StringBuffer buffer = new StringBuffer("CREATE TABLE ");
        String tableName = bookmark.getDatabase().supportsSchemasInTableDefinitions() ? QuantumUtil.getQualifiedName(metadata.getSchema(), metadata.getName()) : metadata.getName();
        buffer.append(bookmark.filterQuoteName(tableName));
        buffer.append(" (");
        buffer.append(StringUtil.LINE_SEPARATOR);
        Column[] columns = metadata.getColumns();
        int i = 0;
        while (i < columns.length) {
            Column column = columns[i];
            if (i > 0) {
                buffer.append(",").append(StringUtil.LINE_SEPARATOR);
            }
            buffer.append("        ");
            buffer.append(column.getName());
            buffer.append(" ");
            buffer.append(this.getTypeName(bookmark, column, useJavaTypes));
            if (column.getDefaultValue() != null) {
                buffer.append(" DEFAULT ").append(column.getDefaultValue());
            }
            if (!column.isNullable()) {
                buffer.append(" NOT NULL ");
            }
            ++i;
        }
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append(");");
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append(this.buildPrimaryKey(bookmark, tableName, metadata));
        buffer.append(this.buildForeignKeys(bookmark, metadata, schema, false));
        buffer.append(this.buildRemarks(bookmark, tableName, metadata));
        buffer.append(this.buildTriggers(bookmark, tableName, metadata, schema));
        buffer.append(this.buildChecks(bookmark, tableName, metadata, schema));
        return buffer.toString();
    }

    public String getTypeName(Bookmark bookmark, Column column, boolean useJavaTypes) {
        String type = "";
        if (useJavaTypes) {
            try {
                type = this.javaToSQL(bookmark.getDataTypes(), column.getType());
            }
            catch (NotConnectedException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (type.equals("")) {
            type = column.getTypeName();
        }
        if (column.getSize() > 0L && !type.endsWith(")")) {
            type = String.valueOf(type) + "(" + String.valueOf(column.getSize());
            if (column.getNumberOfFractionalDigits() > 0) {
                type = String.valueOf(type) + "," + String.valueOf(column.getNumberOfFractionalDigits());
            }
            type = String.valueOf(type) + ")";
        }
        return type;
    }

    public String buildRemarks(Bookmark bookmark, String tableName, TableMetadata metadata) throws NotConnectedException, SQLException {
        return "";
    }

    public String buildTriggers(Bookmark bookmark, String tableName, TableMetadata metadata, Schema schema) {
        return "";
    }

    public String buildChecks(Bookmark bookmark, String tableName, TableMetadata metadata, Schema schema) {
        return "";
    }

    public String buildPrimaryKey(Bookmark bookmark, String tableName, TableMetadata metadata) throws NotConnectedException, SQLException {
        return "";
    }

    public String buildForeignKeys(Bookmark bookmark, TableMetadata metadata, Schema schema, boolean absoluteReference) throws NotConnectedException, SQLException {
        return "";
    }

    public String buildCreateSequence(Bookmark bookmark, SequenceMetadata metadata, Schema schema) throws NotConnectedException, SQLException {
        return "";
    }

    public String buildCreateView(Bookmark bookmark, TableMetadata metadata, Schema schema) throws NotConnectedException, SQLException {
        return "";
    }

    public String getWhereClause(Entity entity, StringMatrix key, int iRow, List noQuote) {
        StringBuffer whereClause = new StringBuffer();
        Bookmark bookmark = entity.getBookmark();
        int iKey = 0;
        while (iKey < key.getNumColumns()) {
            if (iKey > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append("(");
            String column = key.getHeaderColumn(iKey);
            whereClause.append(bookmark != null ? bookmark.filterQuoteName(column) : column);
            whereClause.append(" = ");
            if (noQuote != null && iKey < noQuote.size() && ((Boolean)noQuote.get(iKey)).booleanValue()) {
                whereClause.append(key.get(iKey, iRow));
            } else {
                whereClause.append(this.quoteValue(entity, key.getHeaderColumn(iKey), key.get(iKey, iRow)));
            }
            whereClause.append(")");
            ++iKey;
        }
        return whereClause.toString();
    }

    public String quoteValue(Entity entity, String columnName, String value) {
        if (entity != null && this.getColumn(entity, columnName) != null) {
            Column column = this.getColumn(entity, columnName);
            return this.quote(value, column.getType(), column.getTypeName());
        }
        return value;
    }

    public Column getColumn(Entity entity, String columnName) {
        try {
            return entity == null ? null : entity.getColumn(columnName);
        }
        catch (NotConnectedException notConnectedException) {
            return null;
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public String javaToSQL(DataType[] types, int javaType) {
        String SQL2 = "";
        int i = 0;
        while (i < types.length) {
            DataType type = types[i];
            if (type.getJavaType() == javaType) {
                SQL2 = type.getDatabaseTypeName();
                break;
            }
            ++i;
        }
        return SQL2;
    }

    public String getProcedureBodyStatement(String Schema2, String Package2, String Name, int Overload) {
        return null;
    }

    public String getObjectType(Bookmark bm, String object) {
        return "";
    }
}

