/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.adapters;

import com.quantum.adapters.DB2StatementExplainer;
import com.quantum.adapters.DatabaseAdapter;
import com.quantum.adapters.StatementExplainer;
import java.util.HashMap;
import java.util.Map;

public class DB2Adapter
extends DatabaseAdapter {
    private DB2StatementExplainer explainer = new DB2StatementExplainer();

    protected DB2Adapter() {
        super("DB2");
    }

    public String getShowTableQuery(String qualifier) {
        return "SELECT tabschema, TABNAME FROM syscat.tables WHERE tabschema = '" + qualifier.toUpperCase() + "' AND TYPE='T'";
    }

    public String getShowViewQuery(String qualifier) {
        return "SELECT tabschema, TABNAME FROM syscat.tables WHERE tabschema = '" + qualifier.toUpperCase() + "' AND TYPE='V'";
    }

    public String getShowSequenceQuery(String qualifier) {
        return "SELECT seqschema, SEQNAME FROM sysibm.syssequences WHERE seqschema = '" + qualifier.toUpperCase() + "'";
    }

    public String getNextValue(String sequence, String owner) {
        return "VALUES NEXTVAL FOR " + this.getQualifiedName(owner, sequence);
    }

    public String getPrevValue(String sequence, String owner) {
        return "VALUES PREVVAL FOR " + this.getQualifiedName(owner, sequence);
    }

    public Map getDefaultConnectionParameters() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("port", "50000");
        map.put("hostname", "localhost");
        return map;
    }

    public String getCreateStatement(String schema, String viewName) {
        return "select TEXT from SYSCAT.VIEWS where VIEWSCHEMA = '" + schema.toUpperCase() + "'" + "and VIEWNAME = '" + viewName.toUpperCase() + "'";
    }

    public StatementExplainer getStatementExplainer() {
        return this.explainer;
    }
}

