/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.actions;

import com.quantum.Messages;
import com.quantum.QuantumPlugin;
import com.quantum.model.BookmarkCollection;
import com.quantum.util.xml.XMLHelper;
import com.quantum.view.bookmark.BookmarkView;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ImportBookmarksAction
implements IViewActionDelegate {
    BookmarkView view;
    FileDialog dialog;

    public void init(IViewPart view) {
        this.view = (BookmarkView)view;
        this.dialog = new FileDialog(view.getSite().getShell(), 4096);
        this.dialog.setFilterExtensions(new String[]{"*.xml", "*.*"});
        this.dialog.setFilterNames(new String[]{Messages.getString("filedialog.exportxml.filter"), Messages.getString("filedialog.xmlFiles")});
    }

    public void run(IAction action) {
        this.dialog.setFilterPath(QuantumPlugin.getDefault().getPreferenceStore().getString("quantum.dialogs.importbookmark.path"));
        String filename = this.dialog.open();
        if (filename != null) {
            QuantumPlugin.getDefault().getPreferenceStore().setValue("quantum.dialogs.importbookmark.path", filename);
            File importFile = new File(filename);
            FileInputStream source = null;
            try {
                source = new FileInputStream(importFile);
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
                return;
            }
            try {
                Document doc = XMLHelper.createFromInputStream(source);
                Element root = doc.getDocumentElement();
                BookmarkCollection.getInstance().importXML(root);
                this.view.refresh();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

