/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.actions;

import com.quantum.actions.BaseExecuteAction;
import com.quantum.sql.parser.SQLParser;
import com.quantum.util.io.InputStreamHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class ExecuteAgainstAction
extends BaseExecuteAction
implements IObjectActionDelegate {
    private IFile[] files = null;
    private IWorkbenchPart workbenchPart;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.workbenchPart = targetPart;
    }

    protected Shell getShell() {
        return this.workbenchPart.getSite().getShell();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            ArrayList list = new ArrayList();
            Iterator i = structuredSelection.iterator();
            while (i.hasNext()) {
                Object temp = i.next();
                if (temp == null || !(temp instanceof IFile)) continue;
                list.add(temp);
            }
            this.files = list.toArray(new IFile[list.size()]);
        }
    }

    protected List getQueries() throws IOException, CoreException {
        ArrayList list = new ArrayList();
        int i = 0;
        int length = this.files == null ? 0 : this.files.length;
        while (i < length) {
            String fileContents = InputStreamHelper.readIntoString(this.files[i].getContents(), this.files[i].getCharset());
            Vector queryList = SQLParser.parse(fileContents);
            list.addAll(queryList);
            ++i;
        }
        return list;
    }

    protected IStatusLineManager getStatusLineManager() {
        if (this.workbenchPart instanceof IViewPart) {
            return ((IViewPart)this.workbenchPart).getViewSite().getActionBars().getStatusLineManager();
        }
        return null;
    }

    public void run(IAction action) {
        this.run();
    }
}

