/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.actions;

import com.quantum.ImageStore;
import com.quantum.Messages;
import com.quantum.QuantumPlugin;
import com.quantum.log.QuantumLog;
import com.quantum.model.Bookmark;
import com.quantum.model.BookmarkCollection;
import com.quantum.sql.MultiSQLServer;
import com.quantum.sql.SQLResultSetCollection;
import com.quantum.sql.SQLResultSetResults;
import com.quantum.sql.SQLResults;
import com.quantum.sql.SQLUpdateResults;
import com.quantum.ui.dialog.ConnectionUtil;
import com.quantum.ui.dialog.ExceptionDisplayDialog;
import com.quantum.ui.dialog.SQLExceptionDialog;
import com.quantum.ui.dialog.SimpleSelectionDialog;
import com.quantum.view.tableview.TableView;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionListenerAction;

public abstract class BaseExecuteAction
extends SelectionListenerAction {
    private ConnectionUtil connectionUtil = new ConnectionUtil();
    private static IPreferenceStore store = QuantumPlugin.getDefault().getPreferenceStore();
    private boolean useJobs = store.getBoolean("com.quantum.global.useJobs");
    String execute1;
    String execute2;
    ExecuteSQL sqlJob;
    static /* synthetic */ Class class$0;

    protected abstract Shell getShell();

    protected Connection getConnection(Bookmark bookmark) {
        return this.connectionUtil.getConnection(bookmark, this.getShell());
    }

    protected BaseExecuteAction(String text) {
        super(text);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.quantum.actions.BaseExecuteAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.execute1 = Messages.getString(clazz, "execute1");
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("com.quantum.actions.BaseExecuteAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.execute2 = Messages.getString(clazz2, "execute2");
        this.sqlJob = null;
        if (this.useJobs) {
            this.sqlJob = new ExecuteSQL();
        }
    }

    protected BaseExecuteAction() {
        this(null);
    }

    public void run() {
        Bookmark bookmark = this.getBookmark();
        if (bookmark != null) {
            this.execute(bookmark);
        }
    }

    public void execute(Bookmark bookmark) {
        if (bookmark != null) {
            try {
                this.useJobs = store.getBoolean("com.quantum.global.useJobs");
                this.getStatusLineManager().setErrorMessage(null);
                Connection connection = this.getConnection(bookmark);
                if (connection != null) {
                    this.execute(bookmark, connection);
                }
            }
            catch (IOException e) {
                ExceptionDisplayDialog.openError(this.getShell(), null, null, e);
            }
            catch (SQLException e) {
                SQLExceptionDialog.openException(this.getShell(), bookmark, e);
            }
            catch (CoreException e) {
                ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)e.getStatus());
            }
        }
    }

    protected void execute(Bookmark bookmark, Connection connection) throws IOException, CoreException, SQLException {
        this.getStatusLineManager().setMessage(this.execute1);
        MultiSQLServer server = MultiSQLServer.getInstance();
        Metrics metrics = new Metrics();
        List queries = this.getQueries();
        if (this.useJobs) {
            this.sqlJob.schedule(bookmark, connection, server, queries);
        } else {
            IProgressMonitor progressBar = this.getStatusLineManager().getProgressMonitor();
            progressBar.beginTask("queries", queries.size());
            int i = 0;
            while (i < queries.size()) {
                this.getStatusLineManager().setMessage(i % 2 == 0 ? this.execute1 : this.execute2);
                String query = (String)queries.get(i);
                System.out.println(">" + query + "<");
                if (query != null && query.trim().length() > 0) {
                    SQLResults results = this.getSQLResults(bookmark, connection, server, query);
                    metrics.measure(results);
                    if (results != null) {
                        bookmark.addQuery(query);
                        if (results.isResultSet()) {
                            SQLResultSetCollection.getInstance().addSQLResultSet((SQLResultSetResults)results);
                            this.activateTableView();
                        }
                    }
                }
                progressBar.worked(i);
                ++i;
            }
            progressBar.done();
            this.displayFinalStatusMessage(metrics);
        }
    }

    private SQLResults getSQLResults(Bookmark bookmark, Connection connection, MultiSQLServer server, String query) {
        SQLResults results = null;
        try {
            results = server.execute(bookmark, connection, query);
        }
        catch (SQLException e) {
            QuantumLog.getInstance().error("Error Executing: " + query + ":" + e.toString(), e);
            SQLExceptionDialog.openException(this.getShell(), bookmark, e);
        }
        return results;
    }

    private void activateTableView() {
        TableView.getInstance();
    }

    protected abstract List getQueries() throws IOException, CoreException;

    protected abstract IStatusLineManager getStatusLineManager();

    private void displayFinalStatusMessage(Metrics metrics) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.quantum.actions.BaseExecuteAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String message = Messages.getString(clazz, "done", metrics.getResults());
        if (metrics.hasErrors()) {
            this.getStatusLineManager().setErrorMessage(ImageStore.getImage("stop"), message);
        } else {
            this.getStatusLineManager().setMessage(message);
        }
    }

    protected Bookmark getBookmark() {
        SimpleSelectionDialog dialog;
        Bookmark bookmark = null;
        Shell shell = this.getShell();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.quantum.actions.BaseExecuteAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((dialog = new SimpleSelectionDialog(shell, Messages.getString(clazz, "selectBookmark"), BookmarkCollection.getInstance().getBookmarks(), ImageStore.getImage("bookmarks"))).open() == 0) {
            IStructuredSelection selection = dialog.getSelection();
            bookmark = (Bookmark)selection.getFirstElement();
        }
        return bookmark;
    }

    class Metrics {
        int resultCount = 0;
        int resultUpdateCount = 0;
        int errorCount = 0;
        int resultsDisplayed = 0;
        double queryDuration = 0.0;

        Metrics() {
        }

        public void measure(SQLResults results) {
            if (results == null) {
                ++this.errorCount;
            } else {
                this.queryDuration += (double)results.getTime() / 1000.0;
                ++this.resultCount;
                if (results.isResultSet()) {
                    ++this.resultsDisplayed;
                } else {
                    this.resultUpdateCount += ((SQLUpdateResults)results).getUpdateCount();
                }
            }
        }

        public boolean hasErrors() {
            return this.errorCount > 0;
        }

        Object[] getResults() {
            return new Object[]{new Integer(this.resultCount), new Integer(this.resultUpdateCount), new Integer(this.resultsDisplayed), new Integer(this.errorCount), new Double(this.queryDuration)};
        }
    }

    class ExecuteSQL
    extends Job {
        Bookmark bookmark;
        Connection connection;
        MultiSQLServer server;
        List queries;
        List resultsList = new ArrayList(0);
        Metrics metrics;
        SQLException e;
        static /* synthetic */ Class class$0;

        public ExecuteSQL() {
            super("Executing sql...");
            this.metrics = new Metrics();
            this.e = null;
            this.setUser(true);
        }

        public void schedule(Bookmark bookmark, Connection connection, MultiSQLServer server, List querys) {
            this.bookmark = bookmark;
            this.connection = connection;
            this.server = server;
            this.queries = querys;
            this.schedule();
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.resultsList.clear();
            this.e = null;
            this.metrics = new Metrics();
            monitor.beginTask("queries", this.queries.size());
            IStatus stats = Status.OK_STATUS;
            SQLResults results = null;
            try {
                int i = 0;
                while (i < this.queries.size()) {
                    String query = (String)this.queries.get(i);
                    monitor.setTaskName(query);
                    if (query != null && query.trim().length() > 0) {
                        results = this.server.execute(this.bookmark, this.connection, query);
                        this.metrics.measure(results);
                        if (results != null && results.isResultSet()) {
                            this.resultsList.add(results);
                        }
                    }
                    monitor.worked(i);
                    ++i;
                }
            }
            catch (SQLException eSQL) {
                this.e = eSQL;
                stats = Status.CANCEL_STATUS;
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(this){
                    final /* synthetic */ ExecuteSQL this$1;
                    {
                        this.this$1 = executeSQL;
                    }

                    public void run() {
                        QuantumLog.getInstance().error("Error Executing: " + this.this$1.e.getSQLState() + ":" + this.this$1.e.toString(), this.this$1.e);
                        SQLExceptionDialog.openException(ExecuteSQL.access$1(this.this$1).getShell(), this.this$1.bookmark, this.this$1.e);
                    }
                });
            }
            monitor.done();
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(this){
                final /* synthetic */ ExecuteSQL this$1;
                {
                    this.this$1 = executeSQL;
                }

                public void run() {
                    Iterator<E> i = this.this$1.resultsList.iterator();
                    System.out.println("ExecuteSQL.run()::asyncExec ");
                    while (i.hasNext()) {
                        SQLResults results = (SQLResults)i.next();
                        SQLResultSetCollection.getInstance().addSQLResultSet((SQLResultSetResults)results);
                        this.this$1.bookmark.addQuery(results.getQuery());
                    }
                    System.out.println("ExecuteSQL.run()::asyncExec table to front");
                    TableView.getInstance();
                    ExecuteSQL.access$0(this.this$1, this.this$1.metrics);
                }
            });
            return stats;
        }

        private void displayFinalStatusMessage(Metrics metrics) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.quantum.actions.BaseExecuteAction");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String message = Messages.getString(clazz, "done", metrics.getResults());
            if (metrics.hasErrors()) {
                BaseExecuteAction.this.getStatusLineManager().setErrorMessage(ImageStore.getImage("stop"), message);
            } else {
                BaseExecuteAction.this.getStatusLineManager().setMessage(message);
            }
        }

        static /* synthetic */ void access$0(ExecuteSQL executeSQL, Metrics metrics) {
            executeSQL.displayFinalStatusMessage(metrics);
        }

        static /* synthetic */ BaseExecuteAction access$1(ExecuteSQL executeSQL) {
            return executeSQL.BaseExecuteAction.this;
        }
    }
}

