/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.flatfiles.wizard;

import com.quantum.ImageStore;
import com.quantum.QuantumPlugin;
import com.quantum.flatfiles.MessageUtil;
import com.quantum.model.Bookmark;
import com.quantum.model.BookmarkCollection;
import com.quantum.ui.dialog.ConnectionUtil;
import com.quantum.util.DisplayableComparator;
import com.quantum.util.connection.Connectable;
import com.quantum.view.widget.SimpleLabelProvider;
import com.quantum.wizards.PropertyChangeWizardPage;
import java.util.Arrays;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class SelectBookmarkWizardPage
extends PropertyChangeWizardPage {
    private Bookmark bookmark;
    private ConnectionUtil connectionUtil = new ConnectionUtil();
    private Button connectButton;

    public SelectBookmarkWizardPage(String pageName) {
        super(pageName);
        this.setTitle(MessageUtil.getString(((Object)((Object)this)).getClass(), "title"));
        this.setDescription(MessageUtil.getString(((Object)((Object)this)).getClass(), "description"));
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText(MessageUtil.getString(((Object)((Object)this)).getClass(), "bookmark"));
        TableViewer viewer = new TableViewer(composite);
        viewer.setLabelProvider((IBaseLabelProvider)new SimpleLabelProvider(ImageStore.getImage((String)"bookmarks", (AbstractUIPlugin)QuantumPlugin.getDefault())));
        viewer.setContentProvider((IContentProvider)new ContentProviderImpl());
        viewer.setInput((Object)BookmarkCollection.getInstance());
        viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.connectButton = new Button(composite, 8);
        this.connectButton.setText(MessageUtil.getString(((Object)((Object)this)).getClass(), "connect"));
        this.connectButton.setEnabled(false);
        this.connectButton.setLayoutData((Object)new GridData(128));
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                SelectBookmarkWizardPage.this.setBookmark(selection.isEmpty() ? null : (Bookmark)selection.getFirstElement());
                SelectBookmarkWizardPage.this.updateState();
            }
        });
        this.connectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SelectBookmarkWizardPage.this.connectToBookmarkIfNecessary();
                SelectBookmarkWizardPage.this.updateState();
            }
        });
        this.setControl((Control)composite);
        this.updateState();
    }

    protected void updateState() {
        boolean pageComplete;
        this.connectButton.setEnabled(this.bookmark != null && !this.bookmark.isConnected());
        boolean bl = pageComplete = this.bookmark != null && this.bookmark.isConnected();
        if (this.bookmark != null) {
            this.setErrorMessage(this.bookmark.isConnected() ? null : MessageUtil.getString(((Object)((Object)this)).getClass(), "notConnected"));
        }
        this.setPageComplete(pageComplete);
    }

    protected boolean connectToBookmarkIfNecessary() {
        if (!this.bookmark.isConnected()) {
            this.connectionUtil.getConnection((Connectable)this.bookmark, this.getShell());
        }
        return this.bookmark.isConnected();
    }

    public Bookmark getBookmark() {
        return this.bookmark;
    }

    public void setBookmark(Bookmark bookmark) {
        Bookmark original = this.bookmark;
        this.bookmark = bookmark;
        this.firePropertyChange("bookmark", original, bookmark);
    }

    public class ContentProviderImpl
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof BookmarkCollection) {
                Object[] bookmarks = ((BookmarkCollection)inputElement).getBookmarks();
                Arrays.sort(bookmarks, new DisplayableComparator());
                return bookmarks;
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

