/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.flatfiles.wizard;

import com.quantum.ImageStore;
import com.quantum.QuantumPlugin;
import com.quantum.flatfiles.MessageUtil;
import com.quantum.model.Bookmark;
import com.quantum.model.Schema;
import com.quantum.ui.dialog.ExceptionDisplayDialog;
import com.quantum.ui.dialog.SQLExceptionDialog;
import com.quantum.util.Displayable;
import com.quantum.util.DisplayableComparator;
import com.quantum.util.connection.NotConnectedException;
import com.quantum.view.widget.SimpleLabelProvider;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.sql.SQLException;
import java.util.Arrays;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ExportDetailsPage
extends WizardPage {
    private Bookmark bookmark;
    private Schema schema;
    private String idMethod;
    private String fileName;
    private String databaseName;
    private TableViewer tableViewer;
    private ContentProviderImpl contentProvider;
    static /* synthetic */ Class class$0;

    protected void refreshTable() {
        if (this.bookmark.isConnected()) {
            this.tableViewer.refresh();
        }
    }

    public void dispose() {
        if (this.bookmark != null) {
            this.bookmark.removePropertyChangeListener((PropertyChangeListener)this.contentProvider);
        }
        super.dispose();
    }

    protected ExportDetailsPage(String pageName) {
        super(pageName);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.quantum.flatfiles.wizard.ExportDetailsPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setTitle(MessageUtil.getString(clazz, "title"));
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("com.quantum.flatfiles.wizard.ExportDetailsPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setDescription(MessageUtil.getString(clazz2, "description"));
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.quantum.flatfiles.wizard.ExportDetailsPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        label.setText(MessageUtil.getString(clazz, "schema"));
        label.setLayoutData((Object)new GridData(2));
        this.tableViewer = new TableViewer(composite);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new SimpleLabelProvider(ImageStore.getImage((String)"schema", (AbstractUIPlugin)QuantumPlugin.getDefault())));
        this.contentProvider = new ContentProviderImpl();
        this.tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        if (this.bookmark != null) {
            this.tableViewer.setInput((Object)this.bookmark);
        }
        this.tableViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ExportDetailsPage.this.setSchema(selection.isEmpty() ? null : (Schema)selection.getFirstElement());
                ExportDetailsPage.this.updateState();
            }
        });
        Group group = new Group(composite, 0);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("com.quantum.flatfiles.wizard.ExportDetailsPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        group.setText(MessageUtil.getString(clazz2, "torque"));
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(768));
        label = new Label((Composite)group, 0);
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("com.quantum.flatfiles.wizard.ExportDetailsPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        label.setText(MessageUtil.getString(clazz3, "databaseName"));
        Text databaseName = new Text((Composite)group, 2048);
        databaseName.setLayoutData((Object)new GridData(768));
        databaseName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ExportDetailsPage.this.setDatabaseName(((Text)event.getSource()).getText());
                ExportDetailsPage.this.updateState();
            }
        });
        label = new Label((Composite)group, 0);
        Class<?> clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName("com.quantum.flatfiles.wizard.ExportDetailsPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        label.setText(MessageUtil.getString(clazz4, "idMethod"));
        Combo idMethodCombo = new Combo((Composite)group, 8);
        idMethodCombo.setLayoutData((Object)new GridData(768));
        idMethodCombo.setItems(new String[]{"none", "native", "idbroker"});
        idMethodCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExportDetailsPage.this.setIdMethod(((Combo)event.getSource()).getText());
                ExportDetailsPage.this.updateState();
            }
        });
        Label blankArea = new Label(composite, 0);
        blankArea.setText("");
        this.createDestinationArea(composite);
        this.setControl((Control)composite);
        this.updateState();
    }

    private void createDestinationArea(Composite composite) {
        Composite fileArea = new Composite(composite, 0);
        fileArea.setLayout((Layout)new GridLayout(3, false));
        fileArea.setLayoutData((Object)new GridData(770));
        Label label = new Label(fileArea, 0);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.quantum.flatfiles.wizard.ExportDetailsPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        label.setText(MessageUtil.getString(clazz, "fileName"));
        final Text fileNameText = new Text(fileArea, 2048);
        fileNameText.setLayoutData((Object)new GridData(768));
        fileNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String text = ((Text)event.getSource()).getText();
                ExportDetailsPage.this.setFileName(text);
                ExportDetailsPage.this.updateState();
            }
        });
        Button button = new Button(fileArea, 0);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("com.quantum.flatfiles.wizard.ExportDetailsPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        button.setText(MessageUtil.getString(clazz2, "browse"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dialog = new FileDialog(ExportDetailsPage.this.getShell(), 8192);
                dialog.setFilterExtensions(new String[]{"xml"});
                String[] stringArray = new String[1];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.quantum.flatfiles.wizard.ExportDetailsPage");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                stringArray[0] = MessageUtil.getString(clazz, "xmlFiles");
                dialog.setFilterNames(stringArray);
                String filename = dialog.open();
                if (filename != null) {
                    fileNameText.setText(filename);
                    ExportDetailsPage.this.setFileName(filename);
                    ExportDetailsPage.this.updateState();
                }
            }
        });
    }

    protected void updateState() {
        boolean pageComplete = this.bookmark != null && this.bookmark.isConnected();
        pageComplete &= this.databaseName != null && this.databaseName.trim().length() > 0;
        pageComplete &= this.fileName != null && !new File(this.fileName).isDirectory();
        pageComplete &= this.idMethod != null;
        this.setPageComplete(pageComplete &= this.schema != null);
    }

    public Bookmark getBookmark() {
        return this.bookmark;
    }

    public String getFileName() {
        return this.fileName;
    }

    protected void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setBookmark(Bookmark bookmark) {
        this.bookmark = bookmark;
        this.tableViewer.setInput((Object)this.bookmark);
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getIdMethod() {
        return this.idMethod;
    }

    public void setIdMethod(String idMethod) {
        this.idMethod = idMethod;
    }

    public class ContentProviderImpl
    implements IStructuredContentProvider,
    PropertyChangeListener {
        public Object[] getElements(Object inputElement) {
            if (inputElement == null) {
                return null;
            }
            if (inputElement instanceof Bookmark && ((Bookmark)inputElement).isConnected()) {
                Object[] schemas = new Schema[]{};
                try {
                    schemas = ((Bookmark)inputElement).getSchemas();
                    Arrays.sort(schemas, new DisplayableComparator());
                }
                catch (NotConnectedException e) {
                    ExceptionDisplayDialog.openError((Shell)ExportDetailsPage.this.getShell(), null, null, (Throwable)e);
                }
                catch (SQLException e) {
                    SQLExceptionDialog.openException((Shell)ExportDetailsPage.this.getShell(), (Displayable)((Bookmark)inputElement), (SQLException)e);
                }
                return schemas;
            }
            if (inputElement instanceof Bookmark) {
                return new Schema[0];
            }
            return null;
        }

        public void dispose() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if ("connected".equals(event.getPropertyName())) {
                ExportDetailsPage.this.refreshTable();
            }
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput != null && newInput instanceof Bookmark) {
                if (oldInput != null && oldInput instanceof Bookmark) {
                    ((Bookmark)oldInput).removePropertyChangeListener((PropertyChangeListener)this);
                }
                ((Bookmark)newInput).addPropertyChangeListener((PropertyChangeListener)this);
            }
        }
    }
}

