/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.flatfiles.wizard;

import com.quantum.ImageStore;
import com.quantum.flatfiles.MessageUtil;
import com.quantum.flatfiles.wizard.SimpleCheckStateListener;
import com.quantum.model.Bookmark;
import com.quantum.model.DatabaseObject;
import com.quantum.model.Schema;
import com.quantum.model.Table;
import com.quantum.ui.dialog.ExceptionDisplayDialog;
import com.quantum.ui.dialog.Executable;
import com.quantum.ui.dialog.SQLExceptionDialog;
import com.quantum.ui.dialog.SQLInvocationUtil;
import com.quantum.util.Displayable;
import com.quantum.util.connection.Connectable;
import com.quantum.util.connection.ConnectionException;
import com.quantum.view.widget.SimpleLabelProvider;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ExportDatabaseObjectsWizardPage
extends WizardPage {
    private Bookmark bookmark;
    private CheckboxTreeViewer treeViewer;
    private ContentProvider contentProvider = new ContentProvider();
    private CheckStateListener checkStateListener;
    private PropertyChangeListener listener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("connected".equals(event.getPropertyName())) {
                ExportDatabaseObjectsWizardPage.this.setInput();
            }
        }
    };

    public ExportDatabaseObjectsWizardPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite pageContainer) {
        Composite composite = new Composite(pageContainer, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.treeViewer = new CheckboxTreeViewer(composite, 2848);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.setInput();
        this.checkStateListener = new CheckStateListener(this.treeViewer);
        this.treeViewer.addCheckStateListener((ICheckStateListener)this.checkStateListener);
        GridData data = new GridData(1808);
        data.heightHint = 200;
        data.widthHint = 400;
        this.treeViewer.getControl().setLayoutData((Object)data);
        Composite buttons = new Composite(composite, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData());
        Button selectAll = new Button(buttons, 0);
        selectAll.setText(MessageUtil.getString(((Object)((Object)this)).getClass(), "selectAll"));
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExportDatabaseObjectsWizardPage.this.selectAll();
            }
        });
        Button deselectAll = new Button(buttons, 0);
        deselectAll.setText(MessageUtil.getString(((Object)((Object)this)).getClass(), "deselectAll"));
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExportDatabaseObjectsWizardPage.this.deselectAll();
            }
        });
        this.setControl((Control)composite);
    }

    protected void refreshTree() {
        if (this.treeViewer != null && this.bookmark != null) {
            this.treeViewer.refresh((Object)this.bookmark);
        }
    }

    protected void deselectAll() {
        this.changeSelection(false);
    }

    private void changeSelection(boolean selected) {
        Object[] objects = (Object[])this.treeViewer.getInput();
        int i = 0;
        int length = objects == null ? 0 : objects.length;
        while (i < length) {
            this.treeViewer.setSubtreeChecked(objects[i], selected);
            ++i;
        }
        this.setPageComplete(this.treeViewer.getCheckedElements().length > 0);
    }

    protected void selectAll() {
        this.changeSelection(true);
    }

    public Bookmark getBookmark() {
        return this.bookmark;
    }

    public void setBookmark(Bookmark bookmark) {
        if (this.bookmark != null) {
            this.bookmark.removePropertyChangeListener(this.listener);
        }
        this.bookmark = bookmark;
        if (this.bookmark != null) {
            this.bookmark.addPropertyChangeListener(this.listener);
        }
        this.setInput();
    }

    public void dispose() {
        super.dispose();
        if (this.bookmark != null) {
            this.bookmark.removePropertyChangeListener(this.listener);
        }
        if (this.treeViewer != null) {
            this.treeViewer.removeCheckStateListener((ICheckStateListener)this.checkStateListener);
        }
    }

    private void setInput() {
        try {
            if (this.bookmark != null && this.bookmark.isConnected()) {
                if (this.bookmark.getDatabase().supportsSchemasInTableDefinitions()) {
                    this.treeViewer.setInput((Object)this.bookmark.getSchemas());
                } else {
                    this.treeViewer.setInput((Object)this.bookmark.getObjectsForSchema(this.bookmark.getDefaultSchema(), "TABLE"));
                }
                this.refreshTree();
                this.selectAll();
            }
        }
        catch (ConnectionException e) {
            if (e.getCause() != null && e.getCause() instanceof SQLException) {
                SQLExceptionDialog.openException((Shell)this.getShell(), (Displayable)this.bookmark, (SQLException)((SQLException)e.getCause()));
            } else {
                ExceptionDisplayDialog.openError((Shell)this.getShell(), null, null, (Throwable)e);
            }
        }
        catch (SQLException e) {
            SQLExceptionDialog.openException((Shell)this.getShell(), (Displayable)this.bookmark, (SQLException)e);
        }
    }

    public Object[] getCheckedElements() {
        return this.treeViewer == null ? null : this.treeViewer.getCheckedElements();
    }

    public class ContentProvider
    implements ITreeContentProvider {
        private DatabaseObject[] objects;

        public Object[] getChildren(Object parentElement) {
            Object[] result = null;
            if (parentElement != null) {
                if (parentElement instanceof DatabaseObject[]) {
                    this.objects = (DatabaseObject[])parentElement;
                    result = this.objects;
                } else if (parentElement instanceof Schema[]) {
                    result = (Object[])parentElement;
                } else if (parentElement instanceof Schema) {
                    Schema schema = (Schema)parentElement;
                    if (this.objects == null) {
                        this.objects = ExportDatabaseObjectsWizardPage.this.getBookmark() == null ? null : (DatabaseObject[])SQLInvocationUtil.execute((Shell)ExportDatabaseObjectsWizardPage.this.getShell(), (Connectable)ExportDatabaseObjectsWizardPage.this.bookmark, (Executable)new Executable(this, schema){
                            final /* synthetic */ ContentProvider this$1;
                            private final /* synthetic */ Schema val$schema;
                            {
                                this.this$1 = contentProvider;
                                this.val$schema = schema;
                            }

                            public Object execute() throws SQLException, ConnectionException {
                                return ContentProvider.access$0(this.this$1).getBookmark().getObjectsForSchema(this.val$schema, "TABLE");
                            }
                        });
                        result = this.objects;
                    } else {
                        result = this.objects;
                    }
                }
            }
            return result == null ? new Object[]{} : result;
        }

        public Object getParent(Object element) {
            if (element instanceof Schema) {
                return null;
            }
            if (element instanceof Table) {
                Table table = (Table)element;
                Bookmark bookmark = table.getBookmark();
                return SQLInvocationUtil.execute((Shell)ExportDatabaseObjectsWizardPage.this.getShell(), (Connectable)bookmark, (Executable)new Executable(this, table){
                    final /* synthetic */ ContentProvider this$1;
                    private final /* synthetic */ Table val$table;
                    {
                        this.this$1 = contentProvider;
                        this.val$table = table;
                    }

                    public Object execute() throws SQLException, ConnectionException {
                        return ContentProvider.access$0(this.this$1).getBookmark().getSchema(this.val$table.getSchema());
                    }
                });
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof Schema;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.objects = null;
        }

        static /* synthetic */ ExportDatabaseObjectsWizardPage access$0(ContentProvider contentProvider) {
            return contentProvider.ExportDatabaseObjectsWizardPage.this;
        }
    }

    class CheckStateListener
    extends SimpleCheckStateListener {
        public CheckStateListener(CheckboxTreeViewer viewer) {
            super(viewer);
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            super.checkStateChanged(event);
            ExportDatabaseObjectsWizardPage.this.setPageComplete(ExportDatabaseObjectsWizardPage.this.treeViewer.getCheckedElements().length > 0);
        }
    }

    public class LabelProvider
    extends SimpleLabelProvider {
        public String getText(Object element) {
            if (element instanceof Table) {
                return ((Table)element).getName();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof Schema) {
                return ImageStore.getImage((String)"schema");
            }
            if (element instanceof Table) {
                return ImageStore.getImage((String)"bigtable");
            }
            return null;
        }
    }
}

