/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.csv.wizard;

import com.quantum.ImageStore;
import com.quantum.csv.wizard.ConverterCSV;
import com.quantum.csv.wizard.ImportCSVDetailsPage;
import com.quantum.flatfiles.MessageUtil;
import com.quantum.flatfiles.QuantumFlatFilesPlugin;
import com.quantum.model.Entity;
import com.quantum.model.Table;
import com.quantum.ui.dialog.ExceptionDisplayDialog;
import com.quantum.ui.dialog.SQLExceptionDialog;
import com.quantum.util.Displayable;
import com.quantum.util.connection.ConnectionException;
import com.quantum.view.bookmark.BookmarkView;
import com.quantum.view.bookmark.EntityNode;
import com.quantum.view.bookmark.GroupNode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.Vector;
import java.util.zip.ZipFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ImportCSVWizard
extends Wizard
implements IExportWizard,
PropertyChangeListener {
    private ImportCSVDetailsPage page1;

    public ImportCSVWizard() {
        this.setWindowTitle(MessageUtil.getString(this.getClass(), "windowTitle"));
        this.setDefaultPageImageDescriptor(ImageStore.getImageDescriptor((String)"export_csv", (AbstractUIPlugin)QuantumFlatFilesPlugin.getDefault()));
    }

    public boolean performFinish() {
        boolean successful = false;
        File file = new File(this.page1.getFileName());
        if (file.exists()) {
            ConverterCSV converter = new ConverterCSV();
            try {
                Vector entities = this.page1.getMatchedEntities();
                if (this.page1.isZip()) {
                    ZipFile inZip = new ZipFile(this.page1.getFileName());
                    int i = 0;
                    while (i < entities.size()) {
                        Entity entity = ((EntityNode)entities.get(i)).getEntity();
                        this.deleteEntityRowsIfNeeded(entity);
                        InputStream iStream = inZip.getInputStream(inZip.getEntry(String.valueOf(entity.getName()) + ".csv"));
                        InputStreamReader iStreamReader = new InputStreamReader(iStream);
                        BufferedReader bufferedReader = new BufferedReader(iStreamReader);
                        converter.convert(bufferedReader, entity, this.page1.getColumnSeparator(), this.page1.hasHeaderRow(), this.page1.ignoreHeaderRow(), this.page1.getEol());
                        bufferedReader.close();
                        iStream.close();
                        ++i;
                    }
                } else if (entities.size() > 0) {
                    File inputFile = new File(this.page1.getFileName());
                    FileReader fileReader = new FileReader(inputFile);
                    BufferedReader bufferedReader = new BufferedReader(fileReader);
                    Entity entity = ((EntityNode)entities.get(0)).getEntity();
                    this.deleteEntityRowsIfNeeded(entity);
                    converter.convert(bufferedReader, entity, this.page1.getColumnSeparator(), this.page1.hasHeaderRow(), this.page1.ignoreHeaderRow(), this.page1.getEol());
                    if (converter.getNumBadInserts() > 0L) {
                        MessageDialog.openInformation((Shell)this.getShell(), (String)"Rows not inserted", (String)("NON inserted rows : " + String.valueOf(converter.getNumBadInserts()) + "\nInserted Rows :" + String.valueOf(converter.getNumGoodInserts())));
                    }
                    bufferedReader.close();
                }
                successful = true;
            }
            catch (IOException e) {
                ExceptionDisplayDialog.openError((Shell)this.getShell(), null, null, (Throwable)e);
            }
        }
        return successful;
    }

    private void deleteEntityRowsIfNeeded(Entity entity) {
        if (entity instanceof Table && this.page1.deletePreviousContent()) {
            try {
                ((Table)entity).deleteAllRows();
            }
            catch (SQLException e) {
                SQLExceptionDialog.openException((Shell)this.getShell(), (Displayable)entity, (SQLException)e);
            }
            catch (ConnectionException e) {
                ExceptionDisplayDialog.openError((Shell)this.getShell(), null, null, (Throwable)e);
            }
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object[] nodes = BookmarkView.getInstance().getSelection().toArray();
        if (nodes.length == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Invalid selection", (String)"Please select a Tables FOLDER (the one grouping all tables) or a list of tables");
            return;
        }
        boolean correctSelection = true;
        int i = 0;
        while (i < nodes.length) {
            Object node = nodes[i];
            if (node instanceof EntityNode) {
                if (!((EntityNode)node).isTable() && !((EntityNode)node).isView()) {
                    correctSelection = false;
                    break;
                }
            } else if (node instanceof GroupNode) {
                if (!((GroupNode)node).getType().equals("TABLE")) {
                    correctSelection = false;
                    break;
                }
            } else {
                correctSelection = false;
                break;
            }
            if (!correctSelection) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)"Invalid selection", (String)"Please select ONLY a Tables folder OR a list of tables");
                return;
            }
            this.page1 = new ImportCSVDetailsPage("page1");
            ++i;
        }
    }

    public void dispose() {
        super.dispose();
    }

    public void addPages() {
        if (this.page1 != null) {
            this.addPage((IWizardPage)this.page1);
        }
    }

    public void propertyChange(PropertyChangeEvent arg0) {
    }
}

