/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.csv.wizard;

import com.quantum.ImageStore;
import com.quantum.QuantumPlugin;
import com.quantum.csv.wizard.ConverterCSV;
import com.quantum.csv.wizard.ExportCSVDetailsPage;
import com.quantum.flatfiles.MessageUtil;
import com.quantum.flatfiles.QuantumFlatFilesPlugin;
import com.quantum.model.Entity;
import com.quantum.ui.dialog.ExceptionDisplayDialog;
import com.quantum.util.connection.NotConnectedException;
import com.quantum.view.bookmark.BookmarkView;
import com.quantum.view.bookmark.EntityNode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.IProgressService;

public class ExportCSVWizard
extends Wizard
implements IExportWizard,
PropertyChangeListener {
    private ExportCSVDetailsPage page1;

    public ExportCSVWizard() {
        this.setWindowTitle(MessageUtil.getString(this.getClass(), "windowTitle"));
        this.setDefaultPageImageDescriptor(ImageStore.getImageDescriptor((String)"export_csv", (AbstractUIPlugin)QuantumFlatFilesPlugin.getDefault()));
    }

    public boolean performFinish() {
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        File file = new File(this.page1.getFileName());
        IPreferenceStore store = QuantumPlugin.getDefault().getPreferenceStore();
        boolean confirmOverwrite = store.getBoolean("com.quantum.export.confirmOverwrite");
        if (!new File(file.getParent()).isDirectory()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Cannot export", (String)("Your selected export file directory doesn't seem to exist:\n" + file.getParent()));
            return false;
        }
        if (!file.exists() || !confirmOverwrite || file.exists() && MessageDialog.openConfirm((Shell)this.getShell(), (String)MessageUtil.getString(this.getClass(), "overwriteTitle"), (String)MessageUtil.getString(this.getClass(), "confirmOverwrite", new Object[]{file.getAbsoluteFile()}))) {
            try {
                progressService.busyCursorWhile(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        ExportCSVWizard.this.doExport();
                    }
                });
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                return false;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean doExport() {
        boolean successful = false;
        try {
            Entity[] entities = this.page1.getEntities();
            if (entities.length > 1) {
                ZipOutputStream out = new ZipOutputStream(new FileOutputStream(this.page1.getFileName()));
                ConverterCSV converter = new ConverterCSV();
                out.setLevel(-1);
                int i = 0;
                while (i < entities.length) {
                    Entity entity = entities[i];
                    out.putNextEntry(new ZipEntry(String.valueOf(entity.getName()) + ".csv"));
                    converter.convert(out, entity, this.page1.isWriteHeaderRow(), this.page1.getColumnSeparator());
                    out.closeEntry();
                    ++i;
                }
                out.close();
            } else {
                File outputFile = new File(this.page1.getFileName());
                FileWriter writer = new FileWriter(outputFile);
                ConverterCSV converter = new ConverterCSV();
                converter.convert(writer, entities[0], this.page1.isWriteHeaderRow(), this.page1.getColumnSeparator());
                writer.close();
            }
            successful = true;
        }
        catch (IOException e) {
            ExceptionDisplayDialog.openError((Shell)this.getShell(), null, null, (Throwable)e);
        }
        catch (NotConnectedException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return successful;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object[] nodes = BookmarkView.getInstance().getSelection().toArray();
        if (nodes.length == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Invalid selection", (String)"Please select some tables and views in the Quantum Bookmark View");
            return;
        }
        int i = 0;
        while (i < nodes.length) {
            Object node = nodes[i];
            if (!(node instanceof EntityNode) || !((EntityNode)node).isTable() && !((EntityNode)node).isView()) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)"Invalid selection", (String)"Please select ONLY tables and/or views in the Quantum Bookmark View");
                return;
            }
            ++i;
        }
        this.page1 = new ExportCSVDetailsPage("page1");
    }

    public void dispose() {
        super.dispose();
    }

    public void addPages() {
        if (this.page1 != null) {
            this.addPage((IWizardPage)this.page1);
        }
    }

    public void propertyChange(PropertyChangeEvent arg0) {
    }
}

