/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.dbunit.wizard;

import com.quantum.ImageStore;
import com.quantum.dbunit.MessageUtil;
import com.quantum.dbunit.QuantumDbUnitPlugin;
import com.quantum.dbunit.wizard.ConverterDBUnit;
import com.quantum.dbunit.wizard.ImportDbUnitDetailsPage;
import com.quantum.ui.dialog.ExceptionDisplayDialog;
import com.quantum.view.bookmark.BookmarkView;
import com.quantum.view.bookmark.GroupNode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ImportDbUnitWizard
extends Wizard
implements IExportWizard,
PropertyChangeListener {
    private ImportDbUnitDetailsPage page1;

    public ImportDbUnitWizard() {
        this.setWindowTitle(MessageUtil.getString(this.getClass(), "windowTitle"));
        this.setDefaultPageImageDescriptor(ImageStore.getImageDescriptor((String)"export_dbunit", (AbstractUIPlugin)QuantumDbUnitPlugin.getDefault()));
    }

    public boolean performFinish() {
        boolean successful = false;
        File file = new File(this.page1.getFileName());
        if (file.exists()) {
            ConverterDBUnit converter = new ConverterDBUnit();
            try {
                converter.convert(this.page1.getFileName(), this.page1.getBookmark(), this.page1.getSchema(), this.page1.isDeletePreviousContent(), this.page1.isNamesAreQualified());
            }
            catch (Exception e) {
                e.printStackTrace();
                ExceptionDisplayDialog.openError((Shell)this.getShell(), (String)"Error Importing", (String)"Import caused an error. ", (Throwable)e);
            }
            successful = true;
        }
        return successful;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object[] nodes = BookmarkView.getInstance().getSelection().toArray();
        if (nodes.length == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Invalid selection", (String)"Please select a Tables FOLDER (the one grouping all tables) in the Quantum Bookmark View");
            return;
        }
        if (nodes.length > 1) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Invalid selection", (String)"Please select only one Tables Folder in the Quantum Bookmark View");
            return;
        }
        Object node = nodes[0];
        if (!(node instanceof GroupNode) || !((GroupNode)node).getType().equals("TABLE")) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Invalid selection", (String)"Please select a Tables FOLDER (the one grouping all tables) in the Quantum Bookmark View");
            return;
        }
        this.page1 = new ImportDbUnitDetailsPage("page1");
    }

    public void dispose() {
        super.dispose();
    }

    public void addPages() {
        if (this.page1 != null) {
            this.addPage((IWizardPage)this.page1);
        }
    }

    public void propertyChange(PropertyChangeEvent arg0) {
    }
}

