/*
 * Decompiled with CFR 0.152.
 */
package com.atlassw.tools.eclipse.checkstyle.util;

import com.atlassw.tools.eclipse.checkstyle.util.CheckstyleLog;
import com.atlassw.tools.eclipse.checkstyle.util.CheckstylePluginException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.EmptyStackException;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public final class XMLUtil {
    private static Stack sDocBuilderCache = new Stack();
    private static DocumentBuilderFactory sDocBuilderFactory = DocumentBuilderFactory.newInstance();
    private static final int MAX_DOC_BUILDER_CACHE = 10;

    private XMLUtil() {
    }

    public static Node getChildNode(Node node, String string) {
        Node node2 = null;
        if (node != null) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node3 = nodeList.item(i);
                String string2 = node3.getNodeName();
                if (!string2.equals(string)) continue;
                node2 = node3;
                break;
            }
        }
        return node2;
    }

    public static String getNodeTextValue(Node node) {
        Node node2;
        NodeList nodeList;
        String string = null;
        if (node != null && (nodeList = node.getChildNodes()).getLength() > 0 && ((node2 = nodeList.item(0)).getNodeType() == 3 || node2.getNodeType() == 4)) {
            string = node2.getNodeValue();
        }
        return string;
    }

    public static String getNodeAttributeValue(Node node, String string) {
        String string2 = null;
        if (node == null) {
            return string2;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem(string);
        string2 = node2 instanceof Attr ? ((Attr)node2).getValue() : XMLUtil.getNodeTextValue(node2);
        return string2;
    }

    public static Element addElementAndValue(Document document, Element element, String string, String string2) {
        Element element2 = document.createElement(string);
        element.appendChild(element2);
        Text text = document.createTextNode(string2);
        element2.appendChild(text);
        return element2;
    }

    public static Element addElement(Document document, Element element, String string) {
        Element element2 = document.createElement(string);
        element.appendChild(element2);
        return element2;
    }

    public static Document newDocument() throws CheckstylePluginException {
        Document document = null;
        try {
            DocumentBuilder documentBuilder = XMLUtil.getDocumentBuilder();
            document = documentBuilder.newDocument();
            XMLUtil.releaseDocumentBuilder(documentBuilder);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new CheckstylePluginException("ParserConfigurationException" + parserConfigurationException.getMessage());
        }
        catch (DOMException dOMException) {
            throw new CheckstylePluginException("Caught DOMException " + dOMException.getMessage());
        }
        return document;
    }

    public static Document newDocument(String string) {
        Document document = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            DocumentBuilder documentBuilder = XMLUtil.getDocumentBuilder();
            document = documentBuilder.parse(byteArrayInputStream);
            XMLUtil.releaseDocumentBuilder(documentBuilder);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            document = null;
            CheckstyleLog.warning("Exception while parsing XML", parserConfigurationException);
        }
        catch (DOMException dOMException) {
            document = null;
            CheckstyleLog.warning("Exception while parsing XML", dOMException);
        }
        catch (Exception exception) {
            document = null;
            CheckstyleLog.warning("Exception while parsing XML", exception);
        }
        return document;
    }

    public static Document newDocument(InputStream inputStream) {
        Document document = null;
        try {
            DocumentBuilder documentBuilder = XMLUtil.getDocumentBuilder();
            document = documentBuilder.parse(inputStream);
            XMLUtil.releaseDocumentBuilder(documentBuilder);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            document = null;
            CheckstyleLog.warning("Exception while parsing XML", parserConfigurationException);
        }
        catch (IOException iOException) {
            document = null;
            CheckstyleLog.warning("Exception while reading XML", iOException);
        }
        catch (SAXException sAXException) {
            document = null;
            CheckstyleLog.warning("Exception while parsing XML file", sAXException);
        }
        return document;
    }

    public static String serializeDocument(Document document, boolean bl) throws CheckstylePluginException {
        String string;
        try {
            Document document2 = document;
            StringWriter stringWriter = new StringWriter();
            OutputFormat outputFormat = new OutputFormat(document2);
            outputFormat.setIndenting(bl);
            XMLSerializer xMLSerializer = new XMLSerializer((Writer)stringWriter, outputFormat);
            xMLSerializer.serialize(document2);
            string = stringWriter.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string2 = "Exception occurred while serializing document: " + exception.getMessage();
            throw new CheckstylePluginException(string2);
        }
        return string;
    }

    public static String serializeDocument(Document document) throws CheckstylePluginException {
        return XMLUtil.serializeDocument(document, false);
    }

    private static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = (DocumentBuilder)sDocBuilderCache.pop();
        }
        catch (EmptyStackException emptyStackException) {
            documentBuilder = XMLUtil.createDocumentBuilder();
        }
        return documentBuilder;
    }

    private static void releaseDocumentBuilder(DocumentBuilder documentBuilder) {
        if (sDocBuilderCache.size() < 10) {
            sDocBuilderCache.push(documentBuilder);
        }
    }

    private static synchronized DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        return sDocBuilderFactory.newDocumentBuilder();
    }
}

