/*
 * Decompiled with CFR 0.152.
 */
package com.atlassw.tools.eclipse.checkstyle.util;

import com.atlassw.tools.eclipse.checkstyle.CheckstylePlugin;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class CheckstyleLog {
    private static ILog sLog;
    private static final String NEWLINE;
    private static final String ADDED_MSG = "See your <workspace>/.metadata/.log file for additional details.";

    private CheckstyleLog() {
    }

    public static void error(String string) {
        CheckstyleLog.error(string, null);
    }

    public static void error(String string, Throwable throwable) {
        Status status = new Status(4, "com.atlassw.tools.eclipse.checkstyle", 0, "Checkstyle: " + string, throwable);
        sLog.log((IStatus)status);
    }

    public static void warning(String string) {
        CheckstyleLog.warning(string, null);
    }

    public static void warning(String string, Throwable throwable) {
        Status status = new Status(2, "com.atlassw.tools.eclipse.checkstyle", 0, "Checkstyle: " + string, throwable);
        sLog.log((IStatus)status);
    }

    public static void info(String string) {
        Status status = new Status(1, "com.atlassw.tools.eclipse.checkstyle", 0, "Checkstyle: " + string, null);
        sLog.log((IStatus)status);
    }

    public static void internalErrorDialog(Shell shell) {
        CheckstyleLog.errorDialog(shell, "A Checkstyle internal error occured.");
    }

    public static void internalErrorDialog() {
        CheckstyleLog.errorDialog("A Checkstyle internal error occured.");
    }

    public static void errorDialog(String string) {
        CheckstyleLog.errorDialog(CheckstyleLog.getShell(), string);
    }

    public static void errorDialog(Shell shell, String string) {
        if (shell != null) {
            String string2 = string + NEWLINE + ADDED_MSG;
            MessageDialog.openError((Shell)shell, (String)"Checkstyle Error", (String)string2);
        }
    }

    public static boolean questionDialog(Shell shell, String string) {
        if (shell != null) {
            String string2 = string;
            return MessageDialog.openQuestion((Shell)shell, (String)"Checkstyle Question", (String)string2);
        }
        return false;
    }

    private static Shell getShell() {
        Shell shell = null;
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            shell = iWorkbenchWindow.getShell();
        }
        return shell;
    }

    static {
        NEWLINE = System.getProperty("line.separator");
        sLog = CheckstylePlugin.getDefault().getLog();
    }
}

