/*
 * Decompiled with CFR 0.152.
 */
package com.atlassw.tools.eclipse.checkstyle.properties;

import com.atlassw.tools.eclipse.checkstyle.config.CheckConfiguration;
import com.atlassw.tools.eclipse.checkstyle.config.CheckConfigurationFactory;
import com.atlassw.tools.eclipse.checkstyle.config.FileMatchPattern;
import com.atlassw.tools.eclipse.checkstyle.config.FileSet;
import com.atlassw.tools.eclipse.checkstyle.properties.FileMatchPatternEditDialog;
import com.atlassw.tools.eclipse.checkstyle.properties.FileMatchPatternLabelProvider;
import com.atlassw.tools.eclipse.checkstyle.properties.FileMatchPatternProvider;
import com.atlassw.tools.eclipse.checkstyle.properties.FileMatchPatternViewerSorter;
import com.atlassw.tools.eclipse.checkstyle.properties.TestResultsDialog;
import com.atlassw.tools.eclipse.checkstyle.util.CheckstyleLog;
import com.atlassw.tools.eclipse.checkstyle.util.CheckstylePluginException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class FileSetEditDialog
extends Dialog {
    private static final int MAX_LENGTH = 40;
    private static final String JAVA_SUFFIX = ".java";
    private static final String DEFAULT_PATTERN = ".java$";
    private static final String NOTE_TEXT = "Note: The last matching regular expression determines if a file is included or excluded from the File Set.";
    private IProject mProject;
    private Composite mComposite;
    private CheckboxTableViewer mViewer;
    private Text mFileSetNameText;
    private Button mAddButton;
    private Button mEditButton;
    private Button mRemoveButton;
    private Button mTestButton;
    private Button mUpButton;
    private Button mDownButton;
    private Combo mAuditConfigCombo;
    private FileSet mFileSet;
    private CheckConfiguration[] mAuditConfigs;
    private List mFileMatchPatterns = new LinkedList();
    private boolean mOkWasPressed = false;

    FileSetEditDialog(Shell shell, FileSet fileSet, IProject iProject) throws CheckstylePluginException {
        super(shell);
        this.mProject = iProject;
        try {
            if (fileSet != null) {
                this.mFileSet = (FileSet)fileSet.clone();
                this.mFileMatchPatterns = new LinkedList(this.mFileSet.getFileMatchPatterns());
            } else {
                this.mFileMatchPatterns.add(new FileMatchPattern(DEFAULT_PATTERN));
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            CheckstyleLog.error("Failed to clone FileSet", cloneNotSupportedException);
            throw new CheckstylePluginException("Failed to clone FileSet");
        }
    }

    protected Control createDialogArea(Composite composite) {
        this.mComposite = composite;
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite3.setLayout((Layout)gridLayout);
        this.createFileSetNamePart(composite3);
        this.createAuditConfigSelectionPart(composite3);
        this.createFileMatchPatternPart(composite3);
        composite3.layout();
        return composite2;
    }

    private void createFileSetNamePart(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText("File Set Name:");
        this.mFileSetNameText = new Text(composite2, 2052);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 2;
        gridData.grabExcessVerticalSpace = false;
        gridData.widthHint = this.convertWidthInCharsToPixels(40);
        gridData.heightHint = this.convertHeightInCharsToPixels(1);
        this.mFileSetNameText.setLayoutData((Object)gridData);
        this.mFileSetNameText.setFont(composite.getFont());
        if (this.mFileSet != null) {
            this.mFileSetNameText.setText(this.mFileSet.getName());
        }
    }

    private void createAuditConfigSelectionPart(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText("Check Configuration:");
        List list = null;
        try {
            list = CheckConfigurationFactory.getCheckConfigurations();
        }
        catch (CheckstylePluginException checkstylePluginException) {
            CheckstyleLog.error("Failed to get list of CheckConfiguration objects, " + checkstylePluginException.getMessage(), checkstylePluginException);
            CheckstyleLog.internalErrorDialog();
            return;
        }
        Collections.sort(list);
        this.mAuditConfigs = new CheckConfiguration[list.size()];
        String[] stringArray = new String[list.size()];
        int n = -1;
        Iterator iterator = list.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            CheckConfiguration checkConfiguration;
            CheckConfiguration checkConfiguration2;
            this.mAuditConfigs[n2] = checkConfiguration2 = (CheckConfiguration)iterator.next();
            stringArray[n2] = checkConfiguration2.getConfigName();
            if (this.mFileSet != null && (checkConfiguration = this.mFileSet.getCheckConfig()) != null && checkConfiguration.getConfigName().equals(checkConfiguration2.getConfigName())) {
                n = n2;
            }
            ++n2;
        }
        this.mAuditConfigCombo = new Combo(composite2, 12);
        this.mAuditConfigCombo.setLayoutData((Object)new GridData(256));
        this.mAuditConfigCombo.setItems(stringArray);
        if (n >= 0 && n < stringArray.length) {
            this.mAuditConfigCombo.select(n);
        }
    }

    private void createFileMatchPatternPart(Composite composite) {
        FileMatchPattern fileMatchPattern;
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Table table = new Table(composite2, 67616);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gridData = new GridData(1808);
        gridData.widthHint = this.convertWidthInCharsToPixels(80);
        gridData.heightHint = this.convertHeightInCharsToPixels(10);
        table.setLayoutData((Object)gridData);
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setText("Include");
        tableColumn.setResizable(false);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(10));
        TableColumn tableColumn2 = new TableColumn(table, 0);
        tableColumn2.setText("File Matching Regular Expression");
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40));
        this.mViewer = new CheckboxTableViewer(table);
        this.mViewer.setLabelProvider((IBaseLabelProvider)new FileMatchPatternLabelProvider());
        this.mViewer.setContentProvider((IContentProvider)new FileMatchPatternProvider());
        this.mViewer.setSorter((ViewerSorter)new FileMatchPatternViewerSorter());
        Iterator iterator = this.mFileMatchPatterns.iterator();
        this.mViewer.setInput((Object)this.mFileMatchPatterns);
        while (iterator.hasNext()) {
            fileMatchPattern = (FileMatchPattern)iterator.next();
            this.mViewer.setChecked((Object)fileMatchPattern, fileMatchPattern.isIncludePattern());
        }
        this.mViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                FileSetEditDialog.this.editFileMatchPattern();
            }
        });
        this.mViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                FileSetEditDialog.this.changeIncludeState(checkStateChangedEvent);
            }
        });
        fileMatchPattern = new Composite(composite2, 0);
        fileMatchPattern.setLayoutData(new GridData(2));
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        fileMatchPattern.setLayout((Layout)gridLayout);
        this.mAddButton = this.createPushButton((Composite)fileMatchPattern, "Add...");
        this.mAddButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FileSetEditDialog.this.addFileMatchPattern();
            }
        });
        this.mEditButton = this.createPushButton((Composite)fileMatchPattern, "Edit...");
        this.mEditButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FileSetEditDialog.this.editFileMatchPattern();
            }
        });
        this.mRemoveButton = this.createPushButton((Composite)fileMatchPattern, "Remove");
        this.mRemoveButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FileSetEditDialog.this.removeFileMatchPattern();
            }
        });
        this.mTestButton = this.createPushButton((Composite)fileMatchPattern, "Test...");
        this.mTestButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FileSetEditDialog.this.testFileMatchPattern();
            }
        });
        this.mUpButton = this.createPushButton((Composite)fileMatchPattern, " Up ");
        this.mUpButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FileSetEditDialog.this.upFileMatchPattern();
            }
        });
        this.mDownButton = this.createPushButton((Composite)fileMatchPattern, " Down ");
        this.mDownButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FileSetEditDialog.this.downFileMatchPattern();
            }
        });
        Text text = new Text(composite2, 74);
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.grabExcessHorizontalSpace = false;
        gridData.widthHint = this.convertWidthInCharsToPixels(80);
        gridData.verticalAlignment = 2;
        gridData.grabExcessVerticalSpace = false;
        text.setLayoutData((Object)gridData);
        text.setFont(composite.getFont());
        text.setText(NOTE_TEXT);
    }

    protected void okPressed() {
        String string = this.mFileSetNameText.getText();
        if (string == null || string.trim().length() <= 0) {
            MessageDialog.openError((Shell)this.mComposite.getShell(), (String)"Validation Error", (String)"A FileSet name must be provided");
            return;
        }
        int n = this.mAuditConfigCombo.getSelectionIndex();
        if (n < 0 || n >= this.mAuditConfigs.length) {
            MessageDialog.openError((Shell)this.mComposite.getShell(), (String)"Validation Error", (String)"An Audit Configuration must be selected");
            return;
        }
        boolean bl = true;
        if (this.mFileSet != null) {
            bl = this.mFileSet.isEnabled();
        }
        this.mFileSet = new FileSet(string, this.mAuditConfigs[n]);
        this.mFileSet.setFileMatchPatterns(this.mFileMatchPatterns);
        this.mFileSet.setEnabled(bl);
        this.mOkWasPressed = true;
        super.okPressed();
    }

    private Button createPushButton(Composite composite, String string) {
        Button button = new Button(composite, 8);
        button.setText(string);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        button.setLayoutData((Object)gridData);
        return button;
    }

    private void addFileMatchPattern() {
        FileMatchPatternEditDialog fileMatchPatternEditDialog = new FileMatchPatternEditDialog(this.mComposite.getShell(), null);
        fileMatchPatternEditDialog.open();
        if (fileMatchPatternEditDialog.okWasPressed()) {
            String string = fileMatchPatternEditDialog.getPattern();
            try {
                FileMatchPattern fileMatchPattern = new FileMatchPattern(string);
                this.mFileMatchPatterns.add(fileMatchPattern);
                this.mViewer.refresh();
                this.mViewer.setChecked((Object)fileMatchPattern, fileMatchPattern.isIncludePattern());
            }
            catch (CheckstylePluginException checkstylePluginException) {
                CheckstyleLog.error("Failed to create FileMatchPattern object <" + string + ">, " + checkstylePluginException.getMessage(), checkstylePluginException);
                CheckstyleLog.internalErrorDialog();
            }
        }
    }

    private void editFileMatchPattern() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.mViewer.getSelection();
        FileMatchPattern fileMatchPattern = (FileMatchPattern)iStructuredSelection.getFirstElement();
        if (fileMatchPattern == null) {
            return;
        }
        FileMatchPatternEditDialog fileMatchPatternEditDialog = new FileMatchPatternEditDialog(this.mComposite.getShell(), fileMatchPattern.getMatchPattern());
        fileMatchPatternEditDialog.open();
        if (fileMatchPatternEditDialog.okWasPressed()) {
            String string = fileMatchPatternEditDialog.getPattern();
            try {
                FileMatchPattern fileMatchPattern2 = new FileMatchPattern(string);
                fileMatchPattern2.setIsIncludePattern(fileMatchPattern.isIncludePattern());
                this.mFileMatchPatterns.remove(fileMatchPattern);
                this.mFileMatchPatterns.add(fileMatchPattern2);
                this.mViewer.refresh();
                this.mViewer.setChecked((Object)fileMatchPattern2, fileMatchPattern2.isIncludePattern());
            }
            catch (CheckstylePluginException checkstylePluginException) {
                CheckstyleLog.error("Failed to create FileMatchPattern object <" + string + ">, " + checkstylePluginException.getMessage(), checkstylePluginException);
                CheckstyleLog.internalErrorDialog();
            }
        }
    }

    private void removeFileMatchPattern() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.mViewer.getSelection();
        FileMatchPattern fileMatchPattern = (FileMatchPattern)iStructuredSelection.getFirstElement();
        if (fileMatchPattern == null) {
            return;
        }
        this.mFileMatchPatterns.remove(fileMatchPattern);
        this.mViewer.refresh();
    }

    private void changeIncludeState(CheckStateChangedEvent checkStateChangedEvent) {
        if (checkStateChangedEvent.getElement() instanceof FileMatchPattern) {
            FileMatchPattern fileMatchPattern = (FileMatchPattern)checkStateChangedEvent.getElement();
            fileMatchPattern.setIsIncludePattern(checkStateChangedEvent.getChecked());
            this.mViewer.refresh();
        } else {
            CheckstyleLog.warning("Checked element in FileMatchPattern table not  a FileMatchPattern");
        }
    }

    private void testFileMatchPattern() {
        Object object;
        LinkedList<IFile> linkedList = new LinkedList<IFile>();
        try {
            object = this.getFiles((IContainer)this.mProject);
            Iterator iterator = object.iterator();
            FileSet fileSet = new FileSet(null, null);
            fileSet.setFileMatchPatterns(this.mFileMatchPatterns);
            while (iterator.hasNext()) {
                IFile iFile = (IFile)iterator.next();
                if (!fileSet.includesFile(iFile)) continue;
                linkedList.add(iFile);
            }
        }
        catch (CheckstylePluginException checkstylePluginException) {
            CheckstyleLog.error("Failed to generate FileSet test results", checkstylePluginException);
            CheckstyleLog.internalErrorDialog();
            return;
        }
        catch (CoreException coreException) {
            CheckstyleLog.error("Failed to generate FileSet test results", coreException);
            CheckstyleLog.internalErrorDialog();
            return;
        }
        object = new TestResultsDialog(this.mComposite.getShell(), linkedList);
        object.open();
    }

    private void upFileMatchPattern() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.mViewer.getSelection();
        FileMatchPattern fileMatchPattern = (FileMatchPattern)iStructuredSelection.getFirstElement();
        if (fileMatchPattern == null) {
            return;
        }
        int n = this.mFileMatchPatterns.indexOf(fileMatchPattern);
        if (n > 0) {
            this.mFileMatchPatterns.remove(fileMatchPattern);
            this.mFileMatchPatterns.add(n - 1, fileMatchPattern);
            this.mViewer.refresh();
        }
    }

    private void downFileMatchPattern() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.mViewer.getSelection();
        FileMatchPattern fileMatchPattern = (FileMatchPattern)iStructuredSelection.getFirstElement();
        if (fileMatchPattern == null) {
            return;
        }
        int n = this.mFileMatchPatterns.indexOf(fileMatchPattern);
        if (n >= 0 && n < this.mFileMatchPatterns.size() - 1) {
            this.mFileMatchPatterns.remove(fileMatchPattern);
            if (n < this.mFileMatchPatterns.size() - 1) {
                this.mFileMatchPatterns.add(n + 1, fileMatchPattern);
            } else {
                this.mFileMatchPatterns.add(fileMatchPattern);
            }
            this.mViewer.refresh();
        }
    }

    boolean okWasPressed() {
        return this.mOkWasPressed;
    }

    FileSet getFileSet() {
        return this.mFileSet;
    }

    private List getFiles(IContainer iContainer) throws CoreException {
        LinkedList<IResource> linkedList = new LinkedList<IResource>();
        LinkedList<IResource> linkedList2 = new LinkedList<IResource>();
        IResource[] iResourceArray = iContainer.members();
        for (int i = 0; i < iResourceArray.length; ++i) {
            IResource iResource = iResourceArray[i];
            int n = iResource.getType();
            if (n == 1) {
                if (!iResource.getName().endsWith(JAVA_SUFFIX)) continue;
                linkedList.add(iResource);
                continue;
            }
            if (n != 2) continue;
            linkedList2.add(iResource);
        }
        Iterator iterator = linkedList2.iterator();
        while (iterator.hasNext()) {
            linkedList.addAll(this.getFiles((IContainer)iterator.next()));
        }
        return linkedList;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Checkstyle File Set Editor");
    }
}

