/*
 * Decompiled with CFR 0.152.
 */
package com.atlassw.tools.eclipse.checkstyle.properties;

import org.apache.regexp.RECompiler;
import org.apache.regexp.RESyntaxException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FileMatchPatternEditDialog
extends Dialog {
    private static final int MAX_LENGTH = 250;
    private Composite mComposite;
    private Text mFileMatchPatternText;
    private String mPattern;
    private String mValidationErrorMsg;
    private boolean mOkWasPressed = false;

    FileMatchPatternEditDialog(Shell shell, String string) {
        super(shell);
        this.mPattern = string;
    }

    protected Control createDialogArea(Composite composite) {
        this.mComposite = composite;
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite3.setLayout((Layout)gridLayout);
        Label label = new Label(composite3, 0);
        label.setText("Match Regular Expression:");
        this.mFileMatchPatternText = new Text(composite3, 2052);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 2;
        gridData.grabExcessVerticalSpace = false;
        gridData.widthHint = this.convertWidthInCharsToPixels(60);
        this.mFileMatchPatternText.setLayoutData((Object)gridData);
        this.mFileMatchPatternText.setFont(composite.getFont());
        if (this.mPattern != null) {
            this.mFileMatchPatternText.setText(this.mPattern);
        }
        composite3.layout();
        return composite2;
    }

    protected void okPressed() {
        this.mPattern = this.mFileMatchPatternText.getText();
        if (this.mPattern == null || this.mPattern.trim().length() == 0) {
            this.mPattern = null;
            super.okPressed();
            return;
        }
        if (!this.validatePattern(this.mPattern)) {
            String string = "The string '" + this.mPattern + "' is not a valid regular expression pattern." + System.getProperty("line.separator") + this.mValidationErrorMsg;
            MessageDialog.openError((Shell)this.mComposite.getShell(), (String)"Pattern Validation Error", (String)string);
            return;
        }
        this.mOkWasPressed = true;
        super.okPressed();
    }

    boolean okWasPressed() {
        return this.mOkWasPressed;
    }

    String getPattern() {
        return this.mPattern;
    }

    private boolean validatePattern(String string) {
        boolean bl = false;
        try {
            RECompiler rECompiler = new RECompiler();
            rECompiler.compile(string);
            bl = true;
        }
        catch (RESyntaxException rESyntaxException) {
            this.mValidationErrorMsg = rESyntaxException.getMessage();
        }
        return bl;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Checkstyle Regular Expression Editor");
    }
}

