/*
 * Decompiled with CFR 0.152.
 */
package com.atlassw.tools.eclipse.checkstyle.preferences;

import com.atlassw.tools.eclipse.checkstyle.config.ResolvableProperty;
import com.atlassw.tools.eclipse.checkstyle.preferences.ResolvablePropertyEditDialog;
import com.atlassw.tools.eclipse.checkstyle.preferences.ResolvablePropertyLabelProvider;
import com.atlassw.tools.eclipse.checkstyle.preferences.ResolvablePropertyProvider;
import com.atlassw.tools.eclipse.checkstyle.preferences.ResolvablePropertyViewerSorter;
import com.atlassw.tools.eclipse.checkstyle.util.CheckstylePluginException;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ResolvePropertyValuesDialog
extends Dialog {
    private static final int MAX_LENGTH = 40;
    private Composite mParentComposite;
    private TableViewer mViewer;
    private List mProperties;
    private boolean mOkWasPressed = false;

    ResolvePropertyValuesDialog(Shell shell, List list) throws CheckstylePluginException {
        super(shell);
        this.mProperties = list;
    }

    protected Control createDialogArea(Composite composite) {
        this.mParentComposite = composite;
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite3.setLayout((Layout)gridLayout);
        this.createTablePart(composite3);
        composite3.layout();
        return composite2;
    }

    private void createTablePart(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText("Double-click Variable to Edit");
        Table table = new Table(composite2, 67588);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gridData = new GridData(1808);
        gridData.widthHint = this.convertWidthInCharsToPixels(160);
        gridData.heightHint = this.convertHeightInCharsToPixels(10);
        table.setLayoutData((Object)gridData);
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setText("Variable");
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40));
        TableColumn tableColumn2 = new TableColumn(table, 0);
        tableColumn2.setText("Value");
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(120));
        this.mViewer = new TableViewer(table);
        this.mViewer.setLabelProvider((IBaseLabelProvider)new ResolvablePropertyLabelProvider());
        this.mViewer.setContentProvider((IContentProvider)new ResolvablePropertyProvider());
        this.mViewer.setSorter((ViewerSorter)new ResolvablePropertyViewerSorter());
        this.mViewer.setInput((Object)this.mProperties);
        this.mViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                ResolvePropertyValuesDialog.this.editValue();
            }
        });
    }

    private void editValue() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.mViewer.getSelection();
        ResolvableProperty resolvableProperty = (ResolvableProperty)iStructuredSelection.getFirstElement();
        if (resolvableProperty == null) {
            return;
        }
        ResolvablePropertyEditDialog resolvablePropertyEditDialog = new ResolvablePropertyEditDialog(this.mParentComposite.getShell(), resolvableProperty);
        resolvablePropertyEditDialog.open();
        if (resolvablePropertyEditDialog.okWasPressed()) {
            String string = resolvablePropertyEditDialog.getValue();
            if (string == null) {
                string = "";
            }
            resolvableProperty.setValue(string);
            this.mViewer.refresh();
        }
    }

    protected void okPressed() {
        this.mOkWasPressed = true;
        super.okPressed();
    }

    public boolean okWasPressed() {
        return this.mOkWasPressed;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Resolve Variable Property Values");
    }
}

