/*
 * Decompiled with CFR 0.152.
 */
package com.atlassw.tools.eclipse.checkstyle.config;

import com.atlassw.tools.eclipse.checkstyle.config.CheckConfiguration;
import com.atlassw.tools.eclipse.checkstyle.util.CheckstyleLog;
import com.atlassw.tools.eclipse.checkstyle.util.CheckstylePluginException;
import com.atlassw.tools.eclipse.checkstyle.util.XMLUtil;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class CheckstyleConfigurationSerializer {
    private static final String DOCTYPE = "<!DOCTYPE module PUBLIC \"-//Puppy Crawl//DTD Check Configuration 1.1//EN\" \"http://www.puppycrawl.com/dtds/configuration_1_1.dtd\">" + System.getProperty("line.separator");

    private CheckstyleConfigurationSerializer() {
    }

    public static String serialize(CheckConfiguration checkConfiguration) throws CheckstylePluginException {
        String string = null;
        try {
            Document document = XMLUtil.newDocument();
            Element element = document.createElement("module");
            document.appendChild(element);
            element.setAttribute("name", checkConfiguration.getName());
            Configuration[] configurationArray = checkConfiguration.getChildren();
            CheckstyleConfigurationSerializer.serializeConfiguration(configurationArray, document, (Node)element);
            string = XMLUtil.serializeDocument(document, true);
            string = CheckstyleConfigurationSerializer.insertDocType(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string2 = "Failed to write check configuration file: " + exception.getMessage();
            CheckstyleLog.warning(string2, exception);
            throw new CheckstylePluginException(string2);
        }
        return string;
    }

    private static void serializeConfiguration(Configuration[] configurationArray, Document document, Node node) {
        if (configurationArray == null || configurationArray.length < 1) {
            return;
        }
        for (int i = 0; i < configurationArray.length; ++i) {
            Configuration configuration = configurationArray[i];
            Node node2 = CheckstyleConfigurationSerializer.serializeConfiguration(configuration, document, node);
            Configuration[] configurationArray2 = configuration.getChildren();
            CheckstyleConfigurationSerializer.serializeConfiguration(configurationArray2, document, node2);
        }
    }

    private static Node serializeConfiguration(Configuration configuration, Document document, Node node) {
        if (configuration == null) {
            return null;
        }
        String string = configuration.getName();
        String[] stringArray = configuration.getAttributeNames();
        Element element = document.createElement("module");
        element.setAttribute("name", string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            try {
                String string3 = stringArray[i];
                string2 = configuration.getAttribute(string3);
                Node node2 = CheckstyleConfigurationSerializer.toPropertyNode(document, string3, string2);
                element.appendChild(node2);
                continue;
            }
            catch (CheckstyleException checkstyleException) {
                string2 = "Error serializing check attributes";
                CheckstyleLog.warning(string2, checkstyleException);
            }
        }
        node.appendChild(element);
        return element;
    }

    private static Node toPropertyNode(Document document, String string, String string2) {
        Element element = document.createElement("property");
        element.setAttribute("name", string);
        element.setAttribute("value", string2);
        return element;
    }

    private static String insertDocType(String string) {
        String string2 = null;
        int n = string.indexOf("?>");
        string2 = string.substring(0, n + 3) + DOCTYPE + string.substring(n + 3);
        return string2;
    }
}

