/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.MigLayout.model;

import java.awt.Component;
import java.awt.Container;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.ConstraintParser;
import net.miginfocom.layout.DimConstraint;
import net.miginfocom.layout.IDEUtil;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.InvocationChildAssociation;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.property.ComplexProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.property.converter.StringConverter;
import org.eclipse.wb.internal.core.model.property.editor.EnumCustomPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.IntegerPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.presentation.ButtonPropertyEditorPresentation;
import org.eclipse.wb.internal.core.model.property.editor.presentation.PropertyEditorPresentation;
import org.eclipse.wb.internal.core.model.property.table.PropertyTable;
import org.eclipse.wb.internal.core.model.util.ObjectInfoAction;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;
import org.eclipse.wb.internal.swing.MigLayout.model.MigColumnInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.MigLayoutInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.MigRowInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.ModelMessages;
import org.eclipse.wb.internal.swing.MigLayout.model.ui.CellEditDialog;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;

public final class CellConstraintsSupport {
    private final CellConstraintsSupport m_this = this;
    private final MigLayoutInfo m_layout;
    private final ComponentInfo m_component;
    private boolean m_dirty;
    private int x;
    private int y;
    private int width;
    private int height;
    private CC cc;
    private ComplexProperty m_complexProperty;

    CellConstraintsSupport(MigLayoutInfo layoutInfo, ComponentInfo componentInfo) {
        this.m_layout = layoutInfo;
        this.m_component = componentInfo;
        Container container = this.m_layout.getContainer().getContainer();
        if (this.m_layout.getObject() != null && this.m_component.getComponent() != null && this.m_component.getComponent().getParent() == container) {
            Component component;
            MigLayout layout = (MigLayout)layoutInfo.getObject();
            Object constraints = layout.getComponentConstraints(component = componentInfo.getComponent());
            this.cc = constraints instanceof CC ? (CC)constraints : (constraints instanceof String ? ConstraintParser.parseComponentConstraint((String)((String)constraints)) : new CC());
            int[] gridPosition = (int[])IDEUtil.getGridPositions((Object)container).get(component);
            if (gridPosition != null) {
                this.x = gridPosition[0];
                this.y = gridPosition[1];
                this.width = gridPosition[2];
                this.height = gridPosition[3];
                if (this.width == 30000 - this.x) {
                    int columnCount = IDEUtil.getColumnSizes((Object)container)[0].length;
                    this.width = columnCount - this.x;
                }
            } else {
                this.x = 0;
                this.y = 0;
                this.width = 0;
                this.height = 0;
            }
        } else {
            this.cc = new CC();
            this.x = 0;
            this.y = 0;
            this.width = 1;
            this.height = 1;
        }
    }

    public ComponentInfo getComponent() {
        return this.m_component;
    }

    public void makeExplicitCell() {
        if (this.getDockSide() != null) {
            return;
        }
        if (this.cc.getSplit() != 1) {
            this.cc.setSplit(1);
            this.m_dirty = true;
        }
        if (this.cc.isWrap()) {
            this.cc.setWrap(false);
            this.m_dirty = true;
        }
        if (this.cc.isNewline()) {
            this.cc.setNewline(false);
            this.m_dirty = true;
        }
        if (this.cc.getSkip() != 0) {
            this.cc.setSkip(0);
            this.m_dirty = true;
        }
        this.setX(this.x);
        this.setY(this.y);
        this.setWidth(this.width);
        this.setHeight(this.height);
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
        if (this.cc.getCellX() != x) {
            this.cc.setCellX(x);
            this.m_dirty = true;
        }
    }

    public void updateX(int delta) {
        this.setX(this.getX() + delta);
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
        if (this.cc.getCellY() != y) {
            this.cc.setCellY(y);
            this.m_dirty = true;
        }
    }

    public void updateY(int delta) {
        this.setY(this.getY() + delta);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
        if (this.cc.getSpanX() != width) {
            this.cc.setSpanX(width);
            this.m_dirty = true;
        }
    }

    public void updateWidth(int delta) {
        this.setWidth(this.getWidth() + delta);
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
        if (this.cc.getSpanY() != height) {
            this.cc.setSpanY(height);
            this.m_dirty = true;
        }
    }

    public void updateHeight(int delta) {
        this.setHeight(this.getHeight() + delta);
    }

    public MigColumnInfo.Alignment getHorizontalAlignment() {
        DimConstraint constraint = this.cc.getDimConstraint(true);
        return MigColumnInfo.getAlignment(constraint, false, false);
    }

    public void setHorizontalAlignment(MigColumnInfo.Alignment alignment) {
        DimConstraint constraint = this.cc.getDimConstraint(true);
        MigColumnInfo.setAlignment(constraint, alignment, false);
        this.m_dirty = true;
    }

    public MigRowInfo.Alignment getVerticalAlignment() {
        DimConstraint constraint = this.cc.getDimConstraint(false);
        return MigRowInfo.getAlignment(constraint, false, false);
    }

    public void setVerticalAlignment(MigRowInfo.Alignment alignment) {
        DimConstraint constraint = this.cc.getDimConstraint(false);
        MigRowInfo.setAlignment(constraint, alignment, false);
        this.m_dirty = true;
    }

    public DockSide getDockSide() {
        switch (this.cc.getDockSide()) {
            case 0: {
                return DockSide.NORTH;
            }
            case 1: {
                return DockSide.WEST;
            }
            case 2: {
                return DockSide.SOUTH;
            }
            case 3: {
                return DockSide.EAST;
            }
        }
        return null;
    }

    public void setDockSide(DockSide side) {
        this.m_dirty = true;
        if (side == null) {
            this.cc.setDockSide(-1);
            return;
        }
        switch (side) {
            case NORTH: {
                this.cc.setDockSide(0);
                break;
            }
            case WEST: {
                this.cc.setDockSide(1);
                break;
            }
            case SOUTH: {
                this.cc.setDockSide(2);
                break;
            }
            case EAST: {
                this.cc.setDockSide(3);
            }
        }
    }

    public boolean isHorizontalSplit() {
        Boolean flowX = this.cc.getFlowX();
        if (flowX != null) {
            return flowX;
        }
        return this.m_layout.getLC().isFlowX();
    }

    public void setHorizontalSplit(Boolean horizontal) {
        this.cc.setFlowX(horizontal);
        this.m_dirty = true;
    }

    public final String getString() {
        return IDEUtil.getConstraintString((CC)this.cc, (boolean)false);
    }

    public final void setString(String s) {
        s = s.toLowerCase().trim();
        this.cc = ConstraintParser.parseComponentConstraint((String)s);
        this.m_dirty = true;
    }

    public void write() throws Exception {
        if (this.m_dirty) {
            this.write0();
            this.m_dirty = false;
        }
    }

    public void write0() throws Exception {
        String constraintsString = IDEUtil.getConstraintString((CC)this.cc, (boolean)false);
        constraintsString = CellConstraintsSupport.cleanUpSource(constraintsString);
        if (this.m_component.getAssociation() instanceof InvocationChildAssociation) {
            InvocationChildAssociation association = (InvocationChildAssociation)this.m_component.getAssociation();
            MethodInvocation invocation = association.getInvocation();
            String signature = AstNodeUtils.getMethodSignature((MethodInvocation)invocation);
            String constraintsSource = StringConverter.INSTANCE.toJavaSource(null, (Object)constraintsString);
            if (signature.equals("add(java.awt.Component,java.lang.Object)")) {
                Expression constraintsExpression = (Expression)invocation.arguments().get(1);
                this.m_layout.getEditor().replaceExpression(constraintsExpression, constraintsSource);
            } else if (signature.equals("add(java.awt.Component)")) {
                this.m_layout.getEditor().addInvocationArgument(invocation, 1, constraintsSource);
            }
        }
    }

    private static String cleanUpSource(String source) {
        source = CellConstraintsSupport.cleanUpSource_secondGap(source, "gapx", "gapright ");
        if ((source = CellConstraintsSupport.cleanUpSource_secondGap(source, "gapy", "gapbottom ")).contains("hideMode")) {
            source = StringUtils.replace((String)source, (String)"hideMode", (String)"hidemode");
        }
        return source;
    }

    private static String cleanUpSource_secondGap(String source, String sourceName, String targetName) {
        Pattern pattern = Pattern.compile(String.valueOf(sourceName) + " null (\\w+)(\\,|\\z)");
        Matcher matcher = pattern.matcher(source);
        if (matcher.find()) {
            String actualGap = matcher.group(1);
            String optionalComma = matcher.group().endsWith(",") ? "," : "";
            source = String.valueOf(source.substring(0, matcher.start())) + targetName + actualGap + optionalComma + source.substring(matcher.end());
        }
        return source;
    }

    public Property getPropertyByTitle(String title) throws Exception {
        Property[] propertyArray = this.getCellProperty().getProperties();
        int n = propertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Property property = propertyArray[n2];
            if (property.getTitle().equals(title)) {
                return property;
            }
            ++n2;
        }
        return null;
    }

    public ComplexProperty getCellProperty() throws Exception {
        if (this.m_complexProperty == null) {
            this.m_complexProperty = new ComplexProperty("Constraints", null);
            this.m_complexProperty.setCategory(PropertyCategory.system((int)6));
            this.m_complexProperty.setEditorPresentation((PropertyEditorPresentation)new ButtonPropertyEditorPresentation(){

                protected void onClick(PropertyTable propertyTable, Property property) throws Exception {
                    new CellEditDialog(propertyTable.getShell(), CellConstraintsSupport.this.m_layout, CellConstraintsSupport.this.m_this).open();
                }
            });
            IntegerCellProperty xProperty = new IntegerCellProperty("grid x", "getX()", "setX(int)"){

                public boolean isModified() throws Exception {
                    return true;
                }

                protected String validate(int value) {
                    int columns = CellConstraintsSupport.this.m_layout.getColumns().size();
                    if (value >= 0 && value + CellConstraintsSupport.this.width <= columns) {
                        return null;
                    }
                    return MessageFormat.format(ModelMessages.CellConstraintsSupport_gridX_outOfRange, value, columns - CellConstraintsSupport.this.width);
                }
            };
            IntegerCellProperty wProperty = new IntegerCellProperty("grid width", "getWidth()", "setWidth(int)"){

                public boolean isModified() throws Exception {
                    return CellConstraintsSupport.this.width != 1;
                }

                protected Object getDefaultValue() {
                    return 1;
                }

                protected String validate(int value) {
                    int columns = CellConstraintsSupport.this.m_layout.getColumns().size();
                    if (1 <= value && CellConstraintsSupport.this.x + value <= columns) {
                        return null;
                    }
                    return MessageFormat.format(ModelMessages.CellConstraintsSupport_gridWidth_outOfRange, value, columns - CellConstraintsSupport.this.x);
                }
            };
            IntegerCellProperty yProperty = new IntegerCellProperty("grid y", "getY()", "setY(int)"){

                public boolean isModified() throws Exception {
                    return true;
                }

                protected String validate(int value) {
                    int rows = CellConstraintsSupport.this.m_layout.getRows().size();
                    if (value >= 0 && value + CellConstraintsSupport.this.height <= rows) {
                        return null;
                    }
                    return MessageFormat.format(ModelMessages.CellConstraintsSupport_gridY_outOfRange, value, rows - CellConstraintsSupport.this.y - 1);
                }
            };
            IntegerCellProperty hProperty = new IntegerCellProperty("grid height", "getHeight()", "setHeight(int)"){

                public boolean isModified() throws Exception {
                    return CellConstraintsSupport.this.height != 1;
                }

                protected Object getDefaultValue() {
                    return 1;
                }

                protected String validate(int value) {
                    int rows = CellConstraintsSupport.this.m_layout.getRows().size();
                    if (1 <= value && CellConstraintsSupport.this.y + value <= rows) {
                        return null;
                    }
                    return MessageFormat.format(ModelMessages.CellConstraintsSupport_gridHeight_outOfRange, value, rows - CellConstraintsSupport.this.y);
                }
            };
            this.m_complexProperty.setProperties(new Property[]{xProperty, yProperty, wProperty, hProperty, this.getHorizontalAlignmentProperty(), this.getVerticalAlignmentProperty()});
        }
        this.m_complexProperty.setText(IDEUtil.getConstraintString((CC)this.cc, (boolean)false));
        return this.m_complexProperty;
    }

    private Property getHorizontalAlignmentProperty() throws Exception {
        return new AlignmentCellProperty(this, "h alignment", "getHorizontalAlignment()", "setHorizontalAlignment(org.eclipse.wb.internal.swing.MigLayout.model.MigColumnInfo.Alignment)", (Enum[])MigColumnInfo.ALIGNMENTS_TO_SET, (Enum)MigColumnInfo.Alignment.DEFAULT);
    }

    private Property getVerticalAlignmentProperty() throws Exception {
        return new AlignmentCellProperty(this, "v alignment", "getVerticalAlignment()", "setVerticalAlignment(org.eclipse.wb.internal.swing.MigLayout.model.MigRowInfo.Alignment)", (Enum[])MigRowInfo.ALIGNMENTS_TO_SET, (Enum)MigRowInfo.Alignment.DEFAULT);
    }

    public Image getSmallAlignmentImage(boolean horizontal) {
        if (horizontal) {
            return this.getHorizontalAlignment().getSmallImage();
        }
        return this.getVerticalAlignment().getSmallImage();
    }

    public void addContextMenu(IMenuManager manager) throws Exception {
        manager.appendToGroup("org.eclipse.wb.popup.group.top", (IAction)new Action("Constraints..."){

            public void run() {
                new CellEditDialog(DesignerPlugin.getShell(), CellConstraintsSupport.this.m_layout, CellConstraintsSupport.this.m_this).open();
            }
        });
        MenuManager manager2 = new MenuManager(ModelMessages.CellConstraintsSupport_horizontalAlignment);
        manager.appendToGroup("org.eclipse.wb.popup.group.top", (IContributionItem)manager2);
        this.fillHorizontalAlignmentMenu((IMenuManager)manager2);
        manager2 = new MenuManager(ModelMessages.CellConstraintsSupport_verticalAlignment);
        manager.appendToGroup("org.eclipse.wb.popup.group.top", (IContributionItem)manager2);
        this.fillVerticalAlignmentMenu((IMenuManager)manager2);
    }

    public void fillHorizontalAlignmentMenu(IMenuManager manager) {
        manager.add((IAction)new SetHorizontalAlignmentAction(ModelMessages.CellConstraintsSupport_horizontalAlignment_default, MigColumnInfo.Alignment.DEFAULT));
        manager.add((IAction)new SetHorizontalAlignmentAction(ModelMessages.CellConstraintsSupport_horizontalAlignment_left, MigColumnInfo.Alignment.LEFT));
        manager.add((IAction)new SetHorizontalAlignmentAction(ModelMessages.CellConstraintsSupport_horizontalAlignment_center, MigColumnInfo.Alignment.CENTER));
        manager.add((IAction)new SetHorizontalAlignmentAction(ModelMessages.CellConstraintsSupport_horizontalAlignment_right, MigColumnInfo.Alignment.RIGHT));
        manager.add((IAction)new SetHorizontalAlignmentAction(ModelMessages.CellConstraintsSupport_horizontalAlignment_fill, MigColumnInfo.Alignment.FILL));
        manager.add((IAction)new SetHorizontalAlignmentAction(ModelMessages.CellConstraintsSupport_horizontalAlignment_leading, MigColumnInfo.Alignment.LEADING));
        manager.add((IAction)new SetHorizontalAlignmentAction(ModelMessages.CellConstraintsSupport_horizontalAlignment_trailing, MigColumnInfo.Alignment.TRAILING));
    }

    public void fillVerticalAlignmentMenu(IMenuManager manager2) {
        manager2.add((IAction)new SetVerticalAlignmentAction(ModelMessages.CellConstraintsSupport_verticalAlignment_default, MigRowInfo.Alignment.DEFAULT));
        manager2.add((IAction)new SetVerticalAlignmentAction(ModelMessages.CellConstraintsSupport_verticalAlignment_top, MigRowInfo.Alignment.TOP));
        manager2.add((IAction)new SetVerticalAlignmentAction(ModelMessages.CellConstraintsSupport_verticalAlignment_center, MigRowInfo.Alignment.CENTER));
        manager2.add((IAction)new SetVerticalAlignmentAction(ModelMessages.CellConstraintsSupport_verticalAlignment_bottom, MigRowInfo.Alignment.BOTTOM));
        manager2.add((IAction)new SetVerticalAlignmentAction(ModelMessages.CellConstraintsSupport_verticalAlignment_fill, MigRowInfo.Alignment.FILL));
        manager2.add((IAction)new SetVerticalAlignmentAction(ModelMessages.CellConstraintsSupport_verticalAlignment_baseline, MigRowInfo.Alignment.BASELINE));
    }

    private abstract class AbstractCellProperty
    extends Property {
        private final String m_title;
        protected final String m_getterSignature;
        protected final String m_setterSignature;

        public AbstractCellProperty(String title, String getterSignature, String setterSignature, PropertyEditor propertyEditor) throws Exception {
            super(propertyEditor);
            this.m_title = title;
            this.m_getterSignature = getterSignature;
            this.m_setterSignature = setterSignature;
        }

        public final String getTitle() {
            return this.m_title;
        }

        public final void setValue(Object value) throws Exception {
            if (value == UNKNOWN_VALUE) {
                value = this.getDefaultValue();
            }
            if (value != UNKNOWN_VALUE) {
                String errorMessage = this.validate(value);
                if (errorMessage != null) {
                    UiUtils.openWarning((Shell)DesignerPlugin.getShell(), (String)this.getTitle(), (String)errorMessage);
                    return;
                }
                this.doSetValue(value);
            }
        }

        private void doSetValue(final Object value) {
            ExecutionUtils.run((ObjectInfo)CellConstraintsSupport.this.m_layout, (RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    ReflectionUtils.invokeMethod((Object)CellConstraintsSupport.this.m_this, (String)AbstractCellProperty.this.m_setterSignature, (Object[])new Object[]{value});
                    CellConstraintsSupport.this.write();
                }
            });
        }

        protected Object getDefaultValue() {
            return UNKNOWN_VALUE;
        }

        public Object getValue() throws Exception {
            return ReflectionUtils.invokeMethod((Object)CellConstraintsSupport.this.m_this, (String)this.m_getterSignature, (Object[])new Object[0]);
        }

        protected abstract String validate(Object var1) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AlignmentCellProperty<A extends Enum<?>>
    extends AbstractCellProperty {
        private final A m_defaultValue;
        final /* synthetic */ CellConstraintsSupport this$0;

        public AlignmentCellProperty(String title, String getterSignature, String setterSignature, A[] alignments, A defaultValue) throws Exception {
            this.this$0 = var1_1;
            super(title, getterSignature, setterSignature, (PropertyEditor)new EnumCustomPropertyEditor());
            EnumCustomPropertyEditor editor = (EnumCustomPropertyEditor)this.getEditor();
            editor.configure(alignments);
            this.m_defaultValue = defaultValue;
        }

        public final boolean isModified() throws Exception {
            return this.getValue() != this.m_defaultValue;
        }

        @Override
        protected Object getDefaultValue() {
            return this.m_defaultValue;
        }

        @Override
        protected String validate(Object value) throws Exception {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DockSide {
        NORTH,
        WEST,
        SOUTH,
        EAST;

    }

    private abstract class IntegerCellProperty
    extends AbstractCellProperty {
        public IntegerCellProperty(String title, String getterSignature, String setterSignature) throws Exception {
            super(title, getterSignature, setterSignature, (PropertyEditor)IntegerPropertyEditor.INSTANCE);
        }

        protected final String validate(Object value) throws Exception {
            if (!(value instanceof Integer)) {
                return ModelMessages.CellConstraintsSupport_integerValueExpected;
            }
            int intValue = (Integer)value;
            return this.validate(intValue);
        }

        protected abstract String validate(int var1);
    }

    private class SetHorizontalAlignmentAction
    extends ObjectInfoAction {
        private final MigColumnInfo.Alignment m_alignment;

        public SetHorizontalAlignmentAction(String text, MigColumnInfo.Alignment alignment) {
            super((ObjectInfo)CellConstraintsSupport.this.m_layout, text, 8);
            this.m_alignment = alignment;
            this.setImageDescriptor(alignment.getMenuImage());
            this.setChecked(CellConstraintsSupport.this.getHorizontalAlignment() == this.m_alignment);
        }

        protected void runEx() throws Exception {
            CellConstraintsSupport.this.setHorizontalAlignment(this.m_alignment);
            CellConstraintsSupport.this.write();
        }
    }

    private class SetVerticalAlignmentAction
    extends ObjectInfoAction {
        private final MigRowInfo.Alignment m_alignment;

        public SetVerticalAlignmentAction(String text, MigRowInfo.Alignment alignment) {
            super((ObjectInfo)CellConstraintsSupport.this.m_layout, text, 8);
            this.m_alignment = alignment;
            this.setImageDescriptor(alignment.getMenuImage());
            this.setChecked(CellConstraintsSupport.this.getVerticalAlignment() == this.m_alignment);
        }

        protected void runEx() throws Exception {
            CellConstraintsSupport.this.setVerticalAlignment(this.m_alignment);
            CellConstraintsSupport.this.write();
        }
    }
}

